/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.push;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.MultipleRepositoryAction;
import org.netbeans.modules.git.ui.push.Bundle;
import org.netbeans.modules.git.ui.push.PushAction;
import org.netbeans.modules.git.ui.push.PushMapping;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class PushToUpstreamAction
extends MultipleRepositoryAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/git/resources/icons/push.png";

    public PushToUpstreamAction() {
        super(ICON_RESOURCE);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected RequestProcessor.Task performAction(File repository, File[] roots, VCSContext context) {
        return this.push(repository, GitUtils.getRepositoryRoots(context));
    }

    RequestProcessor.Task push(final File repository, final Set<File> repositories) {
        final RequestProcessor.Task[] t = new RequestProcessor.Task[1];
        GitProgressSupport.NoOutputLogging supp = new GitProgressSupport.NoOutputLogging(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            protected void perform() {
                String remoteBranchName;
                RepositoryInfo info = RepositoryInfo.getInstance(repository);
                info.refresh();
                GitBranch activeBranch = info.getActiveBranch();
                if (activeBranch == null) {
                    return;
                }
                String errorLabel = Bundle.LBL_Push_pushToUpstreamFailed();
                if ("(no branch)".equals(activeBranch.getName())) {
                    GitUtils.notifyError(errorLabel, Bundle.MSG_Err_noBranchState());
                    return;
                }
                RepositoryInfo.PushMode pushMode = info.getPushMode();
                GitBranch trackedBranch = PushToUpstreamAction.this.getTrackedBranch(activeBranch, pushMode, errorLabel);
                GitRemoteConfig cfg = PushToUpstreamAction.getRemoteConfigForActiveBranch(trackedBranch, info, errorLabel);
                if (cfg == null) {
                    return;
                }
                String uri = cfg.getPushUris().isEmpty() ? (String)cfg.getUris().get(0) : (String)cfg.getPushUris().get(0);
                LinkedList<PushMapping> pushMappings = new LinkedList<PushMapping>();
                List fetchSpecs = cfg.getFetchRefSpecs();
                String trackedBranchId = null;
                if (trackedBranch == null) {
                    if (!PushToUpstreamAction.shallCreateNewBranch(activeBranch)) return;
                    remoteBranchName = activeBranch.getName();
                } else {
                    trackedBranchId = trackedBranch.getId();
                    remoteBranchName = PushToUpstreamAction.guessRemoteBranchName(fetchSpecs, trackedBranch.getName(), cfg.getRemoteName());
                    if (remoteBranchName == null) {
                        GitUtils.notifyError(errorLabel, Bundle.MSG_Err_unknownRemoteBranchName(trackedBranch.getName()));
                        return;
                    }
                }
                pushMappings.add(new PushMapping.PushBranchMapping(remoteBranchName, trackedBranchId, activeBranch, false, false));
                Utils.logVCSExternalRepository((String)"GIT", (String)uri);
                if (this.isCanceled()) return;
                t[0] = ((PushAction)SystemAction.get(PushAction.class)).push(repository, uri, pushMappings, cfg.getFetchRefSpecs(), null, repositories, true);
            }
        };
        supp.start(Git.getInstance().getRequestProcessor(repository), repository, Bundle.LBL_PushToUpstreamAction_preparing()).waitFinished();
        return t[0];
    }

    private static String parseRemote(String branchName) {
        int pos = branchName.indexOf(47);
        String remoteName = null;
        if (pos > 0) {
            remoteName = branchName.substring(0, pos);
        }
        return remoteName;
    }

    protected GitBranch getTrackedBranch(GitBranch activeBranch, RepositoryInfo.PushMode pushMode, String errorLabel) {
        GitBranch trackedBranch = activeBranch.getTrackedBranch();
        if (trackedBranch != null && !trackedBranch.isRemote()) {
            trackedBranch = null;
        }
        if (trackedBranch != null && pushMode == RepositoryInfo.PushMode.ASK && !("" + PushToUpstreamAction.parseRemote(trackedBranch.getName()) + "/" + activeBranch.getName()).equals(trackedBranch.getName())) {
            trackedBranch = null;
        }
        return trackedBranch;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static GitRemoteConfig getRemoteConfigForActiveBranch(GitBranch trackedBranch, RepositoryInfo info, String errorLabel) {
        GitRemoteConfig cfg;
        block7: {
            Map<String, GitRemoteConfig> remotes = info.getRemotes();
            if (trackedBranch == null) {
                if (remotes.size() == 1) {
                    cfg = remotes.values().iterator().next();
                    break block7;
                } else {
                    if (remotes.isEmpty()) {
                        GitUtils.notifyError(errorLabel, Bundle.MSG_Err_noRemote());
                        return null;
                    }
                    GitUtils.notifyError(errorLabel, Bundle.MSG_Err_moreRemotes(remotes.size()));
                    return null;
                }
            }
            String remoteName = PushToUpstreamAction.parseRemote(trackedBranch.getName());
            GitRemoteConfig gitRemoteConfig = cfg = remoteName == null ? null : remotes.get(remoteName);
            if (cfg == null) {
                GitUtils.notifyError(errorLabel, Bundle.MSG_Err_noRemoteBranch(trackedBranch.getName()));
                return null;
            }
        }
        if (cfg.getPushUris().isEmpty() && cfg.getUris().isEmpty()) {
            GitUtils.notifyError(errorLabel, Bundle.MSG_Err_noUri(cfg.getRemoteName()));
            return null;
        }
        if (cfg.getFetchRefSpecs().isEmpty()) {
            GitUtils.notifyError(errorLabel, Bundle.MSG_Err_noSpecs(cfg.getRemoteName()));
            return null;
        }
        return cfg;
    }

    public static String guessRemoteBranchName(List<String> fetchSpecs, String branchName, String remoteName) {
        String remoteBranchName = null;
        String branchShortName = branchName.startsWith(remoteName) ? branchName.substring(remoteName.length() + 1) : branchName.substring(branchName.indexOf(47) + 1);
        for (String spec : fetchSpecs) {
            int pos;
            if (spec.startsWith("+")) {
                spec = spec.substring(1);
            }
            if ((pos = spec.lastIndexOf(58)) <= 0) continue;
            String left = spec.substring(0, pos);
            String right = spec.substring(pos + 1);
            if (!right.endsWith("refs/remotes/" + branchName) && !right.endsWith("refs/remotes/" + remoteName + "/*")) continue;
            if (left.endsWith("/*")) {
                remoteBranchName = branchShortName;
                break;
            }
            if (!left.startsWith("refs/heads/")) continue;
            remoteBranchName = left.substring("refs/heads/".length());
            break;
        }
        return remoteBranchName;
    }

    private static boolean shallCreateNewBranch(GitBranch branch) {
        return NotifyDescriptor.YES_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Bundle.MSG_Push_createNewBranch(branch.getName()), Bundle.LBL_Push_createNewBranch(), 0, 3));
    }
}

