/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.selenium2.webclient.protractor;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.javascript.nodejs.api.NodeJsSupport;
import org.netbeans.modules.javascript.v8debug.api.Connector;
import org.netbeans.modules.selenium2.api.Utils;
import org.netbeans.modules.selenium2.webclient.api.RunInfo;
import org.netbeans.modules.selenium2.webclient.api.SeleniumRerunHandler;
import org.netbeans.modules.selenium2.webclient.api.TestRunnerReporter;
import org.netbeans.modules.selenium2.webclient.api.Utilities;
import org.netbeans.modules.selenium2.webclient.protractor.preferences.ProtractorPreferences;
import org.netbeans.modules.selenium2.webclient.protractor.preferences.ProtractorPreferencesValidator;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.netbeans.modules.web.common.ui.api.ExternalExecutable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

class ProtractorRunner {
    private static final Logger LOG = Logger.getLogger(ProtractorRunner.class.getName());
    private static final String DEBUG_HOST = "localhost";
    private static final int DEBUG_PORT = 5858;

    ProtractorRunner() {
    }

    public static void runTests(FileObject[] activatedFOs) {
        ProtractorRunner.internalProtractorRunner(activatedFOs, false);
    }

    public static void debugTests(FileObject[] activatedFOs) {
        ProtractorRunner.internalProtractorRunner(activatedFOs, true);
    }

    private static void internalProtractorRunner(FileObject[] activatedFOs, boolean debug) {
        String specs;
        boolean testProject;
        assert (!EventQueue.isDispatchThread());
        Project p = FileOwnerQuery.getOwner((FileObject)activatedFOs[0]);
        if (p == null) {
            return;
        }
        File protractorJasmineNBReporter = InstalledFileLocator.getDefault().locate("protractor/jasmine-netbeans-reporter.js", "org.netbeans.modules.selenium2.webclient.protractor", false);
        if (protractorJasmineNBReporter == null) {
            return;
        }
        File protractorNBConfig = InstalledFileLocator.getDefault().locate("protractor/netbeans-configuration.js", "org.netbeans.modules.selenium2.webclient.protractor", false);
        if (protractorNBConfig == null) {
            return;
        }
        String node = ProtractorRunner.getNode(p);
        if (node == null) {
            ProtractorRunner.openNodeSettings(p);
            return;
        }
        FileObject testsFolder = Utilities.getTestsSeleniumFolder((Project)p, (boolean)true);
        if (testsFolder == null) {
            Utilities.openCustomizer((Project)p, (String)"SOURCES");
            return;
        }
        String protractor = ProtractorPreferences.getProtractor(p);
        String userConfigurationFile = ProtractorPreferences.getUserConfigurationFile(p);
        ValidationResult validationResult = new ProtractorPreferencesValidator().validateProtractor(protractor).validateUserConfigurationFile(p, userConfigurationFile).getResult();
        if (protractor == null || protractor.isEmpty() || !validationResult.isFaultless()) {
            Utilities.openCustomizer((Project)p, (String)"SELENIUM_TESTING");
            return;
        }
        boolean bl = testProject = activatedFOs.length == 1 && activatedFOs[0].equals(p.getProjectDirectory());
        if (testProject) {
            specs = FileUtil.toFile((FileObject)testsFolder).getAbsolutePath() + "/**/*.js";
        } else {
            ArrayList<String> files2test = new ArrayList<String>();
            for (FileObject fo : activatedFOs) {
                if (fo.isFolder()) {
                    Enumeration children = fo.getChildren(true);
                    while (children.hasMoreElements()) {
                        ProtractorRunner.add2specs((FileObject)children.nextElement(), files2test);
                    }
                    continue;
                }
                ProtractorRunner.add2specs(fo, files2test);
            }
            String specs2test = files2test.toString();
            specs = specs2test.substring(1, specs2test.length() - 1);
        }
        RunInfo runInfo = ProtractorRunner.getRunInfo(p, activatedFOs, testsFolder, specs, protractorJasmineNBReporter.getAbsolutePath(), userConfigurationFile, testProject);
        String displayname = ProjectUtils.getInformation((Project)runInfo.getProject()).getDisplayName() + " Selenium Tests";
        ExternalExecutable externalexecutable = new ExternalExecutable(node).workDir(FileUtil.toFile((FileObject)p.getProjectDirectory())).displayName(displayname).additionalParameters(ProtractorRunner.getAdditionalArguments(protractor, protractorNBConfig.getAbsolutePath(), debug)).environmentVariables(runInfo.getEnvVars());
        TestRunnerReporter testRunnerReporter = new TestRunnerReporter(runInfo, "jasmine-netbeans-reporter ");
        CountDownLatch countDownLatch = new CountDownLatch(1);
        ExecutionDescriptor.LineConvertorFactory outputLineConvertorFactory = ProtractorRunner.getOutputLineConvertorFactory(testRunnerReporter, runInfo, countDownLatch, debug);
        ExecutionDescriptor descriptor = new ExecutionDescriptor().frontWindow(true).controllable(true).showProgress(true).showSuspended(true).outLineBased(true).errLineBased(true).outConvertorFactory(outputLineConvertorFactory);
        final Future task = externalexecutable.run(descriptor);
        if (debug) {
            try {
                countDownLatch.await(15L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            Connector.Properties props = ProtractorRunner.createConnectorProperties(DEBUG_HOST, 5858, p);
            try {
                Connector.connect((Connector.Properties)props, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        task.cancel(true);
                    }
                });
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    @CheckForNull
    private static String getNode(@NullAllowed Project project) {
        return NodeJsSupport.getInstance().getNode(project);
    }

    private static void openNodeSettings(@NullAllowed Project project) {
        NodeJsSupport.getInstance().openNodeSettings(project);
    }

    private static void add2specs(FileObject fo, ArrayList<String> files2test) {
        String file2test = FileUtil.toFile((FileObject)fo).getAbsolutePath();
        if (file2test != null && !files2test.contains(file2test)) {
            files2test.add(file2test);
        }
    }

    private static ExecutionDescriptor.LineConvertorFactory getOutputLineConvertorFactory(final TestRunnerReporter testRunnerReporter, final RunInfo runInfo, final CountDownLatch countDownLatch, boolean debug) {
        if (!debug) {
            return new ExecutionDescriptor.LineConvertorFactory(){

                public LineConvertor newLineConvertor() {
                    return new OutputLineConvertor(testRunnerReporter, runInfo, null);
                }
            };
        }
        final Runnable countDownTask = new Runnable(){

            @Override
            public void run() {
                countDownLatch.countDown();
            }
        };
        return new ExecutionDescriptor.LineConvertorFactory(){

            public LineConvertor newLineConvertor() {
                return new OutputLineConvertor(testRunnerReporter, runInfo, countDownTask);
            }
        };
    }

    private static ArrayList<String> getAdditionalArguments(String protractor, String config, boolean debug) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(protractor);
        if (debug) {
            arguments.add("--debug-brk");
        }
        arguments.add(config);
        return arguments;
    }

    private static RunInfo getRunInfo(Project p, FileObject[] activatedFOs, FileObject testsFolder, String specs, String jasmineNBReporter, String userConfigurationFile, boolean testProject) {
        RunInfo.Builder builder = new RunInfo.Builder(activatedFOs).setTestingProject(testProject).addEnvVar("SPECS", specs).addEnvVar("JASMINE_NB_REPORTER", jasmineNBReporter).addEnvVar("USER_CONFIGURATION_FILE", userConfigurationFile).setRerunHandler((RerunHandler)new SeleniumRerunHandler(p, activatedFOs, "Protractor", true)).setIsSelenium(true).setShowOutput(false);
        if (activatedFOs.length == 1 && !activatedFOs[0].equals(p.getProjectDirectory())) {
            String testFile = FileUtil.getRelativePath((FileObject)testsFolder, (FileObject)activatedFOs[0]);
            builder = builder.setTestFile(testFile);
        }
        return builder.build();
    }

    private static Connector.Properties createConnectorProperties(String host, int port, Project project) {
        List<File> sourceRoots = ProtractorRunner.getRoots(project, "HTML5-Sources");
        List<File> siteRoots = ProtractorRunner.getRoots(project, "HTML5-SiteRoot");
        List<File> testRoots = ProtractorRunner.getRoots(project, "HTML5-Tests");
        ArrayList<String> localPaths = new ArrayList<String>(sourceRoots.size());
        ArrayList<String> localPathsExclusionFilter = Collections.EMPTY_LIST;
        for (File src : sourceRoots) {
            localPaths.add(src.getAbsolutePath());
            for (File site : siteRoots) {
                if (!ProtractorRunner.isSubdirectoryOf(src, site)) continue;
                if (localPathsExclusionFilter.isEmpty()) {
                    localPathsExclusionFilter = new ArrayList<String>();
                }
                localPathsExclusionFilter.add(site.getAbsolutePath());
            }
            for (File site : testRoots) {
                if (!ProtractorRunner.isSubdirectoryOf(src, site)) continue;
                if (localPathsExclusionFilter.isEmpty()) {
                    localPathsExclusionFilter = new ArrayList();
                }
                localPathsExclusionFilter.add(site.getAbsolutePath());
            }
        }
        return new Connector.Properties(host, port, localPaths, Collections.EMPTY_LIST, (Collection)localPathsExclusionFilter);
    }

    private static List<File> getRoots(Project project, String type) {
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups(type);
        ArrayList<File> roots = new ArrayList<File>(sourceGroups.length);
        for (SourceGroup sourceGroup : sourceGroups) {
            FileObject rootFolder = sourceGroup.getRootFolder();
            File root = FileUtil.toFile((FileObject)rootFolder);
            assert (root != null) : rootFolder;
            roots.add(root);
        }
        return roots;
    }

    private static boolean isSubdirectoryOf(File folder, File child) {
        String chp;
        String fp;
        if (!folder.isDirectory()) {
            return false;
        }
        try {
            fp = folder.getCanonicalPath();
        }
        catch (IOException ioex) {
            fp = folder.getAbsolutePath();
        }
        try {
            chp = child.getCanonicalPath();
        }
        catch (IOException ioex) {
            chp = child.getAbsolutePath();
        }
        if (!chp.startsWith(fp)) {
            return false;
        }
        int fl = fp.length();
        if (chp.length() == fl) {
            return true;
        }
        char separ = chp.charAt(fl);
        return File.separatorChar == separ;
    }

    private static final class FileOutputListener
    implements OutputListener {
        final File file;
        final int line;
        final int column;

        public FileOutputListener(File file, int line, int column) {
            assert (file != null);
            this.file = file;
            this.line = line;
            this.column = column;
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    Utils.openFile((File)FileOutputListener.this.file, (int)FileOutputListener.this.line, (int)FileOutputListener.this.column);
                }
            });
        }

        public void outputLineCleared(OutputEvent ev) {
        }
    }

    private static class OutputLineConvertor
    implements LineConvertor {
        private final TestRunnerReporter testRunnerReporter;
        private final RunInfo runInfo;
        private Runnable debuggerStartTask;

        public OutputLineConvertor(TestRunnerReporter testRunnerReporter, RunInfo runInfo, Runnable debuggerStartTask) {
            this.testRunnerReporter = testRunnerReporter;
            this.runInfo = runInfo;
            this.debuggerStartTask = debuggerStartTask;
        }

        public List<ConvertedLine> convert(String line) {
            String output2display;
            if (this.debuggerStartTask != null && line.startsWith("debugger listening on port")) {
                this.debuggerStartTask.run();
                this.debuggerStartTask = null;
            }
            if ((output2display = this.testRunnerReporter.processLine(line)) == null) {
                return Collections.EMPTY_LIST;
            }
            TestRunnerReporter.CallStackCallback callStackCallback = new TestRunnerReporter.CallStackCallback(this.runInfo.getProject());
            Pair parsedLocation = callStackCallback.parseLocation(line, false);
            FileOutputListener fileOutputListener = parsedLocation == null ? null : new FileOutputListener((File)parsedLocation.first(), ((int[])parsedLocation.second())[0], ((int[])parsedLocation.second())[1]);
            return Collections.singletonList(ConvertedLine.forText((String)output2display, (OutputListener)fileOutputListener));
        }
    }
}

