/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.chart.bubble;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.chart.BaseChartRenderer;
import org.primefaces.component.chart.UIChart;
import org.primefaces.component.chart.bubble.BubbleChart;
import org.primefaces.model.chart.BubbleChartModel;
import org.primefaces.model.chart.BubbleChartSeries;

public class BubbleChartRenderer
extends BaseChartRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        BubbleChart chart = (BubbleChart)component;
        this.encodeMarkup(context, chart);
        this.encodeScript(context, chart);
    }

    protected void encodeScript(FacesContext context, UIChart uichart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        BubbleChart chart = (BubbleChart)uichart;
        String clientId = chart.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("$(function(){");
        writer.write("PrimeFaces.cw('BubbleChart','" + chart.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        this.encodeData(context, chart);
        this.encodeOptions(context, chart);
        this.encodeClientBehaviors(context, chart);
        writer.write("},'charts');});");
        this.endScript(writer);
    }

    protected void encodeData(FacesContext context, BubbleChart chart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        BubbleChartModel model = chart.getValue();
        List<BubbleChartSeries> data = model.getData();
        writer.write(",data:[[");
        Iterator<BubbleChartSeries> it = data.iterator();
        while (it.hasNext()) {
            BubbleChartSeries s = it.next();
            writer.write("[");
            writer.write(String.valueOf(s.getX()));
            writer.write(",");
            writer.write(String.valueOf(s.getY()));
            writer.write(",");
            writer.write(String.valueOf(s.getRadius()));
            writer.write(",'");
            writer.write(String.valueOf(s.getLabel()));
            writer.write("']");
            if (!it.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]]");
    }

    protected void encodeOptions(FacesContext context, BubbleChart chart) throws IOException {
        super.encodeOptions(context, chart);
        ResponseWriter writer = context.getResponseWriter();
        writer.write(",showLabels:" + chart.isShowLabels());
        writer.write(",bubbleGradients:" + chart.isBubbleGradients());
        writer.write(",bubbleAlpha:" + chart.getBubbleAlpha());
        if (chart.isZoom()) {
            writer.write(",zoom:true");
        }
        if (chart.isShowDatatip()) {
            writer.write(",datatip:true");
            if (chart.getDatatipFormat() != null) {
                writer.write(",datatipFormat:'" + chart.getDatatipFormat() + "'");
            }
        }
    }
}

