/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.tag;

import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.docker.api.DockerInstance;
import org.netbeans.modules.docker.ui.UiUtils;
import org.netbeans.modules.docker.ui.Validations;
import org.netbeans.modules.docker.ui.tag.Bundle;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class TagPanel
extends JPanel {
    private final JButton actionButton;
    private NotificationLineSupport messageLine;
    private JCheckBox forceCheckBox;
    private JComboBox<String> repositoryComboBox;
    private JLabel repositoryLabel;
    private JLabel tagLabel;
    private JTextField tagTextField;

    public TagPanel(DockerInstance instance, JButton actionButton) {
        this.initComponents();
        this.actionButton = actionButton;
        DefaultDocumentListener listener = new DefaultDocumentListener();
        ((JTextComponent)this.repositoryComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(listener);
        this.tagTextField.getDocument().addDocumentListener(listener);
        UiUtils.loadRepositories(instance, this.repositoryComboBox);
    }

    public void setMessageLine(NotificationLineSupport messageLine) {
        this.messageLine = messageLine;
        this.validateInput();
    }

    private void validateInput() {
        String message;
        String message2;
        if (this.messageLine == null) {
            return;
        }
        this.messageLine.clearMessages();
        this.actionButton.setEnabled(true);
        if (this.getRepository() == null) {
            this.messageLine.setErrorMessage(Bundle.MSG_EmptyRepository());
            this.actionButton.setEnabled(false);
            return;
        }
        String repository = this.getRepository();
        if (repository != null && (message2 = Validations.validateRepository(repository)) != null) {
            this.messageLine.setErrorMessage(message2);
            this.actionButton.setEnabled(false);
            return;
        }
        String tag = this.getTag();
        if (tag != null && (message = Validations.validateTag(tag)) != null) {
            this.messageLine.setErrorMessage(message);
            this.actionButton.setEnabled(false);
            return;
        }
    }

    private void initComponents() {
        this.repositoryLabel = new JLabel();
        this.repositoryComboBox = new JComboBox();
        this.tagLabel = new JLabel();
        this.tagTextField = new JTextField();
        this.forceCheckBox = new JCheckBox();
        this.repositoryLabel.setLabelFor(this.repositoryComboBox);
        Mnemonics.setLocalizedText((JLabel)this.repositoryLabel, (String)NbBundle.getMessage(TagPanel.class, (String)"TagPanel.repositoryLabel.text"));
        this.repositoryComboBox.setEditable(true);
        this.tagLabel.setLabelFor(this.tagTextField);
        Mnemonics.setLocalizedText((JLabel)this.tagLabel, (String)NbBundle.getMessage(TagPanel.class, (String)"TagPanel.tagLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.forceCheckBox, (String)NbBundle.getMessage(TagPanel.class, (String)"TagPanel.forceCheckBox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.forceCheckBox, -1, 476, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.repositoryLabel).addComponent(this.tagLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.repositoryComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.tagTextField)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.repositoryLabel).addComponent(this.repositoryComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tagLabel).addComponent(this.tagTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.forceCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public String getRepository() {
        return UiUtils.getValue(this.repositoryComboBox);
    }

    public String getTag() {
        return UiUtils.getValue(this.tagTextField);
    }

    public boolean isForce() {
        return this.forceCheckBox.isSelected();
    }

    private class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            TagPanel.this.validateInput();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            TagPanel.this.validateInput();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            TagPanel.this.validateInput();
        }
    }
}

