/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.impl.provider.xml;

import com.sun.jersey.core.impl.provider.xml.ThreadLocalSingletonContextProvider;
import com.sun.jersey.core.util.FeaturesAndProperties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Context;
import javax.xml.parsers.SAXParserFactory;

public class SAXParserContextProvider
extends ThreadLocalSingletonContextProvider<SAXParserFactory> {
    private static final Logger LOGGER = Logger.getLogger(SAXParserContextProvider.class.getName());
    private final boolean disableXmlSecurity;

    public SAXParserContextProvider(@Context FeaturesAndProperties fps) {
        super(SAXParserFactory.class);
        this.disableXmlSecurity = fps.getFeature("com.sun.jersey.config.feature.DisableXmlSecurity");
    }

    @Override
    protected SAXParserFactory getInstance() {
        SAXParserFactory f = SAXParserFactory.newInstance();
        f.setNamespaceAware(true);
        if (!this.disableXmlSecurity) {
            try {
                f.setFeature("http://xml.org/sax/features/external-general-entities", Boolean.FALSE);
            }
            catch (Exception ex) {
                throw new RuntimeException("Security features for the SAX parser could not be enabled", ex);
            }
            try {
                f.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "JAXP feature XMLConstants.FEATURE_SECURE_PROCESSING cannot be set on a SAXParserFactory. External general entity processing is disabled but other potential security related features will not be enabled.", ex);
            }
        }
        return f;
    }
}

