/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;
import org.springframework.web.util.HierarchicalUriComponents;

public abstract class UriUtils {
    private static final String SCHEME_PATTERN = "([^:/?#]+):";
    private static final String HTTP_PATTERN = "(http|https):";
    private static final String USERINFO_PATTERN = "([^@/]*)";
    private static final String HOST_PATTERN = "([^/?#:]*)";
    private static final String PORT_PATTERN = "(\\d*)";
    private static final String PATH_PATTERN = "([^?#]*)";
    private static final String QUERY_PATTERN = "([^#]*)";
    private static final String LAST_PATTERN = "(.*)";
    private static final Pattern URI_PATTERN = Pattern.compile("^(([^:/?#]+):)?(//(([^@/]*)@)?([^/?#:]*)(:(\\d*))?)?([^?#]*)(\\?([^#]*))?(#(.*))?");
    private static final Pattern HTTP_URL_PATTERN = Pattern.compile("^(http|https):(//(([^@/]*)@)?([^/?#:]*)(:(\\d*))?)?([^?#]*)(\\?(.*))?");

    @Deprecated
    public static String encodeUri(String uri, String encoding) throws UnsupportedEncodingException {
        Assert.notNull((Object)uri, (String)"'uri' must not be null");
        Assert.hasLength((String)encoding, (String)"'encoding' must not be empty");
        Matcher m = URI_PATTERN.matcher(uri);
        if (m.matches()) {
            String scheme = m.group(2);
            String authority = m.group(3);
            String userinfo = m.group(5);
            String host = m.group(6);
            String port = m.group(8);
            String path = m.group(9);
            String query = m.group(11);
            String fragment = m.group(13);
            return UriUtils.encodeUriComponents(scheme, authority, userinfo, host, port, path, query, fragment, encoding);
        }
        throw new IllegalArgumentException("[" + uri + "] is not a valid URI");
    }

    @Deprecated
    public static String encodeHttpUrl(String httpUrl, String encoding) throws UnsupportedEncodingException {
        Assert.notNull((Object)httpUrl, (String)"'httpUrl' must not be null");
        Assert.hasLength((String)encoding, (String)"'encoding' must not be empty");
        Matcher m = HTTP_URL_PATTERN.matcher(httpUrl);
        if (m.matches()) {
            String scheme = m.group(1);
            String authority = m.group(2);
            String userinfo = m.group(4);
            String host = m.group(5);
            String portString = m.group(7);
            String path = m.group(8);
            String query = m.group(10);
            return UriUtils.encodeUriComponents(scheme, authority, userinfo, host, portString, path, query, null, encoding);
        }
        throw new IllegalArgumentException("[" + httpUrl + "] is not a valid HTTP URL");
    }

    @Deprecated
    public static String encodeUriComponents(String scheme, String authority, String userInfo, String host, String port, String path, String query, String fragment, String encoding) throws UnsupportedEncodingException {
        Assert.hasLength((String)encoding, (String)"'encoding' must not be empty");
        StringBuilder sb = new StringBuilder();
        if (scheme != null) {
            sb.append(UriUtils.encodeScheme(scheme, encoding));
            sb.append(':');
        }
        if (authority != null) {
            sb.append("//");
            if (userInfo != null) {
                sb.append(UriUtils.encodeUserInfo(userInfo, encoding));
                sb.append('@');
            }
            if (host != null) {
                sb.append(UriUtils.encodeHost(host, encoding));
            }
            if (port != null) {
                sb.append(':');
                sb.append(UriUtils.encodePort(port, encoding));
            }
        }
        sb.append(UriUtils.encodePath(path, encoding));
        if (query != null) {
            sb.append('?');
            sb.append(UriUtils.encodeQuery(query, encoding));
        }
        if (fragment != null) {
            sb.append('#');
            sb.append(UriUtils.encodeFragment(fragment, encoding));
        }
        return sb.toString();
    }

    public static String encodeScheme(String scheme, String encoding) throws UnsupportedEncodingException {
        return HierarchicalUriComponents.encodeUriComponent(scheme, encoding, HierarchicalUriComponents.Type.SCHEME);
    }

    public static String encodeAuthority(String authority, String encoding) throws UnsupportedEncodingException {
        return HierarchicalUriComponents.encodeUriComponent(authority, encoding, HierarchicalUriComponents.Type.AUTHORITY);
    }

    public static String encodeUserInfo(String userInfo, String encoding) throws UnsupportedEncodingException {
        return HierarchicalUriComponents.encodeUriComponent(userInfo, encoding, HierarchicalUriComponents.Type.USER_INFO);
    }

    public static String encodeHost(String host, String encoding) throws UnsupportedEncodingException {
        return HierarchicalUriComponents.encodeUriComponent(host, encoding, HierarchicalUriComponents.Type.HOST_IPV4);
    }

    public static String encodePort(String port, String encoding) throws UnsupportedEncodingException {
        return HierarchicalUriComponents.encodeUriComponent(port, encoding, HierarchicalUriComponents.Type.PORT);
    }

    public static String encodePath(String path, String encoding) throws UnsupportedEncodingException {
        return HierarchicalUriComponents.encodeUriComponent(path, encoding, HierarchicalUriComponents.Type.PATH);
    }

    public static String encodePathSegment(String segment, String encoding) throws UnsupportedEncodingException {
        return HierarchicalUriComponents.encodeUriComponent(segment, encoding, HierarchicalUriComponents.Type.PATH_SEGMENT);
    }

    public static String encodeQuery(String query, String encoding) throws UnsupportedEncodingException {
        return HierarchicalUriComponents.encodeUriComponent(query, encoding, HierarchicalUriComponents.Type.QUERY);
    }

    public static String encodeQueryParam(String queryParam, String encoding) throws UnsupportedEncodingException {
        return HierarchicalUriComponents.encodeUriComponent(queryParam, encoding, HierarchicalUriComponents.Type.QUERY_PARAM);
    }

    public static String encodeFragment(String fragment, String encoding) throws UnsupportedEncodingException {
        return HierarchicalUriComponents.encodeUriComponent(fragment, encoding, HierarchicalUriComponents.Type.FRAGMENT);
    }

    public static String decode(String source, String encoding) throws UnsupportedEncodingException {
        Assert.notNull((Object)source, (String)"'source' must not be null");
        Assert.hasLength((String)encoding, (String)"'encoding' must not be empty");
        int length = source.length();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        boolean changed = false;
        for (int i = 0; i < length; ++i) {
            char ch = source.charAt(i);
            if (ch == '%') {
                if (i + 2 < length) {
                    char hex1 = source.charAt(i + 1);
                    char hex2 = source.charAt(i + 2);
                    int u = Character.digit(hex1, 16);
                    int l = Character.digit(hex2, 16);
                    if (u == -1 || l == -1) {
                        throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
                    }
                    bos.write((char)((u << 4) + l));
                    i += 2;
                    changed = true;
                    continue;
                }
                throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
            }
            bos.write(ch);
        }
        return changed ? new String(bos.toByteArray(), encoding) : source;
    }
}

