/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jspcompiler;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;

public final class JspAntLogger
extends AntLogger {
    private static final Pattern JSP_COMPILER_ERROR = Pattern.compile("(.*)(org.apache.jasper.JasperException: file:)(.*)");
    private static final Pattern FILE_PATTERN = Pattern.compile("([^\\(]*)\\(([0-9]+),([0-9]+)\\)");
    private static final String[] TASKS_OF_INTEREST = AntLogger.ALL_TASKS;
    private static final int[] LEVELS_OF_INTEREST = new int[]{2, 1, 0};
    private static final Logger ERR = Logger.getLogger(JspAntLogger.class.getName());
    private static final boolean LOGGABLE = ERR.isLoggable(Level.FINE);

    public boolean interestedInSession(AntSession session) {
        return true;
    }

    public boolean interestedInAllScripts(AntSession session) {
        return true;
    }

    public String[] interestedInTargets(AntSession session) {
        return AntLogger.ALL_TARGETS;
    }

    public boolean interestedInScript(File script, AntSession session) {
        return true;
    }

    public String[] interestedInTasks(AntSession session) {
        return TASKS_OF_INTEREST;
    }

    public int[] interestedInLogLevels(AntSession session) {
        return LEVELS_OF_INTEREST;
    }

    public void messageLogged(AntEvent event) {
        AntSession session = event.getSession();
        int messageLevel = event.getLogLevel();
        int sessionLevel = session.getVerbosity();
        String line = event.getMessage();
        assert (line != null);
        Matcher m = JSP_COMPILER_ERROR.matcher(line);
        if (m.matches()) {
            if (LOGGABLE) {
                ERR.log(Level.FINE, "matched line: " + line);
            }
            String jspErrorText = line.substring(line.lastIndexOf(41) + 1);
            session.println(line.substring(0, line.indexOf("file:")) + jspErrorText, true, null);
            String filePart = line.substring(line.indexOf("file"), line.lastIndexOf(41) + 1);
            if (LOGGABLE) {
                ERR.log(Level.FINE, "file part: " + filePart);
            }
            int startIndex = 0;
            while (filePart.indexOf("file:", startIndex) > -1) {
                File f;
                FileObject fo;
                FileObject jspSource;
                Matcher fileMatcher;
                int end;
                int start = filePart.indexOf("file:", startIndex) + 5;
                startIndex = end = filePart.indexOf(41, startIndex) + 1;
                String file = filePart.substring(start, end);
                if (LOGGABLE) {
                    ERR.log(Level.FINE, "file: " + file);
                }
                if (!(fileMatcher = FILE_PATTERN.matcher(file)).matches()) continue;
                String jspFile = fileMatcher.group(1).trim();
                int lineNumber = Integer.parseInt(fileMatcher.group(2));
                int columnNumber = Integer.parseInt(fileMatcher.group(3)) + 1;
                if (LOGGABLE) {
                    ERR.log(Level.FINE, "linking line: " + lineNumber + ", column: " + columnNumber);
                }
                if ((jspSource = JspAntLogger.getResourceInSources(fo = FileUtil.toFileObject((File)(f = new File(jspFile))))) == null || messageLevel > sessionLevel || event.isConsumed()) continue;
                try {
                    session.println(file, true, session.createStandardHyperlink(jspSource.getURL(), jspErrorText, lineNumber, columnNumber, -1, -1));
                }
                catch (FileStateInvalidException e) {
                    assert (false) : e;
                }
            }
            event.consume();
        }
    }

    private static FileObject getResourceInSources(FileObject inBuild) {
        FileObject webBuildDir;
        if (inBuild == null) {
            return null;
        }
        WebModule wm = WebModule.getWebModule((FileObject)inBuild);
        if (wm != null && (webBuildDir = JspAntLogger.guessWebModuleOutputRoot(wm, inBuild)) != null) {
            String jspResourcePath = FileUtil.getRelativePath((FileObject)webBuildDir, (FileObject)inBuild);
            return wm.getDocumentBase().getFileObject(jspResourcePath);
        }
        return null;
    }

    private static FileObject guessWebModuleOutputRoot(WebModule wm, FileObject fo) {
        for (FileObject potentialRoot = fo.getParent(); potentialRoot != null; potentialRoot = potentialRoot.getParent()) {
            if (potentialRoot.getFileObject("WEB-INF") == null) continue;
            return potentialRoot;
        }
        return null;
    }
}

