/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.api.execute;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.gradle.GradleDistributionManager;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.api.execute.Bundle;
import org.netbeans.modules.gradle.api.execute.GradleCommandLine;
import org.netbeans.modules.gradle.api.execute.RunConfig;
import org.netbeans.modules.gradle.execute.GradleDaemonExecutor;
import org.netbeans.modules.gradle.execute.GradleExecutor;
import org.netbeans.modules.gradle.execute.ProxyNonSelectableInputOutput;
import org.netbeans.modules.gradle.spi.GradleSettings;
import org.netbeans.modules.gradle.spi.actions.ReplaceTokenProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.LifecycleManager;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.windows.IOColorPrint;
import org.openide.windows.IOColors;
import org.openide.windows.InputOutput;

public final class RunUtils {
    private static final Logger LOG = Logger.getLogger(RunUtils.class.getName());
    public static final String PROP_JDK_PLATFORM = "jdkPlatform";
    public static final String PROP_COMPILE_ON_SAVE = "compile.on.save";
    public static final String PROP_AUGMENTED_BUILD = "augmented.build";
    public static final String PROP_DEFAULT_CLI = "gradle.cli";

    private RunUtils() {
    }

    public static FileObject extractFileObjectfromLookup(Lookup lookup) {
        FileObject[] fos = RunUtils.extractFileObjectsfromLookup(lookup);
        return fos.length > 0 ? fos[0] : null;
    }

    public static FileObject[] extractFileObjectsfromLookup(Lookup lookup) {
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        for (DataObject d : lookup.lookupAll(DataObject.class)) {
            FileObject f = d.getPrimaryFile();
            files.add(f);
        }
        Collection methods = lookup.lookupAll(SingleMethod.class);
        if (methods.size() == 1) {
            SingleMethod method = (SingleMethod)methods.iterator().next();
            files.add(method.getFile());
        }
        return files.toArray(new FileObject[files.size()]);
    }

    public static ExecutorTask executeGradle(RunConfig config, String initialOutput) {
        LifecycleManager.getDefault().saveAll();
        GradleDaemonExecutor exec = new GradleDaemonExecutor(config);
        ExecutorTask task = RunUtils.executeGradleImpl(config.getTaskDisplayName(), exec, initialOutput);
        return task;
    }

    public static RunConfig createRunConfig(Project project, String action, String displayName, String[] args) {
        GradleBaseProject gbp = GradleBaseProject.get(project);
        GradleCommandLine syscmd = GradleCommandLine.getDefaultCommandLine();
        GradleCommandLine prjcmd = RunUtils.getDefaultCommandLine(project);
        GradleCommandLine basecmd = syscmd;
        if (prjcmd != null) {
            basecmd = GradleCommandLine.combine(syscmd, prjcmd);
        }
        RunUtils.validateExclude(basecmd, gbp, "test");
        RunUtils.validateExclude(basecmd, gbp, "check");
        GradleCommandLine cmd = GradleCommandLine.combine(basecmd, new GradleCommandLine(args));
        RunConfig ret = new RunConfig(project, action, displayName, EnumSet.of(RunConfig.ExecFlag.REPEATABLE), cmd);
        return ret;
    }

    private static ExecutorTask executeGradleImpl(String runtimeName, GradleExecutor exec, String initialOutput) {
        InputOutput io = exec.getInputOutput();
        ExecutorTask task = ExecutionEngine.getDefault().execute(runtimeName, (Runnable)exec, (InputOutput)new ProxyNonSelectableInputOutput(io));
        if (initialOutput != null) {
            try {
                if (IOColorPrint.isSupported((InputOutput)io)) {
                    IOColorPrint.print((InputOutput)io, (CharSequence)initialOutput, (Color)IOColors.getColor((InputOutput)io, (IOColors.OutputType)IOColors.OutputType.LOG_DEBUG));
                } else {
                    io.getOut().println(initialOutput);
                }
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Can't write initial output: " + initialOutput, ex);
            }
        }
        exec.setTask(task);
        return task;
    }

    public static boolean isCompileOnSaveEnabled(Project project) {
        return RunUtils.isOptionEnabled(project, PROP_COMPILE_ON_SAVE, false);
    }

    public static boolean isAugmentedBuildEnabled(Project project) {
        return RunUtils.isOptionEnabled(project, PROP_AUGMENTED_BUILD, true);
    }

    public static GradleCommandLine getDefaultCommandLine(Project project) {
        String args = NbGradleProject.getPreferences(project, true).get(PROP_DEFAULT_CLI, null);
        return args != null ? new GradleCommandLine((CharSequence)args) : null;
    }

    public static File evaluateGradleDistribution(Project project, boolean forceCompatibility) {
        File f;
        GradleDistributionManager.NbGradleVersion ngv;
        File ret = null;
        GradleSettings settings = GradleSettings.getDefault();
        GradleDistributionManager mgr = GradleDistributionManager.get(settings.getGradleUserHome());
        GradleBaseProject gbp = GradleBaseProject.get(project);
        if (gbp != null && settings.isWrapperPreferred()) {
            ngv = mgr.evaluateGradleWrapperDistribution(gbp.getRootDir());
            if (ngv != null && forceCompatibility && !ngv.isCompatibleWithSystemJava()) {
                ngv = mgr.defaultToolingVersion();
            }
            if (ngv != null && ngv.isAvailable()) {
                ret = ngv.distributionDir();
            }
        }
        if (ret == null && settings.useCustomGradle() && !settings.getDistributionHome().isEmpty() && (f = FileUtil.normalizeFile((File)new File(settings.getDistributionHome()))).isDirectory()) {
            ret = f;
        }
        if (ret == null) {
            ngv = mgr.createVersion(settings.getGradleVersion());
            if (ngv != null && forceCompatibility && !ngv.isCompatibleWithSystemJava()) {
                ngv = mgr.defaultToolingVersion();
            }
            if (ngv != null && ngv.isAvailable()) {
                ret = ngv.distributionDir();
            }
        }
        return ret;
    }

    private static boolean isOptionEnabled(Project project, String option, boolean defaultValue) {
        GradleBaseProject gbp = GradleBaseProject.get(project);
        if (gbp != null) {
            String value = gbp.getNetBeansProperty(option);
            if (value != null) {
                return Boolean.getBoolean(value);
            }
            return NbGradleProject.getPreferences(project, false).getBoolean(option, defaultValue);
        }
        return false;
    }

    private static void validateExclude(GradleCommandLine cmd, GradleBaseProject gbp, String task) {
        boolean exclude = gbp.getTaskNames().contains(task) || gbp.isRoot() && !gbp.getSubProjects().isEmpty();
        if (exclude &= cmd.getExcludedTasks().contains(task) && !cmd.getTasks().contains(task)) {
            cmd.addParameter(GradleCommandLine.Parameter.EXCLUDE_TASK, task);
        } else {
            cmd.removeParameter(GradleCommandLine.Parameter.EXCLUDE_TASK, task);
        }
    }

    public static ReplaceTokenProvider simpleReplaceTokenProvider(final String token, final String value) {
        return new ReplaceTokenProvider(){

            @Override
            public Set<String> getSupportedTokens() {
                return Collections.singleton(token);
            }

            @Override
            public Map<String, String> createReplacements(String action, Lookup context) {
                return Collections.singletonMap(token, value);
            }
        };
    }

    private static String taskName(String action, Lookup lkp) {
        String title;
        DataObject dobj = (DataObject)lkp.lookup(DataObject.class);
        String dobjName = dobj != null ? dobj.getName() : "";
        Project prj = (Project)lkp.lookup(Project.class);
        String prjLabel = prj != null ? ProjectUtils.getInformation((Project)prj).getDisplayName() : "No Project on Lookup";
        switch (action) {
            case "run": {
                title = Bundle.TXT_Run(prjLabel);
                break;
            }
            case "debug": {
                title = Bundle.TXT_Debug(prjLabel);
                break;
            }
            case "profile": {
                title = Bundle.TXT_Profile(prjLabel);
                break;
            }
            case "test": {
                title = Bundle.TXT_Test(prjLabel);
                break;
            }
            case "run.single": {
                title = Bundle.TXT_Run(dobjName);
                break;
            }
            case "debug.single": 
            case "debug.test.single": {
                title = Bundle.TXT_Debug(dobjName);
                break;
            }
            case "profile.single": 
            case "profile.test.single": {
                title = Bundle.TXT_Profile(dobjName);
                break;
            }
            case "test.single": {
                title = Bundle.TXT_Test(dobjName);
                break;
            }
            case "debug.fix": {
                title = Bundle.TXT_ApplyCodeChanges(prjLabel);
                break;
            }
            default: {
                title = Bundle.TXT_Build(prjLabel);
            }
        }
        return title;
    }

    public static Pair<String, JavaPlatform> getActivePlatform(String activePlatformId) {
        JavaPlatform[] installedPlatforms;
        JavaPlatformManager pm = JavaPlatformManager.getDefault();
        if (activePlatformId == null) {
            JavaPlatform p = pm.getDefaultPlatform();
            return Pair.of(p.getProperties().get("platform.ant.name"), (Object)p);
        }
        for (JavaPlatform installedPlatform : installedPlatforms = pm.getPlatforms(null, new Specification("j2se", null))) {
            String antName = (String)installedPlatform.getProperties().get("platform.ant.name");
            if (antName == null || !antName.equals(activePlatformId)) continue;
            return Pair.of((Object)activePlatformId, (Object)installedPlatform);
        }
        return Pair.of((Object)activePlatformId, null);
    }

    public static Pair<String, JavaPlatform> getActivePlatform(Project project) {
        Preferences prefs = NbGradleProject.getPreferences(project, false);
        String platformId = prefs.get(PROP_JDK_PLATFORM, null);
        if (platformId == null) {
            GradleBaseProject gbp = GradleBaseProject.get(project);
            platformId = gbp != null ? gbp.getNetBeansProperty(PROP_JDK_PLATFORM) : null;
        }
        return RunUtils.getActivePlatform(platformId);
    }

    private static String stringsInCurly(List<String> l) {
        StringBuilder sb = new StringBuilder("(");
        Iterator<String> it = l.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            sb.append(it.hasNext() ? ", " : ")");
        }
        return sb.toString();
    }
}

