/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.frames.models;

import com.sun.jdi.AbsentInformationException;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.MonitorInfo;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.modules.debugger.jpda.truffle.Utils;
import org.netbeans.modules.debugger.jpda.truffle.access.CurrentPCInfo;
import org.netbeans.modules.debugger.jpda.truffle.access.TruffleAccess;
import org.netbeans.modules.debugger.jpda.truffle.frames.TruffleStackFrame;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ExtendedNodeModelFilter;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.util.datatransfer.PasteType;

public class DebuggingTruffleNodeModel
implements ExtendedNodeModelFilter {
    private final JPDADebugger debugger;
    private final List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();
    private final WeakSet<CurrentPCInfo> cpisListening = new WeakSet();
    private final CurrentInfoPropertyChangeListener cpiChL = new CurrentInfoPropertyChangeListener();

    public DebuggingTruffleNodeModel(ContextProvider lookupProvider) {
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
    }

    public boolean canRename(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        return original.canRename(node);
    }

    public boolean canCopy(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        return original.canCopy(node);
    }

    public boolean canCut(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        return original.canCut(node);
    }

    public Transferable clipboardCopy(ExtendedNodeModel original, Object node) throws IOException, UnknownTypeException {
        return original.clipboardCopy(node);
    }

    public Transferable clipboardCut(ExtendedNodeModel original, Object node) throws IOException, UnknownTypeException {
        return original.clipboardCut(node);
    }

    public PasteType[] getPasteTypes(ExtendedNodeModel original, Object node, Transferable t) throws UnknownTypeException {
        return original.getPasteTypes(node, t);
    }

    public void setName(ExtendedNodeModel original, Object node, String name) throws UnknownTypeException {
        original.setName(node, name);
    }

    public String getIconBaseWithExtension(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        if (node instanceof TruffleStackFrame) {
            return original.getIconBaseWithExtension((Object)EmptyCallStackFrame.INSTANCE);
        }
        return original.getIconBaseWithExtension(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDisplayName(NodeModel original, Object node) throws UnknownTypeException {
        if (node instanceof TruffleStackFrame) {
            TruffleStackFrame tf = (TruffleStackFrame)node;
            String displayName = tf.getDisplayName();
            CurrentPCInfo currentPCInfo = TruffleAccess.getCurrentPCInfo(tf.getThread());
            if (currentPCInfo != null) {
                WeakSet<CurrentPCInfo> weakSet = this.cpisListening;
                synchronized (weakSet) {
                    if (!this.cpisListening.contains((Object)currentPCInfo)) {
                        currentPCInfo.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.cpiChL, (Object)currentPCInfo));
                        this.cpisListening.add((Object)currentPCInfo);
                    }
                }
                TruffleStackFrame selectedStackFrame = currentPCInfo.getSelectedStackFrame();
                if (selectedStackFrame == tf) {
                    displayName = Utils.toHTML(displayName, true, tf.isInternal(), null);
                } else if (tf.isInternal()) {
                    displayName = Utils.toHTML(displayName, false, true, null);
                }
            }
            return displayName;
        }
        return original.getDisplayName(node);
    }

    public String getIconBase(NodeModel original, Object node) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported.");
    }

    public String getShortDescription(NodeModel original, Object node) throws UnknownTypeException {
        if (node instanceof TruffleStackFrame) {
            return ((TruffleStackFrame)node).getDisplayName();
        }
        return original.getShortDescription(node);
    }

    private void fireDisplayNamesChanged() {
        ModelEvent.NodeChanged evt = new ModelEvent.NodeChanged((Object)this, null);
        for (ModelListener l : this.listeners) {
            l.modelChanged((ModelEvent)evt);
        }
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    private static final class EmptyCallStackFrame
    implements CallStackFrame {
        static final CallStackFrame INSTANCE = new EmptyCallStackFrame();

        private EmptyCallStackFrame() {
        }

        public int getLineNumber(String struts) {
            return 1;
        }

        public int getFrameDepth() {
            return 0;
        }

        public EditorContext.Operation getCurrentOperation(String struts) {
            return null;
        }

        public String getMethodName() {
            return "";
        }

        public String getClassName() {
            return "";
        }

        public String getDefaultStratum() {
            return "";
        }

        public List<String> getAvailableStrata() {
            return Collections.emptyList();
        }

        public String getSourceName(String struts) throws AbsentInformationException {
            return "";
        }

        public String getSourcePath(String stratum) throws AbsentInformationException {
            return "";
        }

        public LocalVariable[] getLocalVariables() throws AbsentInformationException {
            return new LocalVariable[0];
        }

        public This getThisVariable() {
            return null;
        }

        public void makeCurrent() {
        }

        public boolean isObsolete() {
            return false;
        }

        public void popFrame() {
        }

        public JPDAThread getThread() {
            return null;
        }

        public List<MonitorInfo> getOwnedMonitors() {
            return Collections.emptyList();
        }
    }

    private class CurrentInfoPropertyChangeListener
    implements PropertyChangeListener {
        private CurrentInfoPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DebuggingTruffleNodeModel.this.fireDisplayNamesChanged();
        }
    }
}

