/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.infrastructure;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.infrastructure.CreatorBasedLazyFixList;
import org.netbeans.modules.java.hints.infrastructure.LazyHintComputationFactory;
import org.openide.filesystems.FileObject;

public class LazyHintComputation
implements CancellableTask<CompilationInfo> {
    private FileObject file;
    private AtomicBoolean cancelled = new AtomicBoolean();
    private CreatorBasedLazyFixList delegate;

    public LazyHintComputation(FileObject file) {
        this.file = file;
    }

    public synchronized void cancel() {
        this.cancelled.set(true);
        if (this.delegate != null) {
            this.delegate.cancel();
        }
    }

    private synchronized void setDelegate(CreatorBasedLazyFixList delegate) {
        this.delegate = delegate;
    }

    private boolean isCancelled() {
        return this.cancelled.get();
    }

    private void resume() {
        this.cancelled.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(CompilationInfo info) {
        this.resume();
        boolean cancelled = false;
        LinkedList<CreatorBasedLazyFixList> toCompute = new LinkedList<CreatorBasedLazyFixList>();
        try {
            toCompute.addAll(LazyHintComputationFactory.getAndClearToCompute(this.file));
            if (this.isCancelled()) {
                cancelled = true;
                return;
            }
            while (!toCompute.isEmpty()) {
                if (this.isCancelled()) {
                    cancelled = true;
                    return;
                }
                CreatorBasedLazyFixList l = (CreatorBasedLazyFixList)toCompute.remove(0);
                this.setDelegate(l);
                l.compute(info, this.cancelled);
                this.setDelegate(null);
                if (!this.isCancelled()) continue;
                toCompute.add(0, l);
                cancelled = true;
                return;
            }
        }
        finally {
            if (cancelled && !toCompute.isEmpty()) {
                for (CreatorBasedLazyFixList l : toCompute) {
                    LazyHintComputationFactory.addToCompute(this.file, l);
                }
            }
        }
    }
}

