/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.charset.Charset;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.MutableComboBoxModel;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.project.ui.LocalServer;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.wizards.ConfigurableProjectPanel;
import org.netbeans.modules.php.project.ui.wizards.ConfigureProjectPanel;
import org.netbeans.modules.php.project.ui.wizards.ProjectFolder;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class ConfigureExistingProjectPanelVisual
extends ConfigurableProjectPanel {
    private static final long serialVersionUID = 97658795442153213L;
    private JComboBox<Charset> encodingComboBox;
    private JLabel encodingLabel;
    private JComboBox<PhpVersion> phpVersionComboBox;
    private JLabel phpVersionInfoLabel;
    private JLabel phpVersionLabel;
    private JPanel projectFolderPanel;
    private JLabel projectNameLabel;
    protected JTextField projectNameTextField;
    private JSeparator separator;
    private JButton sourcesBrowseButton;
    private JLabel sourcesInfoLabel;
    private JLabel sourcesLabel;
    private JTextField sourcesTextField;

    ConfigureExistingProjectPanelVisual(ConfigureProjectPanel wizardPanel) {
        super(wizardPanel);
        this.initComponents();
        this.projectFolderPanel.add("Center", this.projectFolderComponent);
        this.init();
    }

    private void init() {
        this.sourcesTextField.getDocument().addDocumentListener(this);
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.phpVersionComboBox.setModel(new Utils.PhpVersionComboBoxModel(PhpVersion.getLegacy()));
        this.encodingComboBox.setModel(ProjectCustomizer.encodingModel((String)Charset.defaultCharset().name()));
        this.encodingComboBox.setRenderer(ProjectCustomizer.encodingRenderer());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.projectNameTextField.requestFocus();
    }

    private void initComponents() {
        this.sourcesLabel = new JLabel();
        this.sourcesTextField = new JTextField();
        this.sourcesBrowseButton = new JButton();
        this.sourcesInfoLabel = new JLabel();
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.phpVersionLabel = new JLabel();
        this.phpVersionComboBox = new JComboBox();
        this.phpVersionInfoLabel = new JLabel();
        this.encodingLabel = new JLabel();
        this.encodingComboBox = new JComboBox();
        this.separator = new JSeparator();
        this.projectFolderPanel = new JPanel();
        this.sourcesLabel.setLabelFor(this.sourcesTextField);
        Mnemonics.setLocalizedText((JLabel)this.sourcesLabel, (String)NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"LBL_Sources"));
        this.sourcesLabel.setVerticalAlignment(1);
        this.sourcesTextField.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.sourcesBrowseButton, (String)NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"LBL_LocalServerBrowse"));
        this.sourcesBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureExistingProjectPanelVisual.this.sourcesBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.sourcesInfoLabel, (String)NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"TXT_ExistingSourcesHint"));
        this.projectNameLabel.setHorizontalAlignment(2);
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"LBL_ProjectName"));
        this.projectNameLabel.setVerticalAlignment(1);
        this.projectNameTextField.setColumns(20);
        this.phpVersionLabel.setLabelFor(this.phpVersionComboBox);
        Mnemonics.setLocalizedText((JLabel)this.phpVersionLabel, (String)NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"ConfigureExistingProjectPanelVisual.phpVersionLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.phpVersionInfoLabel, (String)NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"ConfigureExistingProjectPanelVisual.phpVersionInfoLabel.text"));
        this.encodingLabel.setLabelFor(this.encodingComboBox);
        Mnemonics.setLocalizedText((JLabel)this.encodingLabel, (String)NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"LBL_Encoding"));
        this.projectFolderPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.separator).addComponent(this.projectFolderPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.encodingLabel).addComponent(this.projectNameLabel).addComponent(this.sourcesLabel).addComponent(this.phpVersionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.phpVersionInfoLabel).addContainerGap()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.phpVersionComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.sourcesInfoLabel).addGroup(layout.createSequentialGroup().addComponent(this.sourcesTextField, -2, 1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sourcesBrowseButton)).addComponent(this.projectNameTextField, GroupLayout.Alignment.TRAILING, -2, 1, Short.MAX_VALUE).addComponent(this.encodingComboBox, 0, -1, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sourcesLabel).addComponent(this.sourcesBrowseButton).addComponent(this.sourcesTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sourcesInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectNameLabel).addComponent(this.projectNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phpVersionComboBox, -2, -1, -2).addComponent(this.phpVersionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phpVersionInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.encodingLabel).addComponent(this.encodingComboBox, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.separator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.projectFolderPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.sourcesLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"ConfigureExistingProjectPanelVisual.sourcesLabel.AccessibleContext.accessibleName"));
        this.sourcesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"ConfigureExistingProjectPanelVisual.sourcesLabel.AccessibleContext.accessibleDescription"));
        this.sourcesTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"ConfigureExistingProjectPanelVisual.sourcesTextField.AccessibleContext.accessibleName_1"));
        this.sourcesTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"ConfigureExistingProjectPanelVisual.sourcesTextField.AccessibleContext.accessibleDescription"));
        this.sourcesBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"ConfigureExistingProjectPanelVisual.sourcesBrowseButton.AccessibleContext.accessibleName"));
        this.sourcesBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"ConfigureExistingProjectPanelVisual.sourcesBrowseButton.AccessibleContext.accessibleDescription"));
        this.sourcesInfoLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"ConfigureExistingProjectPanelVisual.sourcesInfoLabel.AccessibleContext.accessibleName"));
        this.sourcesInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"ConfigureExistingProjectPanelVisual.sourcesInfoLabel.AccessibleContext.accessibleDescription"));
        this.projectNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"ConfigureExistingProjectPanelVisual.projectNameLabel.AccessibleContext.accessibleName"));
        this.projectNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"ConfigureExistingProjectPanelVisual.projectNameLabel.AccessibleContext.accessibleDescription"));
        this.projectNameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"ConfigureExistingProjectPanelVisual.projectNameTextField.AccessibleContext.accessibleName"));
        this.projectNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"ConfigureExistingProjectPanelVisual.projectNameTextField.AccessibleContext.accessibleDescription"));
        this.phpVersionLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"ConfigureExistingProjectPanelVisual.phpVersionLabel.AccessibleContext.accessibleName_1"));
        this.phpVersionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"ConfigureExistingProjectPanelVisual.phpVersionLabel.AccessibleContext.accessibleDescription_1"));
        this.phpVersionComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"ConfigureExistingProjectPanelVisual.phpVersionComboBox.AccessibleContext.accessibleDescription_1"));
        this.phpVersionInfoLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"ConfigureExistingProjectPanelVisual.phpVersionInfoLabel.AccessibleContext.accessibleName_1"));
        this.phpVersionInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"ConfigureExistingProjectPanelVisual.phpVersionInfoLabel.AccessibleContext.accessibleDescription_1"));
        this.encodingLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"ConfigureExistingProjectPanelVisual.encodingLabel.AccessibleContext.accessibleName"));
        this.encodingLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"ConfigureExistingProjectPanelVisual.encodingLabel.AccessibleContext.accessibleDescription"));
        this.encodingComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"ConfigureExistingProjectPanelVisual.encodingComboBox.AccessibleContext.accessibleName"));
        this.encodingComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"ConfigureExistingProjectPanelVisual.encodingComboBox.AccessibleContext.accessibleDescription"));
        this.separator.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"ConfigureExistingProjectPanelVisual.separator.AccessibleContext.accessibleName"));
        this.separator.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"ConfigureExistingProjectPanelVisual.separator.AccessibleContext.accessibleDescription"));
        this.projectFolderPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"ConfigureExistingProjectPanelVisual.projectFolderPanel.AccessibleContext.accessibleName"));
        this.projectFolderPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"ConfigureExistingProjectPanelVisual.projectFolderPanel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"ConfigureExistingProjectPanelVisual.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureExistingProjectPanelVisual.class, (String)"ConfigureExistingProjectPanelVisual.AccessibleContext.accessibleDescription"));
    }

    private void sourcesBrowseButtonActionPerformed(ActionEvent evt) {
        File newLocation = Utils.browseLocationAction("nb.php.sources.existing", NbBundle.getMessage(ProjectFolder.class, (String)"LBL_SelectProjectFolder"));
        if (newLocation != null) {
            this.sourcesTextField.setText(newLocation.getAbsolutePath());
        }
    }

    @Override
    public String getProjectName() {
        return this.projectNameTextField.getText().trim();
    }

    @Override
    public void setProjectName(String projectName) {
        this.projectNameTextField.setText(projectName);
        this.projectNameTextField.selectAll();
    }

    @Override
    public String getSourcesFolder() {
        return this.sourcesTextField.getText();
    }

    @Override
    public LocalServer getSourcesLocation() {
        return new LocalServer(this.sourcesTextField.getText());
    }

    @Override
    public MutableComboBoxModel<LocalServer> getLocalServerModel() {
        return null;
    }

    @Override
    public void setLocalServerModel(MutableComboBoxModel<LocalServer> localServers) {
    }

    @Override
    public void selectSourcesLocation(LocalServer localServer) {
    }

    @Override
    public PhpVersion getPhpVersion() {
        return (PhpVersion)this.phpVersionComboBox.getSelectedItem();
    }

    @Override
    public void setPhpVersion(PhpVersion phpVersion) {
        this.phpVersionComboBox.setSelectedItem(phpVersion);
    }

    @Override
    public Charset getEncoding() {
        return (Charset)this.encodingComboBox.getSelectedItem();
    }

    @Override
    public void setEncoding(Charset encoding) {
        this.encodingComboBox.setSelectedItem(encoding);
    }

    @Override
    public void setState(boolean enabled) {
        throw new IllegalStateException("Should not be called for existing sources");
    }

    @Override
    public boolean getState() {
        return true;
    }
}

