/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.netbeans.lib.profiler.ui.swing.FilteringToolbar;
import org.netbeans.lib.profiler.ui.swing.ProfilerPopup;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.lib.profiler.ui.swing.renderer.CheckBoxRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.LabelRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.ProfilerRenderer;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.v2.impl.Bundle;
import org.openide.util.Lookup;

public abstract class ProjectsSelector {
    private final Collection<Lookup.Provider> selected;

    public ProjectsSelector(Collection<Lookup.Provider> selected) {
        this.selected = new HashSet<Lookup.Provider>(selected);
    }

    public void show(Component invoker) {
        UI ui = new UI(this.selected);
        ui.show(invoker);
    }

    protected abstract void selectionChanged(Collection<Lookup.Provider> var1);

    private static class ProjectRenderer
    extends LabelRenderer {
        private final Font font = this.getFont();
        private final Lookup.Provider main = ProjectUtilities.getMainProject();

        public void setValue(Object value, int row) {
            if (value == null) {
                this.setText("");
                this.setIcon(null);
            } else {
                Lookup.Provider project = (Lookup.Provider)value;
                this.setText(ProjectUtilities.getDisplayName((Lookup.Provider)project));
                Icon icon = ProjectUtilities.getIcon((Lookup.Provider)project);
                this.setIcon(this.isEnabled() ? icon : ProjectRenderer.disabledIcon(icon));
                this.setFont(Objects.equals(this.main, value) ? this.font.deriveFont(1) : this.font);
            }
        }

        private static Icon disabledIcon(Icon icon) {
            return new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon).getImage()));
        }
    }

    private class UI {
        private JPanel panel;

        UI(Collection<Lookup.Provider> selected) {
            this.populatePopup();
        }

        void show(Component invoker) {
            int resizeMode = 12;
            ProfilerPopup.createRelative((Component)invoker, (Component)this.panel, (int)6, (int)resizeMode).show();
        }

        private void populatePopup() {
            JPanel content = new JPanel(new BorderLayout());
            JLabel hint = new JLabel(Bundle.ProjectsSelector_selectProjects(), 10);
            hint.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
            content.add((Component)hint, "North");
            SelectedProjectsModel projectsModel = new SelectedProjectsModel();
            final ProfilerTable projectsTable = new ProfilerTable((TableModel)projectsModel, true, false, null);
            projectsTable.setColumnToolTips(new String[]{Bundle.ProjectsSelector_columnSelectedToolTip(), Bundle.ProjectsSelector_columnProjectToolTip()});
            projectsTable.setMainColumn(1);
            projectsTable.setFitWidthColumn(1);
            projectsTable.setDefaultSortOrder(1, SortOrder.ASCENDING);
            projectsTable.setSortColumn(1);
            projectsTable.setFixedColumnSelection(0);
            projectsTable.setColumnRenderer(0, (ProfilerRenderer)new CheckBoxRenderer());
            ProjectRenderer projectRenderer = new ProjectRenderer();
            projectsTable.setColumnRenderer(1, (ProfilerRenderer)projectRenderer);
            int w = new JLabel((String)projectsTable.getColumnName((int)0)).getPreferredSize().width;
            projectsTable.setDefaultColumnWidth(0, w + 15);
            int h = projectsTable.getRowHeight() * 8;
            projectRenderer.setText("A longest expected project name A longest expected project name");
            Dimension prefSize = new Dimension(w + projectRenderer.getPreferredSize().width, h += projectsTable.getTableHeader().getPreferredSize().height);
            projectsTable.setPreferredScrollableViewportSize(prefSize);
            ProfilerTableContainer tableContainer = new ProfilerTableContainer(projectsTable, true, null);
            JPanel tableContent = new JPanel(new BorderLayout());
            tableContent.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
            tableContent.add((Component)tableContainer, "Center");
            content.add((Component)tableContent, "Center");
            FilteringToolbar controls = new FilteringToolbar(Bundle.ProjectsSelector_filterProjects()){

                protected void filterChanged() {
                    if (this.isAll()) {
                        projectsTable.setRowFilter(null);
                    } else {
                        projectsTable.setRowFilter(new RowFilter(){

                            public boolean include(RowFilter.Entry entry) {
                                return this.passes(entry.getStringValue(1));
                            }
                        });
                    }
                }
            };
            content.add((Component)controls, "South");
            this.panel = content;
        }

        private class SelectedProjectsModel
        extends AbstractTableModel {
            Lookup.Provider[] projects = ProjectUtilities.getOpenedProjects();

            SelectedProjectsModel() {
                ProjectUtilities.getOpenedProjects();
            }

            @Override
            public String getColumnName(int columnIndex) {
                if (columnIndex == 0) {
                    return Bundle.ProjectsSelector_columnSelected();
                }
                if (columnIndex == 1) {
                    return Bundle.ProjectsSelector_columnProject();
                }
                return null;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return Boolean.class;
                }
                if (columnIndex == 1) {
                    return Lookup.Provider.class;
                }
                return null;
            }

            @Override
            public int getRowCount() {
                return this.projects.length;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (columnIndex == 0) {
                    return ProjectsSelector.this.selected.contains(this.projects[rowIndex]);
                }
                if (columnIndex == 1) {
                    return this.projects[rowIndex];
                }
                return null;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                if (Boolean.TRUE.equals(aValue)) {
                    if (ProjectsSelector.this.selected.add(this.projects[rowIndex])) {
                        ProjectsSelector.this.selectionChanged(ProjectsSelector.this.selected);
                    }
                } else if (ProjectsSelector.this.selected.size() > 1 && ProjectsSelector.this.selected.remove(this.projects[rowIndex])) {
                    ProjectsSelector.this.selectionChanged(ProjectsSelector.this.selected);
                }
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 0;
            }
        }
    }
}

