/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.lib.plain;

import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.html.editor.lib.api.ProblemDescription;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.openide.util.CharSequences;

public class AttributeElement
implements Attribute {
    private CharSequence source;
    private int nameOffset;
    private short valueOffset2nameOffsetDiff;
    private short nameLen;
    private int valueLen;

    public AttributeElement(CharSequence source, int nameOffset, short nameLen) {
        this.source = source;
        this.nameOffset = nameOffset;
        this.valueOffset2nameOffsetDiff = (short)-1;
        this.nameLen = nameLen;
        this.valueLen = -1;
    }

    public AttributeElement(CharSequence source, int nameOffset, int valueOffset, short nameLen, int valueLen) {
        this.source = source;
        this.nameOffset = nameOffset;
        this.valueOffset2nameOffsetDiff = (short)(valueOffset - nameOffset);
        this.nameLen = nameLen;
        this.valueLen = valueLen;
    }

    @Override
    public int nameOffset() {
        return this.nameOffset;
    }

    @Override
    public CharSequence name() {
        return this.source.subSequence(this.nameOffset, this.nameOffset + this.nameLen);
    }

    @Override
    public int valueOffset() {
        return this.valueOffset2nameOffsetDiff == -1 ? -1 : this.nameOffset + this.valueOffset2nameOffsetDiff;
    }

    @Override
    public CharSequence value() {
        return this.valueLen == -1 ? null : this.source.subSequence(this.valueOffset(), this.valueOffset() + this.valueLen);
    }

    @Override
    public boolean isValueQuoted() {
        if (this.value() == null) {
            return false;
        }
        if (this.valueLen < 2) {
            return false;
        }
        CharSequence value = this.value();
        return !(value.charAt(0) != '\'' && value.charAt(0) != '\"' || value.charAt(value.length() - 1) != '\'' && value.charAt(value.length() - 1) != '\"');
    }

    @Override
    public CharSequence unquotedValue() {
        if (this.value() == null) {
            return null;
        }
        return this.isValueQuoted() ? this.value().subSequence(1, this.value().length() - 1) : this.value();
    }

    @Override
    public CharSequence namespacePrefix() {
        int colonIndex = CharSequences.indexOf((CharSequence)this.name(), (CharSequence)":");
        return colonIndex == -1 ? null : this.name().subSequence(0, colonIndex);
    }

    @Override
    public CharSequence unqualifiedName() {
        int colonIndex = CharSequences.indexOf((CharSequence)this.name(), (CharSequence)":");
        return colonIndex == -1 ? this.name() : this.name().subSequence(colonIndex + 1, this.name().length());
    }

    @Override
    public int from() {
        return this.nameOffset();
    }

    @Override
    public int to() {
        return this.value() != null ? this.valueOffset() + this.valueLen : this.nameOffset() + this.nameLen;
    }

    @Override
    public ElementType type() {
        return ElementType.ATTRIBUTE;
    }

    @Override
    public CharSequence image() {
        return this.source.subSequence(this.from(), this.to());
    }

    @Override
    public CharSequence id() {
        return this.type().name();
    }

    @Override
    public Collection<ProblemDescription> problems() {
        return Collections.emptyList();
    }

    @Override
    public Node parent() {
        return null;
    }

    public static class AttributeElementWithJoinedValue
    extends AttributeElement {
        public String value;

        public AttributeElementWithJoinedValue(CharSequence source, int nameOffset, short nameLen, int valueOffset, String value) {
            super(source, nameOffset, valueOffset, nameLen, (short)value.length());
            this.value = value;
        }

        @Override
        public CharSequence value() {
            return this.value;
        }
    }
}

