# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.unstructured_grid_algorithm import UnstructuredGridAlgorithm


class PUnstructuredGridGhostCellsGenerator(UnstructuredGridAlgorithm):
    """
    PUnstructuredGridGhostCellsGenerator - Builds ghost cells for a
     distributed unstructured grid dataset.
    
    Superclass: UnstructuredGridAlgorithm
    
    This filter generate ghost cells for distributed a unstructured grid
    in parallel - using MPI asynchronous communications. The filter can
    take benefit of the input grid point global ids to perform.
    
    @warning
     
       A step of 'all reduce' (each processor send/receive data to/from
            all other processors.
       The code currently assumes one grid per rank. 
       point_data and cell_data must match across partitions/processes. 
     
    
    @sa
    DistributedDataFilter
    
    @par Thanks: This filter has been developed by Joachim Pouderoux,
    Kitware SAS 2015.
    
    @par Thanks: This filter was expanded to compute multiple ghost
    layers by Boonthanome Nouanesengsy and John Patchett, Los Alamos
    National Laboratory 2016.
    
    @par Thanks:
    ************************************************
    
    @par Thanks: This filter uses different algorithms when obtaining the
    first layer of ghost cells and getting subsequent layers.
    
    @par Thanks: First ghost cell layer algorithm:
    - each proc obtains surface points using the surface filter
    - perform an all-to-all to share surface points with each other
    - for each other proc, look at their points, and see if any points
      match any of your local points
    - for each matching point, find all local cells which use those
      points, and send those cells to that proc. mark the cells that were
    sent (used for later ghost layers)
    - receive all cells sent to you, and merge everything together
    
    @par Thanks: Subsequent ghost layers
    - for each cell that was sent last round, find all other local cells
      which border these cells. 'local cells' also includes all ghost
      cells which i have. send these cells to the same proc, and mark
      them as sent last round
    - receive all cells sent to you, and merge everything together
    - if another layer is needed, repeat
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPUnstructuredGridGhostCellsGenerator, obj, update, **traits)
    
    build_if_required = tvtk_base.true_bool_trait(desc=\
        """
        Specify if the filter must generate the ghost cells only if
        required by the pipeline. If false, ghost cells are computed even
        if they are not required. Default is TRUE.
        """
    )

    def _build_if_required_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBuildIfRequired,
                        self.build_if_required_)

    has_global_cell_ids = tvtk_base.false_bool_trait(desc=\
        """
        Specify if the data has global cell ids. If more than one layer
        of ghost cells is needed, global cell ids are necessary. If
        global cell ids are not provided, they will be computed
        internally. If false, global cell ids will be computed, then
        deleted afterwards. Default is FALSE.
        """
    )

    def _has_global_cell_ids_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHasGlobalCellIds,
                        self.has_global_cell_ids_)

    use_global_point_ids = tvtk_base.true_bool_trait(desc=\
        """
        Specify if the filter must take benefit of global point ids if
        they exist. If false, point coordinates are used. Default is
        TRUE.
        """
    )

    def _use_global_point_ids_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseGlobalPointIds,
                        self.use_global_point_ids_)

    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, desc=\
        """
        Set/Get the MPI multi process controller object.
        """
    )

    global_cell_ids_array_name = traits.String('GlobalNodeIds', enter_set=True, auto_set=False, desc=\
        """
        Specify the name of the global cell ids data array if the
        global_ids attribute array is not set. Default is "_global_node_ids".
        """
    )

    def _global_cell_ids_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGlobalCellIdsArrayName,
                        self.global_cell_ids_array_name)

    global_point_ids_array_name = traits.String('GlobalNodeIds', enter_set=True, auto_set=False, desc=\
        """
        Specify the name of the global point ids data array if the
        global_ids attribute array is not set. Default is "_global_node_ids".
        """
    )

    def _global_point_ids_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGlobalPointIdsArrayName,
                        self.global_point_ids_array_name)

    minimum_number_of_ghost_levels = traits.Trait(1, traits.Range(1, 2147483647, enter_set=True, auto_set=False), desc=\
        """
        When build_if_required is `false`, this can be used to set the
        minimum number of ghost levels to generate. Note, if the
        downstream pipeline requests more ghost levels than the number
        specified here, then the filter will generate those extra ghost
        levels as needed. Accepted values are in the interval [1,
        VTK_INT_MAX].
        """
    )

    def _minimum_number_of_ghost_levels_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMinimumNumberOfGhostLevels,
                        self.minimum_number_of_ghost_levels)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)
        V.get_input() -> DataObject
        C++: DataObject *GetInput()"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('build_if_required', 'GetBuildIfRequired'), ('has_global_cell_ids',
    'GetHasGlobalCellIds'), ('use_global_point_ids',
    'GetUseGlobalPointIds'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('global_cell_ids_array_name', 'GetGlobalCellIdsArrayName'),
    ('global_point_ids_array_name', 'GetGlobalPointIdsArrayName'),
    ('minimum_number_of_ghost_levels', 'GetMinimumNumberOfGhostLevels'),
    ('progress', 'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'build_if_required', 'debug',
    'global_warning_display', 'has_global_cell_ids', 'release_data_flag',
    'use_global_point_ids', 'global_cell_ids_array_name',
    'global_point_ids_array_name', 'minimum_number_of_ghost_levels',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PUnstructuredGridGhostCellsGenerator, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PUnstructuredGridGhostCellsGenerator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['build_if_required', 'has_global_cell_ids',
            'use_global_point_ids'], [], ['global_cell_ids_array_name',
            'global_point_ids_array_name', 'minimum_number_of_ghost_levels']),
            title='Edit PUnstructuredGridGhostCellsGenerator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PUnstructuredGridGhostCellsGenerator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

