/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt$sam$org_jetbrains_kotlin_utils_DFS_Neighbors$0;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\u001a\n\u0010\b\u001a\u00020\t*\u00020\n\u001a\n\u0010\u000b\u001a\u00020\t*\u00020\n\u001a\n\u0010\f\u001a\u00020\t*\u00020\n\u001a\n\u0010\r\u001a\u00020\t*\u00020\n\u001a\n\u0010\u000e\u001a\u00020\t*\u00020\n\u001a\u001a\u0010\u000f\u001a\u00020\t*\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0001\u001a\n\u0010\u0013\u001a\u00020\t*\u00020\n\u001a\n\u0010\u0014\u001a\u00020\t*\u00020\n\u001a\n\u0010\u0015\u001a\u00020\t*\u00020\n\u001a\u0017\u0010\u0016\u001a\n \u0017*\u0004\u0018\u00010\t0\t*\u00020\n\u00a2\u0006\u0002\u0010\u0018\u001a!\u0010\u0019\u001a\u00020\t*\u00020\n2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\t0\u001bH\u0082\b\u001a\n\u0010\u001d\u001a\u00020\t*\u00020\n\u001a\n\u0010\u001e\u001a\u00020\t*\u00020\n\u001a\u0010\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0 *\u00020\n\u001a\u0010\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0 *\u00020\n\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\u00a8\u0006\""}, d2={"kotlinCoroutinesPackageFqn", "Lorg/jetbrains/kotlin/name/FqName;", "getKotlinCoroutinesPackageFqn", "()Lorg/jetbrains/kotlin/name/FqName;", "kotlinPackageFqn", "getKotlinPackageFqn", "kotlinReflectionPackageFqn", "getKotlinReflectionPackageFqn", "isFunction", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isFunctionOrKFunction", "isFunctionTypeOrSubtype", "isInterface", "isKFunction", "isNameInPackage", "prefix", "", "packageFqName", "isNullable", "isSuspendFunction", "isThrowable", "isThrowableTypeOrSubtype", "kotlin.jvm.PlatformType", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Ljava/lang/Boolean;", "isTypeFromKotlinPackage", "namePredicate", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/Name;", "isTypeParameter", "isUnsigned", "superTypes", "", "typeParameterSuperTypes", "ir.backend.common"})
public final class IrTypeUtilsKt {
    @NotNull
    private static final FqName kotlinPackageFqn;
    @NotNull
    private static final FqName kotlinReflectionPackageFqn;
    @NotNull
    private static final FqName kotlinCoroutinesPackageFqn;

    @NotNull
    public static final FqName getKotlinPackageFqn() {
        return kotlinPackageFqn;
    }

    @NotNull
    public static final FqName getKotlinReflectionPackageFqn() {
        return kotlinReflectionPackageFqn;
    }

    @NotNull
    public static final FqName getKotlinCoroutinesPackageFqn() {
        return kotlinCoroutinesPackageFqn;
    }

    public static final boolean isFunction(@NotNull IrType $this$isFunction) {
        Intrinsics.checkParameterIsNotNull($this$isFunction, "$this$isFunction");
        return IrTypeUtilsKt.isNameInPackage($this$isFunction, "Function", kotlinPackageFqn);
    }

    public static final boolean isKFunction(@NotNull IrType $this$isKFunction) {
        Intrinsics.checkParameterIsNotNull($this$isKFunction, "$this$isKFunction");
        return IrTypeUtilsKt.isNameInPackage($this$isKFunction, "KFunction", kotlinReflectionPackageFqn);
    }

    public static final boolean isSuspendFunction(@NotNull IrType $this$isSuspendFunction) {
        Intrinsics.checkParameterIsNotNull($this$isSuspendFunction, "$this$isSuspendFunction");
        return IrTypeUtilsKt.isNameInPackage($this$isSuspendFunction, "SuspendFunction", kotlinCoroutinesPackageFqn);
    }

    public static final boolean isNameInPackage(@NotNull IrType $this$isNameInPackage, @NotNull String prefix, @NotNull FqName packageFqName) {
        Intrinsics.checkParameterIsNotNull($this$isNameInPackage, "$this$isNameInPackage");
        Intrinsics.checkParameterIsNotNull(prefix, "prefix");
        Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isNameInPackage);
        if (irClassifierSymbol == null) {
            return false;
        }
        IrClassifierSymbol classifier2 = irClassifierSymbol;
        String string = classifier2.getDescriptor().getName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "classifier.descriptor.name.asString()");
        String name = string;
        if (!StringsKt.startsWith$default(name, prefix, false, 2, null)) {
            return false;
        }
        IrSymbolOwner irSymbolOwner = classifier2.getOwner();
        if (irSymbolOwner == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
        }
        IrDeclaration declaration = (IrDeclaration)((Object)irSymbolOwner);
        IrDeclarationParent irDeclarationParent = declaration.getParent();
        if (!(irDeclarationParent instanceof IrPackageFragment)) {
            irDeclarationParent = null;
        }
        IrPackageFragment irPackageFragment = (IrPackageFragment)irDeclarationParent;
        if (irPackageFragment == null) {
            return false;
        }
        IrPackageFragment parent2 = irPackageFragment;
        return Intrinsics.areEqual(parent2.getFqName(), packageFqName);
    }

    @NotNull
    public static final List<IrType> superTypes(@NotNull IrType $this$superTypes) {
        List<IrType> list2;
        Object classifier2;
        Intrinsics.checkParameterIsNotNull($this$superTypes, "$this$superTypes");
        Object object = IrTypesKt.getClassifierOrNull($this$superTypes);
        if (object == null || (object = object.getOwner()) == null) {
            return CollectionsKt.emptyList();
        }
        Object object2 = classifier2 = object;
        if (object2 instanceof IrClass) {
            list2 = ((IrClass)classifier2).getSuperTypes();
        } else if (object2 instanceof IrTypeParameter) {
            list2 = ((IrTypeParameter)classifier2).getSuperTypes();
        } else {
            throw (Throwable)new IllegalStateException();
        }
        return list2;
    }

    @NotNull
    public static final List<IrType> typeParameterSuperTypes(@NotNull IrType $this$typeParameterSuperTypes) {
        List<IrType> list2;
        IrClassifierSymbol classifier2;
        Intrinsics.checkParameterIsNotNull($this$typeParameterSuperTypes, "$this$typeParameterSuperTypes");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$typeParameterSuperTypes);
        if (irClassifierSymbol == null) {
            return CollectionsKt.emptyList();
        }
        IrClassifierSymbol irClassifierSymbol2 = classifier2 = irClassifierSymbol;
        if (irClassifierSymbol2 instanceof IrTypeParameterSymbol) {
            list2 = ((IrTypeParameter)((IrTypeParameterSymbol)classifier2).getOwner()).getSuperTypes();
        } else if (irClassifierSymbol2 instanceof IrClassSymbol) {
            list2 = CollectionsKt.emptyList();
        } else {
            throw (Throwable)new IllegalStateException();
        }
        return list2;
    }

    public static final boolean isFunctionTypeOrSubtype(@NotNull IrType $this$isFunctionTypeOrSubtype) {
        Intrinsics.checkParameterIsNotNull($this$isFunctionTypeOrSubtype, "$this$isFunctionTypeOrSubtype");
        Boolean bl = DFS.ifAny((Collection)CollectionsKt.listOf($this$isFunctionTypeOrSubtype), isFunctionTypeOrSubtype.1.INSTANCE, isFunctionTypeOrSubtype.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(bl, "DFS.ifAny(listOf(this), \u2026) }, { it.isFunction() })");
        return bl;
    }

    public static final boolean isTypeParameter(@NotNull IrType $this$isTypeParameter) {
        Intrinsics.checkParameterIsNotNull($this$isTypeParameter, "$this$isTypeParameter");
        return IrTypesKt.getClassifierOrNull($this$isTypeParameter) instanceof IrTypeParameterSymbol;
    }

    public static final boolean isInterface(@NotNull IrType $this$isInterface) {
        Intrinsics.checkParameterIsNotNull($this$isInterface, "$this$isInterface");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isInterface);
        IrSymbolOwner irSymbolOwner = irClassifierSymbol != null ? irClassifierSymbol.getOwner() : null;
        if (!(irSymbolOwner instanceof IrClass)) {
            irSymbolOwner = null;
        }
        IrClass irClass = (IrClass)irSymbolOwner;
        return (irClass != null ? irClass.getKind() : null) == ClassKind.INTERFACE;
    }

    public static final boolean isFunctionOrKFunction(@NotNull IrType $this$isFunctionOrKFunction) {
        Intrinsics.checkParameterIsNotNull($this$isFunctionOrKFunction, "$this$isFunctionOrKFunction");
        return IrTypeUtilsKt.isFunction($this$isFunctionOrKFunction) || IrTypeUtilsKt.isKFunction($this$isFunctionOrKFunction);
    }

    public static final boolean isNullable(@NotNull IrType $this$isNullable) {
        Intrinsics.checkParameterIsNotNull($this$isNullable, "$this$isNullable");
        Boolean bl = DFS.ifAny((Collection)CollectionsKt.listOf($this$isNullable), isNullable.1.INSTANCE, isNullable.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(bl, "DFS.ifAny(listOf(this), \u2026is IrDynamicType\n    }\n})");
        return bl;
    }

    public static final boolean isThrowable(@NotNull IrType $this$isThrowable) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull($this$isThrowable, "$this$isThrowable");
        IrType $this$isTypeFromKotlinPackage$iv = $this$isThrowable;
        boolean $i$f$isTypeFromKotlinPackage = false;
        if ($this$isTypeFromKotlinPackage$iv instanceof IrSimpleType) {
            IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$isTypeFromKotlinPackage$iv).getClassifier();
            if (!(irClassifierSymbol instanceof IrClassSymbol)) {
                irClassifierSymbol = null;
            }
            IrClassSymbol irClassSymbol = (IrClassSymbol)irClassifierSymbol;
            if (irClassSymbol == null) {
                bl = false;
            } else {
                IrClassSymbol classClassifier$iv = irClassSymbol;
                Name name = ((IrClass)classClassifier$iv.getOwner()).getName();
                boolean bl2 = false;
                if (!Intrinsics.areEqual(name.asString(), "Throwable")) {
                    bl = false;
                } else {
                    IrDeclarationParent irDeclarationParent = ((IrClass)classClassifier$iv.getOwner()).getParent();
                    if (!(irDeclarationParent instanceof IrPackageFragment)) {
                        irDeclarationParent = null;
                    }
                    IrPackageFragment irPackageFragment = (IrPackageFragment)irDeclarationParent;
                    if (irPackageFragment == null) {
                        bl = false;
                    } else {
                        IrPackageFragment parent$iv = irPackageFragment;
                        bl = Intrinsics.areEqual(parent$iv.getFqName(), IrTypeUtilsKt.getKotlinPackageFqn());
                    }
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static final Boolean isThrowableTypeOrSubtype(@NotNull IrType $this$isThrowableTypeOrSubtype) {
        Intrinsics.checkParameterIsNotNull($this$isThrowableTypeOrSubtype, "$this$isThrowableTypeOrSubtype");
        Collection collection = CollectionsKt.listOf($this$isThrowableTypeOrSubtype);
        Object object = isThrowableTypeOrSubtype.1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new IrTypeUtilsKt$sam$org_jetbrains_kotlin_utils_DFS_Neighbors$0(function1);
        }
        return DFS.ifAny(collection, (DFS.Neighbors)object, isThrowableTypeOrSubtype.2.INSTANCE);
    }

    public static final boolean isUnsigned(@NotNull IrType $this$isUnsigned) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull($this$isUnsigned, "$this$isUnsigned");
        IrType $this$isTypeFromKotlinPackage$iv = $this$isUnsigned;
        boolean $i$f$isTypeFromKotlinPackage = false;
        if ($this$isTypeFromKotlinPackage$iv instanceof IrSimpleType) {
            IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$isTypeFromKotlinPackage$iv).getClassifier();
            if (!(irClassifierSymbol instanceof IrClassSymbol)) {
                irClassifierSymbol = null;
            }
            IrClassSymbol irClassSymbol = (IrClassSymbol)irClassifierSymbol;
            if (irClassSymbol == null) {
                bl = false;
            } else {
                IrClassSymbol classClassifier$iv = irClassSymbol;
                Name name = ((IrClass)classClassifier$iv.getOwner()).getName();
                boolean bl2 = false;
                if (!UnsignedTypes.INSTANCE.isShortNameOfUnsignedType(name)) {
                    bl = false;
                } else {
                    IrDeclarationParent irDeclarationParent = ((IrClass)classClassifier$iv.getOwner()).getParent();
                    if (!(irDeclarationParent instanceof IrPackageFragment)) {
                        irDeclarationParent = null;
                    }
                    IrPackageFragment irPackageFragment = (IrPackageFragment)irDeclarationParent;
                    if (irPackageFragment == null) {
                        bl = false;
                    } else {
                        IrPackageFragment parent$iv = irPackageFragment;
                        bl = Intrinsics.areEqual(parent$iv.getFqName(), IrTypeUtilsKt.getKotlinPackageFqn());
                    }
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    static {
        FqName fqName2 = FqName.fromSegments(CollectionsKt.listOf("kotlin"));
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "FqName.fromSegments(listOf(\"kotlin\"))");
        kotlinPackageFqn = fqName2;
        FqName fqName3 = kotlinPackageFqn.child(Name.identifier("reflect"));
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "kotlinPackageFqn.child(Name.identifier(\"reflect\"))");
        kotlinReflectionPackageFqn = fqName3;
        FqName fqName4 = kotlinPackageFqn.child(Name.identifier("coroutines"));
        Intrinsics.checkExpressionValueIsNotNull(fqName4, "kotlinPackageFqn.child(N\u2026identifier(\"coroutines\"))");
        kotlinCoroutinesPackageFqn = fqName4;
    }
}

