/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import java.util.Collection;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.Argv;
import org.jruby.embed.variable.BiVariable;
import org.jruby.embed.variable.ClassVariable;
import org.jruby.embed.variable.Constant;
import org.jruby.embed.variable.GlobalVariable;
import org.jruby.embed.variable.InstanceVariable;
import org.jruby.embed.variable.LocalGlobalVariable;
import org.jruby.embed.variable.PersistentLocalVariable;
import org.jruby.embed.variable.TransientLocalVariable;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

public class VariableInterceptor {
    public static BiVariable getVariableInstance(LocalVariableBehavior behavior, RubyObject receiver2, String name2, Object ... value2) {
        if (value2 == null || value2.length < 1) {
            return null;
        }
        if ("ARGV".equals(name2)) {
            return Argv.getInstance(receiver2, name2, value2);
        }
        switch (behavior) {
            case GLOBAL: {
                return LocalGlobalVariable.getInstance(receiver2, name2, value2);
            }
            case BSF: {
                BiVariable[] bEntries = new BiVariable[]{PersistentLocalVariable.getInstance(receiver2, name2, value2), GlobalVariable.getInstance(receiver2, name2, value2)};
                return VariableInterceptor.resolve(bEntries);
            }
            case PERSISTENT: {
                BiVariable[] pEntries = new BiVariable[]{GlobalVariable.getInstance(receiver2, name2, value2), InstanceVariable.getInstance(receiver2, name2, value2), ClassVariable.getInstance(receiver2, name2, value2), Constant.getInstance(receiver2, name2, value2), PersistentLocalVariable.getInstance(receiver2, name2, value2)};
                return VariableInterceptor.resolve(pEntries);
            }
        }
        BiVariable[] tEntries = new BiVariable[]{GlobalVariable.getInstance(receiver2, name2, value2), InstanceVariable.getInstance(receiver2, name2, value2), ClassVariable.getInstance(receiver2, name2, value2), Constant.getInstance(receiver2, name2, value2), TransientLocalVariable.getInstance(receiver2, name2, value2)};
        return VariableInterceptor.resolve(tEntries);
    }

    private static BiVariable resolve(BiVariable[] entries2) {
        for (BiVariable e : entries2) {
            if (e == null) continue;
            return e;
        }
        return null;
    }

    public static void inject(BiVariableMap map2, Ruby runtime2, ManyVarsDynamicScope scope, int depth, IRubyObject receiver2) {
        IRubyObject[] values4Injection;
        if (scope != null && scope.getValues().length > 0 && (values4Injection = map2.getLocalVarValues()) != null && values4Injection.length > 0) {
            for (int i2 = 0; i2 < values4Injection.length; ++i2) {
                scope.setValue(i2, values4Injection[i2], depth);
            }
        }
        List<BiVariable> variables = map2.getVariables();
        for (BiVariable var : variables) {
            var.inject();
        }
    }

    public static void retrieve(LocalVariableBehavior behavior, BiVariableMap map2, RubyObject receiver2) {
        Argv.retrieve(receiver2, map2);
        switch (behavior) {
            case GLOBAL: {
                LocalGlobalVariable.retrieve(receiver2, map2);
                break;
            }
            case BSF: {
                PersistentLocalVariable.retrieve(receiver2, map2);
                break;
            }
            case PERSISTENT: {
                PersistentLocalVariable.retrieve(receiver2, map2);
            }
            default: {
                InstanceVariable.retrieve(receiver2, map2);
                GlobalVariable.retrieve(receiver2, map2);
                ClassVariable.retrieve(receiver2, map2);
                Constant.retrieve(receiver2, map2);
            }
        }
    }

    public static void tryLazyRetrieval(LocalVariableBehavior behavior, BiVariableMap map2, IRubyObject receiver2, Object key2) {
        if (Argv.isValidName(key2)) {
            Argv.retrieveByKey((RubyObject)receiver2, map2, (String)key2);
            return;
        }
        switch (behavior) {
            case GLOBAL: {
                if (!LocalGlobalVariable.isValidName(key2)) break;
                LocalGlobalVariable.retrieveByKey(receiver2.getRuntime(), map2, (String)key2);
                break;
            }
            case BSF: {
                break;
            }
            default: {
                if (GlobalVariable.isValidName(key2)) {
                    GlobalVariable.retrieveByKey(receiver2.getRuntime(), map2, (String)key2);
                    break;
                }
                if (InstanceVariable.isValidName(key2)) {
                    InstanceVariable.retrieveByKey((RubyObject)receiver2, map2, (String)key2);
                    break;
                }
                if (ClassVariable.isValidName(key2)) {
                    ClassVariable.retrieveByKey((RubyObject)receiver2, map2, (String)key2);
                    break;
                }
                if (!Constant.isValidName(key2)) break;
                Constant.retrieveByKey((RubyObject)receiver2, map2, (String)key2);
            }
        }
    }

    public static void terminateGlobalVariables(LocalVariableBehavior behavior, Collection<BiVariable> variables, Ruby runtime2) {
        if (variables == null) {
            return;
        }
        if (LocalVariableBehavior.GLOBAL == behavior) {
            for (BiVariable var : variables) {
                if (BiVariable.Type.LocalGlobalVariable != var.getType()) continue;
                String name2 = var.getName();
                name2 = name2.startsWith("$") ? name2 : "$" + name2;
                runtime2.getGlobalVariables().set(name2, runtime2.getNil());
            }
        }
    }

    public static void terminateLocalVariables(LocalVariableBehavior behavior, List<String> varNames, List<BiVariable> variables) {
        if (variables == null) {
            return;
        }
        if (LocalVariableBehavior.TRANSIENT == behavior) {
            for (int i2 = 0; i2 < variables.size(); ++i2) {
                if (BiVariable.Type.LocalVariable != variables.get(i2).getType()) continue;
                varNames.remove(i2);
                variables.remove(i2);
            }
        }
    }

    public static boolean isKindOfRubyVariable(LocalVariableBehavior behavior, String name2) {
        if ("ARGV".equals(name2)) {
            return true;
        }
        switch (behavior) {
            case GLOBAL: {
                return LocalGlobalVariable.isValidName(name2);
            }
            case BSF: {
                if (PersistentLocalVariable.isValidName(name2)) {
                    return true;
                }
                return GlobalVariable.isValidName(name2);
            }
            case PERSISTENT: {
                if (GlobalVariable.isValidName(name2)) {
                    return true;
                }
                if (PersistentLocalVariable.isValidName(name2)) {
                    return true;
                }
                if (InstanceVariable.isValidName(name2)) {
                    return true;
                }
                if (Constant.isValidName(name2)) {
                    return true;
                }
                return ClassVariable.isValidName(name2);
            }
        }
        if (GlobalVariable.isValidName(name2)) {
            return true;
        }
        if (TransientLocalVariable.isValidName(name2)) {
            return true;
        }
        if (InstanceVariable.isValidName(name2)) {
            return true;
        }
        if (Constant.isValidName(name2)) {
            return true;
        }
        return ClassVariable.isValidName(name2);
    }
}

