/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JResource;
import jadx.gui.ui.ContentPanel;
import jadx.gui.ui.TabbedPane;
import jadx.gui.ui.codearea.CodeArea;
import jadx.gui.ui.codearea.LineNumbers;
import jadx.gui.ui.codearea.SearchBar;
import jadx.gui.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public final class CodePanel
extends ContentPanel {
    private static final long serialVersionUID = 5310536092010045565L;
    private final SearchBar searchBar;
    private final CodeArea codeArea = new CodeArea(this);
    private final JScrollPane scrollPane;

    public CodePanel(TabbedPane panel, JNode jnode) {
        super(panel, jnode);
        this.searchBar = new SearchBar(this.codeArea);
        this.scrollPane = new JScrollPane((Component)((Object)this.codeArea));
        this.initLineNumbers();
        this.setLayout(new BorderLayout());
        this.add((Component)this.searchBar, "North");
        this.add(this.scrollPane);
        KeyStroke key = KeyStroke.getKeyStroke(70, 128);
        Utils.addKeyBinding((JComponent)((Object)this.codeArea), key, "SearchAction", new SearchAction());
    }

    private void initLineNumbers() {
        if (this.codeArea.getDocument().getLength() <= 100000) {
            LineNumbers numbers = new LineNumbers(this.codeArea);
            numbers.setUseSourceLines(this.isUseSourceLines());
            this.scrollPane.setRowHeaderView(numbers);
        }
    }

    private boolean isUseSourceLines() {
        if (this.node instanceof JClass) {
            return true;
        }
        if (this.node instanceof JResource) {
            JResource resNode = (JResource)this.node;
            return !resNode.getLineMapping().isEmpty();
        }
        return false;
    }

    @Override
    public void loadSettings() {
        this.codeArea.loadSettings();
        this.initLineNumbers();
        this.updateUI();
    }

    @Override
    public TabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    @Override
    public JNode getNode() {
        return this.node;
    }

    SearchBar getSearchBar() {
        return this.searchBar;
    }

    public CodeArea getCodeArea() {
        return this.codeArea;
    }

    JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    private class SearchAction
    extends AbstractAction {
        private static final long serialVersionUID = 8650568214755387093L;

        private SearchAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodePanel.this.searchBar.toggle();
        }
    }
}

