#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: hledger-web
version: 1.14.1
id: hledger-web-1.14.1-DfgRJr7P2VECHBnfPhekLD
key: hledger-web-1.14.1-DfgRJr7P2VECHBnfPhekLD
license: GPL-3.0-only
maintainer: Simon Michael <simon@joyful.com>
author: Simon Michael <simon@joyful.com>
stability: stable
homepage: http://hledger.org
synopsis: Web interface for the hledger accounting tool
description:
    This is hledger'\''s web interface.
    It provides a more user-friendly and collaborative UI than the
    command-line or curses-style interfaces.
    .
    hledger is a cross-platform program for tracking money, time, or
    any other commodity, using double-entry accounting and a simple,
    editable file format. It is inspired by and largely compatible
    with ledger(1).  hledger provides command-line, curses and web
    interfaces, and aims to be a reliable, practical tool for daily
    use.
category: Finance
abi: af3dda6220108d8a6f9de7870c5d694c
exposed: True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Foundation
    Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Import Hledger.Web.Json Hledger.Web.Main
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.WebOptions Hledger.Web.Widget.AddForm
    Hledger.Web.Widget.Common
hidden-modules: Paths_hledger_web
import-dirs: /usr/lib/ghc-8.6.5/site-local/hledger-web-1.14.1
library-dirs: /usr/lib/ghc-8.6.5/site-local/hledger-web-1.14.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/hledger-web
hs-libraries: HShledger-web-1.14.1-DfgRJr7P2VECHBnfPhekLD
depends:
    Decimal-0.5.1-I9pGBtCCqgxFDmNQco4frb
    aeson-1.4.3.0-3QzK2ng22UC3SLyLfNCRqk base-4.12.0.0
    blaze-html-0.9.1.1-6PAyIvh6hy6Ilt6w0CbPFV
    blaze-markup-0.8.2.2-IwLwNWRUxfsEuYbkQ0Gv5Q bytestring-0.10.8.2
    case-insensitive-1.2.1.0-L7BR5PaOPZy5cAHpLYQKhk
    clientsession-0.9.1.2-IiOQvz9SGPhFLhQQVuCMiy
    cmdargs-0.10.20-HFOpHQTj4XE8aEWjoI1u1
    conduit-1.3.1.1-GP6MsgQ2BS48W03o5Iyugz
    conduit-extra-1.3.1.1-BpNAtWN1v251tAneLnGOdO containers-0.6.0.1
    data-default-0.7.1.1-GQk9Hqcpzml6dpaWfistUm directory-1.3.3.0
    filepath-1.4.2.1 hjsmin-0.2.0.2-2HlUYbADoqVL81OSq4y1zl
    hledger-1.14.2-AIp69OKoh1g2em0PMUatMf
    hledger-lib-1.14.1-JhAEu4i55HIh0LPjncjk
    http-client-0.6.4-LXiPJxPJFMpGi3JM63704B
    http-conduit-2.3.7.1-2ZC0fwMOUr2EFpRPGM18wp
    http-types-0.12.3-1S9CCheq0oP9PZghw2BQoa
    json-0.9.3-GMBm0GlRjL45CY2W2ruX29
    megaparsec-7.0.5-2iUcnvfGmgfB7XKEYeVDVV mtl-2.2.2
    shakespeare-2.0.20-AAsYuO6E2hXKod2tV2Th2j template-haskell-2.14.0.0
    text-1.2.3.1 time-1.8.0.2 transformers-0.5.6.2
    wai-3.2.2-JhiHpDUxHXaFTRuLDNcWjT
    wai-extra-3.0.26-LO4JvMTXzGZGi4UH2l6Djh
    wai-handler-launch-3.0.2.4-51F5XGTsopsH3UE0VIfLtZ
    warp-3.2.27-IMqVOvNI2jhF8ztCZRnnnJ
    yaml-0.11.0.0-L7bQLoGqwtRImVPRR28f91
    yesod-1.6.0-B6kWSvdjqp5MkZWUOYGt1
    yesod-core-1.6.14-HB0qg3RgrKLInG4iRhjYcJ
    yesod-form-1.6.4-EFuj3VnhjxgIcW5d22ZHRW
    yesod-static-1.6.0.1-75nKo4N0MEk59jlhh9zFdn
haddock-interfaces: /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html: /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

