#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: statistics
version: 0.15.0.0
id: statistics-0.15.0.0-JGEj3NJUvDD5AubifkH7WC
key: statistics-0.15.0.0-JGEj3NJUvDD5AubifkH7WC
license: BSD-2-Clause
copyright: 2009-2014 Bryan O'\''Sullivan
maintainer: Bryan O'\''Sullivan <bos@serpentine.com>, Alexey Khudaykov <alexey.skladnoy@gmail.com>
author: Bryan O'\''Sullivan <bos@serpentine.com>, Alexey Khudaykov <alexey.skladnoy@gmail.com>
homepage: https://github.com/bos/statistics
synopsis: A library of statistical types, data, and functions
description:
    This library provides a number of common functions and types useful
    in statistics.  We focus on high performance, numerical robustness,
    and use of good algorithms.  Where possible, we provide
    references to the statistical literature.
    .
    The library'\''s facilities can be divided into four broad categories:
    .
    * Working with widely used discrete and continuous probability
    distributions.  (There are dozens of exotic distributions in use;
    we focus on the most common.)
    .
    * Computing with sample data: quantile estimation, kernel density
    estimation, histograms, bootstrap methods, significance testing,
    and regression and autocorrelation analysis.
    .
    * Random variate generation under several different distributions.
    .
    * Common statistical tests for significant differences between
    samples.
category: Math, Statistics
abi: f202ca084fe24e8e4c243cafcb019345
exposed: True
exposed-modules:
    Statistics.Autocorrelation Statistics.ConfidenceInt
    Statistics.Correlation Statistics.Correlation.Kendall
    Statistics.Distribution Statistics.Distribution.Beta
    Statistics.Distribution.Binomial
    Statistics.Distribution.CauchyLorentz
    Statistics.Distribution.ChiSquared
    Statistics.Distribution.DiscreteUniform
    Statistics.Distribution.Exponential
    Statistics.Distribution.FDistribution Statistics.Distribution.Gamma
    Statistics.Distribution.Geometric
    Statistics.Distribution.Hypergeometric
    Statistics.Distribution.Laplace Statistics.Distribution.Normal
    Statistics.Distribution.Poisson Statistics.Distribution.StudentT
    Statistics.Distribution.Transform Statistics.Distribution.Uniform
    Statistics.Function Statistics.Quantile Statistics.Regression
    Statistics.Resampling Statistics.Resampling.Bootstrap
    Statistics.Sample Statistics.Sample.Histogram
    Statistics.Sample.Internal Statistics.Sample.KernelDensity
    Statistics.Sample.KernelDensity.Simple Statistics.Sample.Normalize
    Statistics.Sample.Powers Statistics.Test.ChiSquared
    Statistics.Test.KolmogorovSmirnov Statistics.Test.KruskalWallis
    Statistics.Test.MannWhitneyU Statistics.Test.StudentT
    Statistics.Test.Types Statistics.Test.WilcoxonT
    Statistics.Transform Statistics.Types
hidden-modules: Statistics.Distribution.Poisson.Internal
                Statistics.Internal Statistics.Test.Internal
                Statistics.Types.Internal
import-dirs: /usr/lib/ghc-8.6.5/site-local/statistics-0.15.0.0
library-dirs: /usr/lib/ghc-8.6.5/site-local/statistics-0.15.0.0
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/x86_64-linux-ghc-8.6.5/statistics-0.15.0.0
hs-libraries: HSstatistics-0.15.0.0-JGEj3NJUvDD5AubifkH7WC
depends:
    aeson-1.4.3.0-3QzK2ng22UC3SLyLfNCRqk base-4.12.0.0
    base-orphans-0.8.1-HeyTAcy4PKhDcGhjvJwDzq binary-0.8.6.0
    data-default-class-0.1.2.0-1aigY0ifYUs4kfvMygEld7 deepseq-1.4.4.0
    dense-linear-algebra-0.1.0.0-4Ey7CX6VKGc5Xv2s9dCXKJ
    math-functions-0.3.1.0-GW8vg3sPECY78WvUCbZJWc
    monad-par-0.3.4.8-9K5fXgEogfdFYzoBNl49sk
    mwc-random-0.14.0.0-2pxNHDgDQNDAJj9EQzqdx2
    primitive-0.6.4.0-ILgywxtLpvnAOlEISPpP5b
    vector-0.12.0.3-2LEYu9M2i7lERDtz76XG3n
    vector-algorithms-0.8.0.1-4s0mIQGU3s1C8KiZioXwL7
    vector-binary-instances-0.2.5.1-Dz95yg9LO4QICxc7gaTUaF
    vector-th-unbox-0.2.1.6-LZLuOhl72IF7NW8IrRJm9b
haddock-interfaces: /usr/share/doc/haskell-statistics/html/statistics.haddock
haddock-html: /usr/share/doc/haskell-statistics/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

