#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: hackage-security
version: 0.5.3.0
id: hackage-security-0.5.3.0-5P0gqMwYi6r2vVtA3f36sy
key: hackage-security-0.5.3.0-5P0gqMwYi6r2vVtA3f36sy
license: BSD-3-Clause
copyright: Copyright 2015-2016 Well-Typed LLP
maintainer: cabal-devel@haskell.org
author: Edsko de Vries
homepage: https://github.com/haskell/hackage-security
synopsis: Hackage security library
description:
    The hackage security library provides both server and
    client utilities for securing the Hackage package server
    (<http://hackage.haskell.org/>).  It is based on The Update
    Framework (<http://theupdateframework.com/>), a set of
    recommendations developed by security researchers at
    various universities in the US as well as developers on the
    Tor project (<https://www.torproject.org/>).
    .
    The current implementation supports only index signing,
    thereby enabling untrusted mirrors. It does not yet provide
    facilities for author package signing.
    .
    The library has two main entry points:
    "Hackage.Security.Client" is the main entry point for
    clients (the typical example being @cabal@), and
    "Hackage.Security.Server" is the main entry point for
    servers (the typical example being @hackage-server@).
category: Distribution
abi: 37cff8ebfef1041342a30d8847100375
exposed: True
exposed-modules:
    Hackage.Security.Client Hackage.Security.Client.Formats
    Hackage.Security.Client.Repository
    Hackage.Security.Client.Repository.Cache
    Hackage.Security.Client.Repository.HttpLib
    Hackage.Security.Client.Repository.Local
    Hackage.Security.Client.Repository.Remote
    Hackage.Security.Client.Verify Hackage.Security.JSON
    Hackage.Security.Key.Env Hackage.Security.Server
    Hackage.Security.TUF.FileMap Hackage.Security.Trusted
    Hackage.Security.Util.Checked Hackage.Security.Util.IO
    Hackage.Security.Util.Lens Hackage.Security.Util.Path
    Hackage.Security.Util.Pretty Hackage.Security.Util.Some
    Text.JSON.Canonical
hidden-modules: Hackage.Security.Key Hackage.Security.Trusted.TCB
                Hackage.Security.TUF Hackage.Security.TUF.Common
                Hackage.Security.TUF.FileInfo Hackage.Security.TUF.Header
                Hackage.Security.TUF.Layout.Cache Hackage.Security.TUF.Layout.Index
                Hackage.Security.TUF.Layout.Repo Hackage.Security.TUF.Mirrors
                Hackage.Security.TUF.Paths Hackage.Security.TUF.Patterns
                Hackage.Security.TUF.Root Hackage.Security.TUF.Signed
                Hackage.Security.TUF.Snapshot Hackage.Security.TUF.Targets
                Hackage.Security.TUF.Timestamp Hackage.Security.Util.Base64
                Hackage.Security.Util.Exit Hackage.Security.Util.FileLock
                Hackage.Security.Util.JSON Hackage.Security.Util.Stack
                Hackage.Security.Util.TypedEmbedded Prelude
import-dirs: /usr/lib/ghc-8.6.5/site-local/hackage-security-0.5.3.0
library-dirs: /usr/lib/ghc-8.6.5/site-local/hackage-security-0.5.3.0
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/x86_64-linux-ghc-8.6.5/hackage-security-0.5.3.0
hs-libraries: HShackage-security-0.5.3.0-5P0gqMwYi6r2vVtA3f36sy
depends:
    Cabal-2.4.0.1 base-4.12.0.0
    base16-bytestring-0.1.1.6-17atVnUhDnM13pAkKbwL6I
    base64-bytestring-1.0.0.2-Exy4D7U0AzaE8TUydrgSTP
    bytestring-0.10.8.2 containers-0.6.0.1
    cryptohash-sha256-0.11.101.0-9cOp3wC8Mhw2Jq5ccmtAhx
    directory-1.3.3.0 ed25519-0.0.5.0-7cQiDizyG7J2idP2c5u3U2
    filepath-1.4.2.1 ghc-prim-0.5.3 mtl-2.2.2
    network-2.8.0.0-KwUidTBebCCJ8Fjkxwovi
    network-uri-2.6.1.0-K75fCYvLQE41EntOQ30cqK parsec-3.1.13.0
    pretty-1.1.3.6 tar-0.5.1.0-GcqFpTqelp4Lmy6ZbjHbS7
    template-haskell-2.14.0.0 time-1.8.0.2 transformers-0.5.6.2
    zlib-0.6.2-3orZ4PtYssfHtZIGrJhHYA
haddock-interfaces: /usr/share/doc/haskell-hackage-security/html/hackage-security.haddock
haddock-html: /usr/share/doc/haskell-hackage-security/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

