/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import java.util.Locale;

class Remover {
    private final String searchedText;
    private String searchedSubstring;
    private int begin;
    private int end;
    private int removedCharacterNumber;
    private String processedText;

    public String getProcessedText() {
        return this.processedText;
    }

    public Remover(String text) {
        this.processedText = text;
        this.searchedText = text.toLowerCase(Locale.ENGLISH);
        this.removedCharacterNumber = 0;
        this.end = 0;
        this.begin = 0;
    }

    public int getBegin() {
        return this.begin;
    }

    public int getEnd() {
        return this.end;
    }

    private String createSearchedSubstring(String substring) {
        return "<" + substring.toLowerCase(Locale.ENGLISH);
    }

    public boolean findFirst() {
        this.begin = this.removedCharacterNumber;
        return this.findNext();
    }

    public boolean findNext() {
        this.begin = this.searchedText.indexOf(this.searchedSubstring, this.begin);
        return this.findEndOfElement();
    }

    public boolean findLast() {
        this.begin = this.searchedText.lastIndexOf(this.searchedSubstring);
        return this.findEndOfElement();
    }

    private boolean findEndOfElement() {
        if (this.begin == -1) {
            this.end = -1;
            return false;
        }
        this.end = this.searchedText.indexOf(62, this.begin + this.searchedSubstring.length());
        if (this.end == -1) {
            this.begin = -1;
            return false;
        }
        ++this.end;
        return true;
    }

    public int getWhiteSpaceBefore() {
        if (this.begin <= 0) {
            return this.begin;
        }
        for (int i = this.begin - 1; i > 0; --i) {
            if (Character.isWhitespace(this.searchedText.charAt(i))) continue;
            return i + 1;
        }
        return 0;
    }

    public int getWhiteSpaceAfter() {
        if (this.end == -1) {
            return -1;
        }
        for (int i = this.end + 1; i < this.searchedText.length(); ++i) {
            if (Character.isWhitespace(this.searchedText.charAt(i))) continue;
            return i;
        }
        return this.searchedText.length();
    }

    public Remover removeFirstAndBefore(String element) {
        this.searchedSubstring = this.createSearchedSubstring(element);
        if (this.findFirst()) {
            int lastIndex = this.getWhiteSpaceAfter() - this.removedCharacterNumber;
            this.processedText = this.processedText.substring(lastIndex);
            this.removedCharacterNumber += lastIndex;
        }
        return this;
    }

    public Remover removeLastAndAfter(String element) {
        this.searchedSubstring = this.createSearchedSubstring(element);
        if (this.findLast()) {
            int firstIndex = this.getWhiteSpaceBefore() - this.removedCharacterNumber;
            this.processedText = this.processedText.substring(0, firstIndex);
        }
        return this;
    }

    public static void main(String[] argv) {
        String text = "\n\t<body> 1 </body>";
        Remover removeFirstAndBefore = new Remover(text).removeFirstAndBefore("body");
        String removeLastAndAfter = removeFirstAndBefore.removeLastAndAfter("/body").getProcessedText();
        System.out.println('\"' + removeLastAndAfter + '\"');
    }
}

