define(["datetime","imageLoader","connectionManager","itemHelper","focusManager","indicators","globalize","layoutManager","apphost","dom","browser","playbackManager","itemShortcuts","css!./card","paper-icon-button-light","programStyles","embyProgressBarStyle"],function(datetime,imageLoader,connectionManager,itemHelper,focusManager,indicators,globalize,layoutManager,appHost,dom,browser,playbackManager,itemShortcuts){"use strict";function getCardsHtml(items,options){return 1===arguments.length&&(options=arguments[0],items=options.items),buildCardsHtmlInternal(items,options)}function getWidth(shape,screenWidth){var key=shape+screenWidth,width=cachedWidths[key];if(width)return width;var div=document.createElement("div");div.className="itemsContainer",layoutManager.tv&&div.classList.add("itemsContainer-tv"),div.style.visibility="hidden",div.innerHTML='<div class="card '+shape+'Card"><div class="cardBox"><div class="cardScalable"></div></div></div>';var parent=document.body;return parent.appendChild(div),width=cachedWidths[key]=div.querySelector(".cardScalable").offsetWidth,parent.removeChild(div),width}function isResizable(windowWidth){var screen=window.screen;if(screen){if(screen.availWidth-windowWidth>20)return!0}return!1}function getImageWidth(shape,screenWidth){var imagesPerRow=screenWidth/getWidth(shape,screenWidth),shapeWidth=screenWidth/imagesPerRow;return Math.round(shapeWidth)}function getDefaultShape(items,requestedShape){var firstItem=items[0];if(firstItem)switch(firstItem.Type){case"Movie":case"SeriesTimer":return"autooverflow"===requestedShape?"overflowPortrait":"portrait";case"Episode":case"Program":case"Video":return"autooverflow"===requestedShape?"overflowBackdrop":"backdrop"}return"autooverflow"===requestedShape?"overflowSquare":"square"}function setCardData(items,options){options.shape=options.shape||"auto";var primaryImageAspectRatio=imageLoader.getPrimaryImageAspectRatio(items);if("auto"===options.shape||"autohome"===options.shape||"autooverflow"===options.shape||"autoVertical"===options.shape){var requestedShape=options.shape;options.shape=null,primaryImageAspectRatio&&(options.shape=primaryImageAspectRatio>=3?"banner":primaryImageAspectRatio>=1.4?"autooverflow"===requestedShape?"overflowBackdrop":"backdrop":primaryImageAspectRatio>1.2?"autooverflow"===requestedShape?"overflowFourThree":"fourThree":primaryImageAspectRatio>.71?"autooverflow"===requestedShape?"overflowSquare":"square":"autooverflow"===requestedShape?"overflowPortrait":"portrait"),options.shape||(options.shape=options.defaultShape||getDefaultShape(items,requestedShape))}if("auto"===options.preferThumb&&(options.preferThumb="backdrop"===options.shape||"overflowBackdrop"===options.shape),options.uiAspect=getDesiredAspect(options.shape),options.primaryImageAspectRatio=primaryImageAspectRatio,!options.width&&options.widths&&(options.width=options.widths[options.shape]),options.rows&&"number"!=typeof options.rows&&(options.rows=options.rows[options.shape]),!options.width){var screenWidth=dom.getWindowSize().innerWidth;if(isResizable(screenWidth)){screenWidth=100*Math.floor(screenWidth/100)}options.width=getImageWidth(options.shape,screenWidth)}}function buildCardsHtmlInternal(items,options){options.shape,setCardData(items,options);var hasOpenRow,apiClient,lastServerId,i,length,html="",itemsInRow=0,uiAspect=(options.sectionTitleTagName,getDesiredAspect(options.shape));for(i=0,length=items.length;i<length;i++){var item=items[i],serverId=item.ServerId||options.serverId;serverId!==lastServerId&&(lastServerId=serverId,apiClient=connectionManager.getApiClient(lastServerId)),options.rows&&0===itemsInRow&&(hasOpenRow&&(html+="</div>",hasOpenRow=!1),html+='<div class="cardColumn">',hasOpenRow=!0),html+=buildCard(i,item,apiClient,options,uiAspect),itemsInRow++,options.rows&&itemsInRow>=options.rows&&(html+="</div>",hasOpenRow=!1,itemsInRow=0)}hasOpenRow&&(html+="</div>");var cardFooterHtml="";for(i=0,length=options.lines||0;i<length;i++)cardFooterHtml+=0===i?'<div class="cardText cardTextCentered cardText-first">&nbsp;</div>':'<div class="cardText cardTextCentered cardText-secondary">&nbsp;</div>';return html}function getDesiredAspect(shape){if(shape){if(shape=shape.toLowerCase(),-1!==shape.indexOf("portrait"))return 2/3;if(-1!==shape.indexOf("backdrop"))return 16/9;if(-1!==shape.indexOf("square"))return 1;if(-1!==shape.indexOf("fourthree"))return 4/3;if(-1!==shape.indexOf("banner"))return 1e3/185}return null}function getCardImageUrl(item,apiClient,options,shape,uiAspect){item=item.ProgramInfo||item;var width=options.width,height=null,primaryImageAspectRatio=item.PrimaryImageAspectRatio,forceName=!1,imgUrl=null,coverImage=!1,imageTags=item.ImageTags;return options.preferThumb&&imageTags&&imageTags.Thumb?imgUrl=apiClient.getScaledImageUrl(item.Id,{type:"Thumb",maxWidth:width,tag:imageTags.Thumb}):(options.preferBanner||"banner"===shape)&&imageTags&&imageTags.Banner?imgUrl=apiClient.getScaledImageUrl(item.Id,{type:"Banner",maxWidth:width,tag:imageTags.Banner}):options.preferDisc&&imageTags&&imageTags.Disc?imgUrl=apiClient.getScaledImageUrl(item.Id,{type:"Disc",maxWidth:width,tag:imageTags.Disc}):options.preferLogo&&imageTags&&imageTags.Logo?imgUrl=apiClient.getScaledImageUrl(item.Id,{type:"Logo",maxWidth:width,tag:imageTags.Logo}):options.preferLogo&&item.ParentLogoImageTag&&item.ParentLogoItemId?imgUrl=apiClient.getScaledImageUrl(item.ParentLogoItemId,{type:"Logo",maxWidth:width,tag:item.ParentLogoImageTag}):options.preferThumb&&item.SeriesThumbImageTag&&!1!==options.inheritThumb?imgUrl=apiClient.getScaledImageUrl(item.SeriesId,{type:"Thumb",maxWidth:width,tag:item.SeriesThumbImageTag}):options.preferThumb&&item.ParentThumbItemId&&!1!==options.inheritThumb&&"Photo"!==item.MediaType?imgUrl=apiClient.getScaledImageUrl(item.ParentThumbItemId,{type:"Thumb",maxWidth:width,tag:item.ParentThumbImageTag}):options.preferThumb&&item.BackdropImageTags&&item.BackdropImageTags.length?(imgUrl=apiClient.getScaledImageUrl(item.Id,{type:"Backdrop",maxWidth:width,tag:item.BackdropImageTags[0]}),forceName=!0):options.preferThumb&&item.ParentBackdropImageTags&&item.ParentBackdropImageTags.length&&!1!==options.inheritThumb&&"Episode"===item.Type?imgUrl=apiClient.getScaledImageUrl(item.ParentBackdropItemId,{type:"Backdrop",maxWidth:width,tag:item.ParentBackdropImageTags[0]}):imageTags&&imageTags.Primary?(height=width&&primaryImageAspectRatio?Math.round(width/primaryImageAspectRatio):null,imgUrl=apiClient.getScaledImageUrl(item.Id,{type:"Primary",maxHeight:height,maxWidth:width,tag:imageTags.Primary}),options.preferThumb&&!1!==options.showTitle&&(forceName=!0),primaryImageAspectRatio&&uiAspect&&(coverImage=Math.abs(primaryImageAspectRatio-uiAspect)/uiAspect<=.28)):item.PrimaryImageTag?(height=width&&primaryImageAspectRatio?Math.round(width/primaryImageAspectRatio):null,imgUrl=apiClient.getScaledImageUrl(item.PrimaryImageItemId||item.Id||item.ItemId,{type:"Primary",maxHeight:height,maxWidth:width,tag:item.PrimaryImageTag}),options.preferThumb&&!1!==options.showTitle&&(forceName=!0),primaryImageAspectRatio&&uiAspect&&(coverImage=Math.abs(primaryImageAspectRatio-uiAspect)/uiAspect<=.28)):item.ParentPrimaryImageTag?imgUrl=apiClient.getScaledImageUrl(item.ParentPrimaryImageItemId,{type:"Primary",maxWidth:width,tag:item.ParentPrimaryImageTag}):item.SeriesPrimaryImageTag?imgUrl=apiClient.getScaledImageUrl(item.SeriesId,{type:"Primary",maxWidth:width,tag:item.SeriesPrimaryImageTag}):item.AlbumId&&item.AlbumPrimaryImageTag?(width=primaryImageAspectRatio?Math.round(height*primaryImageAspectRatio):null,imgUrl=apiClient.getScaledImageUrl(item.AlbumId,{type:"Primary",maxHeight:height,maxWidth:width,tag:item.AlbumPrimaryImageTag}),primaryImageAspectRatio&&uiAspect&&(coverImage=Math.abs(primaryImageAspectRatio-uiAspect)/uiAspect<=.28)):"Season"===item.Type&&imageTags&&imageTags.Thumb?imgUrl=apiClient.getScaledImageUrl(item.Id,{type:"Thumb",maxWidth:width,tag:imageTags.Thumb}):item.BackdropImageTags&&item.BackdropImageTags.length?imgUrl=apiClient.getScaledImageUrl(item.Id,{type:"Backdrop",maxWidth:width,tag:item.BackdropImageTags[0]}):imageTags&&imageTags.Thumb?imgUrl=apiClient.getScaledImageUrl(item.Id,{type:"Thumb",maxWidth:width,tag:imageTags.Thumb}):item.SeriesThumbImageTag&&!1!==options.inheritThumb?imgUrl=apiClient.getScaledImageUrl(item.SeriesId,{type:"Thumb",maxWidth:width,tag:item.SeriesThumbImageTag}):item.ParentThumbItemId&&!1!==options.inheritThumb?imgUrl=apiClient.getScaledImageUrl(item.ParentThumbItemId,{type:"Thumb",maxWidth:width,tag:item.ParentThumbImageTag}):item.ParentBackdropImageTags&&item.ParentBackdropImageTags.length&&!1!==options.inheritThumb&&(imgUrl=apiClient.getScaledImageUrl(item.ParentBackdropItemId,{type:"Backdrop",maxWidth:width,tag:item.ParentBackdropImageTags[0]})),{imgUrl:imgUrl,forceName:forceName,coverImage:coverImage}}function getRandomInt(min,max){return Math.floor(Math.random()*(max-min+1))+min}function getDefaultColorIndex(str){if(str){for(var charIndex=Math.floor(str.length/2),character=String(str.substr(charIndex,1).charCodeAt()),sum=0,i=0;i<character.length;i++)sum+=parseInt(character.charAt(i));return String(sum).substr(-1)%numRandomColors+1}return getRandomInt(1,numRandomColors)}function getCardTextLines(lines,cssClass,forceLines,isOuterFooter,cardLayout,addRightMargin,maxLines){var i,length,html="",valid=0,currentCssClass=cssClass;for(i=0,length=lines.length;i<length;i++){currentCssClass=cssClass;var text=lines[i];if(valid>0&&isOuterFooter?currentCssClass+=" cardText-secondary":0===valid&&isOuterFooter&&(currentCssClass+=" cardText-first"),addRightMargin&&(currentCssClass+=" cardText-rightmargin"),text&&(html+="<div class='"+currentCssClass+"'>",html+=text,html+="</div>",valid++,maxLines&&valid>=maxLines))break}if(forceLines)for(length=maxLines||Math.min(lines.length,maxLines||lines.length);valid<length;)currentCssClass=cssClass,valid>0&&isOuterFooter&&(currentCssClass+=" cardText-secondary"),html+="<div class='"+currentCssClass+"'>&nbsp;</div>",valid++;return html}function isUsingLiveTvNaming(itemType){return"Program"===itemType||"Timer"===itemType||"Recording"===itemType}function getAirTimeText(item,showAirDateTime,showAirEndTime){var airTimeText="";if(item.StartDate)try{var date=datetime.parseISO8601Date(item.StartDate);showAirDateTime&&(airTimeText+=datetime.toLocaleDateString(date,{weekday:"short",month:"short",day:"numeric"})+" "),airTimeText+=datetime.getDisplayTime(date),item.EndDate&&showAirEndTime&&(date=datetime.parseISO8601Date(item.EndDate),airTimeText+=" &ndash; "+datetime.getDisplayTime(date))}catch(e){console.log("Error parsing date: "+item.StartDate)}return airTimeText}function getCardFooterText(item,apiClient,options,showTitle,forceName,overlayText,imgUrl,footerClass,progressHtml,logoUrl,isOuterFooter){var itemType=item.Type,html="";logoUrl&&(html+='<div class="lazy cardFooterLogo" data-src="'+logoUrl+'"></div>');var showOtherText=isOuterFooter?!overlayText:overlayText;isOuterFooter&&options.cardLayout&&layoutManager.mobile&&!1!==options.cardFooterAside&&(html+='<button is="paper-icon-button-light" class="itemAction btnCardOptions cardText-secondary" data-action="menu"><i class="md-icon">&#xE5D3;</i></button>');var titleAdded,cssClass=options.centerText?"cardText cardTextCentered":"cardText",lines=[],parentTitleUnderneath="MusicAlbum"===itemType||"Audio"===itemType||"MusicVideo"===itemType||"Game"===itemType,serverId=item.ServerId||options.serverId;if(showOtherText&&(options.showParentTitle||options.showParentTitleOrTitle)&&!parentTitleUnderneath)if(isOuterFooter&&"Episode"===itemType&&item.SeriesName)item.SeriesId?lines.push(getTextActionButton({Id:item.SeriesId,ServerId:serverId,Name:item.SeriesName,Type:"Series",IsFolder:!0})):lines.push(dom.htmlEncode(item.SeriesName));else if(isUsingLiveTvNaming(itemType))lines.push(dom.htmlEncode(item.Name)),item.EpisodeTitle||(titleAdded=!0);else{var parentTitle=item.SeriesName||item.Series||item.Album||item.AlbumArtist||item.GameSystem||"";(parentTitle||showTitle)&&lines.push(dom.htmlEncode(parentTitle))}var showMediaTitle=showTitle&&!titleAdded||options.showParentTitleOrTitle&&!lines.length;if(showMediaTitle||titleAdded||!showTitle&&!forceName||(showMediaTitle=!0),showMediaTitle){var name="auto"!==options.showTitle||item.IsFolder||"Photo"!==item.MediaType?itemHelper.getDisplayName(item,{includeParentInfo:options.includeParentInfoInTitle}):"";lines.push(getTextActionButton(item,name,serverId,options.parentId))}if(showOtherText){if(options.showParentTitle&&parentTitleUnderneath&&(isOuterFooter&&item.AlbumArtists&&item.AlbumArtists.length&&"MusicAlbum"===itemType?(item.AlbumArtists[0].Type="MusicArtist",item.AlbumArtists[0].IsFolder=!0,lines.push(getTextActionButton(item.AlbumArtists[0],null,serverId))):isOuterFooter&&item.ArtistItems&&item.ArtistItems.length?(item.ArtistItems[0].Type="MusicArtist",item.ArtistItems[0].IsFolder=!0,lines.push(getTextActionButton(item.ArtistItems[0],null,serverId))):isOuterFooter&&item.AlbumArtists&&item.AlbumArtists.length?(item.AlbumArtists[0].Type="MusicArtist",item.AlbumArtists[0].IsFolder=!0,lines.push(getTextActionButton(item.AlbumArtists[0],null,serverId))):isOuterFooter&&item.GameSystem&&item.GameSystemId?lines.push(getTextActionButton({Id:item.GameSystemId,ServerId:serverId,Name:item.GameSystem,Type:"GameSystem",IsFolder:!0})):lines.push(dom.htmlEncode(isUsingLiveTvNaming(itemType)?item.Name:item.SeriesName||item.Series||item.Album||item.AlbumArtist||item.GameSystem||""))),options.textLines)for(var additionalLines=options.textLines(item),i=0,length=additionalLines.length;i<length;i++)lines.push(additionalLines[i]);if(options.showYear)if("Series"===itemType)if("Continuing"===item.Status)lines.push(globalize.translate("SeriesYearToPresent",item.ProductionYear||""));else{var endYear=item.EndDate?datetime.parseISO8601Date(item.EndDate).getFullYear():null;endYear&&item.ProductionYear&&endYear!==item.ProductionYear?lines.push(item.ProductionYear+" &ndash; "+endYear):lines.push(item.ProductionYear||"")}else lines.push(item.ProductionYear||"");options.showRuntime&&(item.RunTimeTicks?lines.push(datetime.getDisplayRunningTime(item.RunTimeTicks)):lines.push("")),options.showAirTime&&lines.push(getAirTimeText(item,options.showAirDateTime,options.showAirEndTime)||""),options.showChannelName&&(item.ChannelId?lines.push(getTextActionButton({Id:item.ChannelId,ServerId:serverId,Name:item.ChannelName,Type:"TvChannel",MediaType:item.MediaType,IsFolder:!1},item.ChannelName)):lines.push(item.ChannelName||"&nbsp;")),options.showCurrentProgram&&"TvChannel"===itemType&&(item.CurrentProgram?lines.push(item.CurrentProgram.Name):lines.push("")),options.showCurrentProgramTime&&"TvChannel"===itemType&&(item.CurrentProgram?lines.push(getAirTimeText(item.CurrentProgram,!1,!0)||""):lines.push("")),options.showSeriesTimerTime&&(item.RecordAnyTime?lines.push(globalize.translate("Anytime")):lines.push(datetime.getDisplayTime(item.StartDate))),options.showSeriesTimerChannel&&(item.RecordAnyChannel?lines.push(globalize.translate("AllChannels")):lines.push(item.ChannelName||globalize.translate("OneChannel"))),options.showPersonRoleOrType&&(item.Role?lines.push(globalize.translate("ActorAsRole",item.Role)):itemType?lines.push(globalize.translate(""+itemType)):lines.push(""))}(showTitle||!imgUrl)&&forceName&&overlayText&&1===lines.length&&(lines=[]);var addRightTextMargin=isOuterFooter&&options.cardLayout&&!options.centerText&&"none"!==options.cardFooterAside&&layoutManager.mobile;return html+=getCardTextLines(lines,cssClass,!options.overlayText,isOuterFooter,options.cardLayout,addRightTextMargin,options.lines),progressHtml&&(html+=progressHtml),html&&(!isOuterFooter||logoUrl||options.cardLayout)&&(html='<div class="'+footerClass+'">'+html,html+="</div>"),html}function getTextActionButton(item,text,serverId,parentId){if(text||(text=itemHelper.getDisplayName(item)),layoutManager.tv)return dom.htmlEncode(text);text=dom.htmlEncode(text);var parentIdData=parentId?' data-parentid="'+parentId+'"':"",html="<button"+parentIdData+' title="'+text+'" '+itemShortcuts.getShortcutAttributesHtml(item,serverId)+' type="button" class="itemAction textActionButton cardTextActionButton" data-action="link">';return html+=text,html+="</button>"}function requireRefreshIndicator(){refreshIndicatorLoaded||(refreshIndicatorLoaded=!0,require(["emby-itemrefreshindicator"]))}function getDefaultBackgroundClass(str){return"defaultCardBackground defaultCardBackground"+getDefaultColorIndex(str)}function buildCard(index,item,apiClient,options,uiAspect){var itemType=item.Type,action=options.action||"link";"play"===action&&item.IsFolder?action="link":"Photo"===item.MediaType&&(action="play");var shape=options.shape,className="card";shape&&(className+=" "+shape+"Card"),options.cardCssClass&&(className+=" "+options.cardCssClass),options.cardClass&&(className+=" "+options.cardClass);var isLayoutTv=layoutManager.tv,isLayoutDesktop=layoutManager.desktop,isLayoutMobile=layoutManager.mobile;isLayoutDesktop&&(className+=" card-hoverable"),enableFocusTransfrom&&isLayoutTv||(className+=" card-nofocustransform");var imgInfo=getCardImageUrl(item,apiClient,options,shape,uiAspect),imgUrl=imgInfo.imgUrl,forceName=imgInfo.forceName,showTitle="auto"===options.showTitle||(options.showTitle||"PhotoAlbum"===itemType||"Folder"===itemType),overlayText=options.overlayText;forceName&&!options.cardLayout&&null==overlayText&&(overlayText=!0);var cardImageContainerClass="cardImageContainer";(options.coverImage||imgInfo.coverImage)&&(cardImageContainerClass+=" coveredImage","Photo"!==item.MediaType&&"PhotoAlbum"!==itemType&&"Folder"!==itemType&&"Program"!==itemType&&"Recording"!==itemType&&"TvChannel"!==itemType||(cardImageContainerClass+=" coveredImage-noScale")),options.defaultBackground?cardImageContainerClass+=" defaultCardBackground defaultCardBackground0":imgUrl||(cardImageContainerClass+=" "+getDefaultBackgroundClass(item.Name));var cardBoxClass=options.cardLayout?"cardBox visualCardBox":"cardBox";isLayoutTv&&(cardBoxClass+=enableFocusTransfrom?" cardBox-focustransform cardBox-withfocuscontent":" cardBox-withfocuscontent-large",options.cardLayout&&(cardBoxClass+=" card-focuscontent",enableFocusTransfrom||(cardBoxClass+=" card-focuscontent-large")));var footerCssClass,logoUrl,progressHtml=indicators.getProgressBarHtml(item),innerCardFooter="",footerOverlayed=!1;options.showChannelLogo&&item.ChannelPrimaryImageTag?logoUrl=apiClient.getScaledImageUrl(item.ChannelId,{type:"Primary",height:40,tag:item.ChannelPrimaryImageTag}):options.showLogo&&item.ParentLogoImageTag&&(logoUrl=apiClient.getScaledImageUrl(item.ParentLogoItemId,{type:"Logo",height:40,tag:item.ParentLogoImageTag})),overlayText?(logoUrl=null,footerCssClass=progressHtml?"innerCardFooter fullInnerCardFooter":"innerCardFooter",innerCardFooter+=getCardFooterText(item,apiClient,options,showTitle,forceName,overlayText,imgUrl,footerCssClass,progressHtml,logoUrl,!1),footerOverlayed=!0):progressHtml&&(innerCardFooter+='<div class="innerCardFooter fullInnerCardFooter innerCardFooterClear">',innerCardFooter+=progressHtml,innerCardFooter+="</div>",progressHtml="");var outerCardFooter="";overlayText||footerOverlayed||(footerCssClass=options.cardLayout?"cardFooter":"cardFooter cardFooter-transparent",logoUrl&&(footerCssClass+=" cardFooter-withlogo"),options.cardLayout||(logoUrl=null),outerCardFooter=getCardFooterText(item,apiClient,options,showTitle,forceName,overlayText,imgUrl,footerCssClass,progressHtml,logoUrl,!0)),outerCardFooter&&!options.cardLayout&&(cardBoxClass+=" cardBox-bottompadded");var overlayButtons="";if(isLayoutMobile){options.centerPlayButton&&(overlayButtons+='<button is="paper-icon-button-light" class="cardOverlayButton cardOverlayButton-br itemAction cardOverlayButton-centered" data-action="play"><i class="md-icon cardOverlayButtonIcon">&#xE037;</i></button>')}options.showChildCountIndicator&&item.ChildCount&&(className+=" groupedCard");var cardImageContainerOpen,cardImageContainerClose="",cardBoxClose="",cardScalableClose="",cardContentClass="cardContent";options.cardLayout||(cardContentClass+=" cardContent-shadow"),isLayoutTv?(cardImageContainerOpen=imgUrl?'<div class="'+cardImageContainerClass+" "+cardContentClass+' lazy" data-src="'+imgUrl+'">':'<div class="'+cardImageContainerClass+" "+cardContentClass+'">',cardImageContainerClose="</div>"):(isLayoutMobile&&(className+=" card-touchzoom"),cardImageContainerOpen=imgUrl?'<button data-action="'+action+'" class="cardContent-button '+cardImageContainerClass+" "+cardContentClass+' itemAction lazy" data-src="'+imgUrl+'">':'<button data-action="'+action+'" class="cardContent-button '+cardImageContainerClass+" "+cardContentClass+' itemAction">',cardImageContainerClose="</button>");var cardScalableClass="cardScalable";isLayoutTv&&!options.cardLayout&&(cardScalableClass+=" card-focuscontent",enableFocusTransfrom||(cardScalableClass+=" card-focuscontent-large")),cardImageContainerOpen='<div class="'+cardBoxClass+'"><div class="'+cardScalableClass+'"><div class="cardPadder-'+shape+'"></div>'+cardImageContainerOpen,cardBoxClose="</div>",cardScalableClose="</div>",cardImageContainerOpen+=indicators.getTypeIndicator(item);var indicatorsHtml="";if(!1!==options.missingIndicator&&(indicatorsHtml+=indicators.getMissingIndicator(item)),indicatorsHtml+=indicators.getSyncIndicator(item),indicatorsHtml+=indicators.getTimerIndicator(item),indicatorsHtml+=indicators.getPlayedIndicatorHtml(item),"CollectionFolder"===itemType||item.CollectionType){indicatorsHtml+='<div is="emby-itemrefreshindicator"'+(item.RefreshProgress?"":' class="hide"')+' data-progress="'+(item.RefreshProgress||0)+'" data-status="'+item.RefreshStatus+'"></div>',requireRefreshIndicator()}indicatorsHtml&&(cardImageContainerOpen+='<div class="cardIndicators">'+indicatorsHtml+"</div>"),imgUrl||(cardImageContainerOpen+=getCardDefaultText(item,options));var tagName=isLayoutTv&&!overlayButtons?"button":"div",nameWithPrefix=item.SortName||item.Name||"",prefix=nameWithPrefix.substring(0,Math.min(3,nameWithPrefix.length));prefix&&(prefix=prefix.toUpperCase());var timerAttributes="";item.TimerId&&(timerAttributes+=' data-timerid="'+item.TimerId+'"'),item.SeriesTimerId&&(timerAttributes+=' data-seriestimerid="'+item.SeriesTimerId+'"');var actionAttribute;"button"===tagName?(className+=" itemAction",actionAttribute=' data-action="'+action+'"'):actionAttribute="","MusicAlbum"!==itemType&&"MusicArtist"!==itemType&&"Audio"!==itemType&&(className+=" card-withuserdata");var positionTicksData=item.UserData&&item.UserData.PlaybackPositionTicks?' data-positionticks="'+item.UserData.PlaybackPositionTicks+'"':"",multiSelectData=!1===options.multiSelect?' data-multiselect="false"':"",collectionIdData=options.collectionId?' data-collectionid="'+options.collectionId+'"':"",playlistIdData=options.playlistId?' data-playlistid="'+options.playlistId+'"':"",mediaTypeData=item.MediaType?' data-mediatype="'+item.MediaType+'"':"",collectionTypeData=item.CollectionType?' data-collectiontype="'+item.CollectionType+'"':"",channelIdData=item.ChannelId?' data-channelid="'+item.ChannelId+'"':"",contextData=options.context?' data-context="'+options.context+'"':"",parentIdData=options.parentId?' data-parentid="'+options.parentId+'"':"",additionalCardContent="";return isLayoutDesktop&&(additionalCardContent+=getHoverMenuHtml(item,action,options)),"<"+tagName+' data-index="'+index+'"'+timerAttributes+actionAttribute+' data-isfolder="'+(item.IsFolder||!1)+'" data-serverid="'+(item.ServerId||options.serverId)+'" data-id="'+(item.Id||item.ItemId)+'" data-type="'+itemType+'"'+mediaTypeData+collectionTypeData+channelIdData+positionTicksData+collectionIdData+multiSelectData+playlistIdData+contextData+parentIdData+' data-prefix="'+prefix+'" class="'+className+'">'+cardImageContainerOpen+innerCardFooter+cardImageContainerClose+overlayButtons+additionalCardContent+cardScalableClose+outerCardFooter+cardBoxClose+"</"+tagName+">"}function getHoverMenuHtml(item,action,options){var html="";html+='<div class="cardOverlayContainer itemAction" data-action="'+action+'">';var btnCssClass="cardOverlayButton cardOverlayButton-hover itemAction",serverId=item.ServerId||options.serverId,itemType=item.Type,itemId=item.Id;!1!==options.multiSelect&&(require(["emby-checkbox"]),html+='<label data-action="multiselect" data-id="'+itemId+'" data-serverid="'+serverId+'"  class="chkCardSelectContainer cardOverlayButton cardOverlayButton-hover itemAction"><input class="chkCardSelect" is="emby-checkbox" type="checkbox" data-focushelper="false" /></label>'),playbackManager.canPlay(item)&&!1!==options.hoverPlayButton&&(html+='<button is="paper-icon-button-light" class="'+btnCssClass+' cardOverlayFab-primary" data-action="resume"><i class="md-icon cardOverlayButtonIcon">&#xE037;</i></button>'),html+='<div class="cardOverlayButton-br">';var userData=item.UserData||{};if(itemHelper.canMarkPlayed(item)&&(require(["emby-playstatebutton"]),html+='<button is="emby-playstatebutton" type="button" data-action="none" class="'+btnCssClass+'" data-id="'+itemId+'" data-serverid="'+serverId+'" data-itemtype="'+itemType+'" data-played="'+userData.Played+'"><i class="md-icon cardOverlayButtonIcon cardOverlayButtonIcon-hover">&#xE5CA;</i></button>'),itemHelper.canRate(item)){var likes=null==userData.Likes?"":userData.Likes;require(["emby-ratingbutton"]),html+='<button is="emby-ratingbutton" type="button" data-action="none" class="'+btnCssClass+'" data-id="'+itemId+'" data-serverid="'+serverId+'" data-itemtype="'+itemType+'" data-likes="'+likes+'" data-isfavorite="'+userData.IsFavorite+'"><i class="md-icon cardOverlayButtonIcon cardOverlayButtonIcon-hover">&#xE87D;</i></button>'}return html+='<button is="paper-icon-button-light" class="'+btnCssClass+'" data-action="menu"><i class="md-icon cardOverlayButtonIcon cardOverlayButtonIcon-hover">&#xE5D3;</i></button>',html+="</div>",html+="</div>"}function getCardDefaultText(item,options){var itemType=item.Type,collectionType=item.CollectionType;return"livetv"===collectionType?'<i class="cardImageIcon md-icon">&#xE1B2;</i>':"playlists"===collectionType?'<i class="cardImageIcon md-icon">&#xE5D2;</i>':"games"===collectionType?'<i class="cardImageIcon md-icon">&#xe30f;</i>':"homevideos"===collectionType||"photos"===collectionType?'<i class="cardImageIcon md-icon">&#xE412;</i>':"music"===collectionType?'<i class="cardImageIcon md-icon">&#xE310;</i>':"MusicAlbum"===itemType?'<i class="cardImageIcon md-icon">&#xE019;</i>':"MusicArtist"===itemType||"Person"===itemType?'<i class="cardImageIcon md-icon">&#xE7FD;</i>':"Channel"===itemType?'<i class="cardImageIcon md-icon">&#xE2C7;</i>':options.defaultCardImageIcon?'<i class="cardImageIcon md-icon">'+options.defaultCardImageIcon+"</i>":'<div class="cardText cardDefaultText">'+(isUsingLiveTvNaming(itemType)?item.Name:itemHelper.getDisplayName(item))+"</div>"}function buildCards(items,options){if(document.body.contains(options.itemsContainer)){if(options.parentContainer){if(!items.length)return void options.parentContainer.classList.add("hide");options.parentContainer.classList.remove("hide")}var html=buildCardsHtmlInternal(items,options);html?(options.itemsContainer.cardBuilderHtml!==html&&(options.itemsContainer.innerHTML=html,items.length<50?options.itemsContainer.cardBuilderHtml=html:options.itemsContainer.cardBuilderHtml=null),imageLoader.lazyChildren(options.itemsContainer)):(options.itemsContainer.innerHTML=html,options.itemsContainer.cardBuilderHtml=null),options.autoFocus&&focusManager.autoFocus(options.itemsContainer,!0)}}function ensureIndicators(card,indicatorsElem){if(indicatorsElem)return indicatorsElem;if(!(indicatorsElem=card.querySelector(".cardIndicators"))){var cardImageContainer=card.querySelector(".cardImageContainer");indicatorsElem=document.createElement("div"),indicatorsElem.classList.add("cardIndicators"),cardImageContainer.appendChild(indicatorsElem)}return indicatorsElem}function updateUserData(card,userData){var type=card.getAttribute("data-type"),enableCountIndicator="Series"===type||"BoxSet"===type||"Season"===type,indicatorsElem=null,playedIndicator=null,countIndicator=null,itemProgressBar=null;userData.Played?(playedIndicator=card.querySelector(".playedIndicator"),playedIndicator||(playedIndicator=document.createElement("div"),playedIndicator.classList.add("playedIndicator"),playedIndicator.classList.add("indicator"),indicatorsElem=ensureIndicators(card,indicatorsElem),indicatorsElem.appendChild(playedIndicator)),playedIndicator.innerHTML='<i class="md-icon indicatorIcon">&#xE5CA;</i>'):(playedIndicator=card.querySelector(".playedIndicator"))&&playedIndicator.parentNode.removeChild(playedIndicator),userData.UnplayedItemCount?(countIndicator=card.querySelector(".countIndicator"),countIndicator||(countIndicator=document.createElement("div"),countIndicator.classList.add("countIndicator"),indicatorsElem=ensureIndicators(card,indicatorsElem),indicatorsElem.appendChild(countIndicator)),countIndicator.innerHTML=userData.UnplayedItemCount):enableCountIndicator&&(countIndicator=card.querySelector(".countIndicator"))&&countIndicator.parentNode.removeChild(countIndicator);var progressHtml=indicators.getProgressBarHtml({Type:type,UserData:userData,MediaType:"Video"});if(progressHtml){if(!(itemProgressBar=card.querySelector(".itemProgressBar"))){itemProgressBar=document.createElement("div"),itemProgressBar.classList.add("itemProgressBar");var innerCardFooter=card.querySelector(".innerCardFooter");if(!innerCardFooter){innerCardFooter=document.createElement("div"),innerCardFooter.classList.add("innerCardFooter");card.querySelector(".cardImageContainer").appendChild(innerCardFooter)}innerCardFooter.appendChild(itemProgressBar)}itemProgressBar.innerHTML=progressHtml}else(itemProgressBar=card.querySelector(".itemProgressBar"))&&itemProgressBar.parentNode.removeChild(itemProgressBar)}function onUserDataChanged(userData,scope){for(var cards=(scope||document.body).querySelectorAll('.card-withuserdata[data-id="'+userData.ItemId+'"]'),i=0,length=cards.length;i<length;i++)updateUserData(cards[i],userData)}function onTimerCreated(programId,newTimerId,itemsContainer){for(var cells=itemsContainer.querySelectorAll('.card[data-id="'+programId+'"]'),i=0,length=cells.length;i<length;i++){var cell=cells[i];if(!cell.querySelector(".timerIndicator")){ensureIndicators(cell).insertAdjacentHTML("beforeend",'<i class="md-icon timerIndicator indicatorIcon">&#xE061;</i>')}cell.setAttribute("data-timerid",newTimerId)}}function onTimerCancelled(id,itemsContainer){for(var cells=itemsContainer.querySelectorAll('.card[data-timerid="'+id+'"]'),i=0,length=cells.length;i<length;i++){var cell=cells[i],icon=cell.querySelector(".timerIndicator");icon&&icon.parentNode.removeChild(icon),cell.removeAttribute("data-timerid")}}function onSeriesTimerCancelled(id,itemsContainer){for(var cells=itemsContainer.querySelectorAll('.card[data-seriestimerid="'+id+'"]'),i=0,length=cells.length;i<length;i++){var cell=cells[i],icon=cell.querySelector(".timerIndicator");icon&&icon.parentNode.removeChild(icon),cell.removeAttribute("data-seriestimerid")}}var refreshIndicatorLoaded,enableFocusTransfrom=(window.devicePixelRatio,!browser.slow&&!browser.edge),cachedWidths={},numRandomColors=5;return{getCardsHtml:getCardsHtml,buildCards:buildCards,onUserDataChanged:onUserDataChanged,onTimerCreated:onTimerCreated,onTimerCancelled:onTimerCancelled,onSeriesTimerCancelled:onSeriesTimerCancelled}});