/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.c.hover;

import org.eclipse.cdt.internal.ui.text.AbstractSourceViewerInformationControl;
import org.eclipse.cdt.internal.ui.text.c.hover.CHoverMessages;
import org.eclipse.cdt.internal.ui.text.c.hover.CMacroExpansionExplorationControl;
import org.eclipse.cdt.internal.ui.text.c.hover.CMacroExpansionInput;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

public class CMacroExpansionControl
extends AbstractSourceViewerInformationControl {
    private CMacroExpansionInput fInput;

    public CMacroExpansionControl(Shell parent, String statusFieldText) {
        super(parent, statusFieldText);
        this.setTitleText(CHoverMessages.CMacroExpansionControl_title_macroExpansion);
    }

    public CMacroExpansionControl(Shell parent, boolean isResizable) {
        super(parent, isResizable);
        this.setTitleText(CHoverMessages.CMacroExpansionControl_title_macroExpansion);
    }

    @Override
    protected boolean hasHeader() {
        return true;
    }

    @Override
    public void setInput(Object input) {
        if (input instanceof CMacroExpansionInput) {
            CMacroExpansionInput macroExpansionInput = (CMacroExpansionInput)input;
            this.setInformation(macroExpansionInput.fExplorer.getFullExpansion().getCodeAfterStep());
            this.fInput = macroExpansionInput;
            this.updateStatusText();
        } else {
            this.fInput = null;
            super.setInput(input);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.setInput(null);
        }
    }

    private void updateStatusText() {
        String keySequence;
        IBindingService bindingService;
        if (this.fInput == null) {
            return;
        }
        if (this.fInput.fExplorer.getExpansionStepCount() > 1 && (bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class)) != null && (keySequence = bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.edit.text.showInformation")) != null) {
            this.setStatusText(NLS.bind((String)CHoverMessages.CMacroExpansionControl_exploreMacroExpansion, (Object)keySequence));
        }
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                if (CMacroExpansionControl.this.fInput != null && ((CMacroExpansionControl)CMacroExpansionControl.this).fInput.fExplorer.getExpansionStepCount() > 1) {
                    return new CMacroExpansionExplorationControl(parent, true);
                }
                return new CMacroExpansionControl(parent, true);
            }
        };
    }
}

