/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.outline;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.outline.CNFOutlinePage;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class EditorToOutlineAdapterFactory
implements IAdapterFactory {
    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        IDocument document;
        if (adapterType == IContentOutlinePage.class && adaptableObject instanceof IEditorPart && LanguageServersRegistry.getInstance().canUseLanguageServer(((IEditorPart)adaptableObject).getEditorInput()) && (document = LSPEclipseUtils.getDocument(((IEditorPart)adaptableObject).getEditorInput())) != null) {
            CompletableFuture<List<@NonNull LanguageServer>> languageServers = LanguageServiceAccessor.getLanguageServers(document, capabilities -> Boolean.TRUE.equals(capabilities.getDocumentSymbolProvider()));
            List<@NonNull Object> servers = Collections.emptyList();
            try {
                servers = languageServers.get(50L, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException | TimeoutException e) {
                LanguageServerPlugin.logError(e);
            }
            catch (InterruptedException e) {
                LanguageServerPlugin.logError(e);
                Thread.currentThread().interrupt();
            }
            if (!servers.isEmpty()) {
                LanguageServer languageServer = (LanguageServer)servers.get(0);
                ITextEditor textEditor = null;
                if (adaptableObject instanceof ITextEditor) {
                    textEditor = (ITextEditor)adaptableObject;
                }
                return (T)new CNFOutlinePage(languageServer, textEditor);
            }
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{IContentOutlinePage.class};
    }
}

