/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.runtime;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeInstall;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeType;
import org.eclipse.wst.jsdt.core.runtime.JSRuntimeManager;
import org.eclipse.wst.jsdt.internal.core.runtime.RuntimeMessages;

public abstract class AbstractJSRuntimeType
implements IJSRuntimeType,
IExecutableExtension {
    protected String fId;

    public final void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.fId = config.getAttribute("id");
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public final IJSRuntimeInstall createRuntimeInstall(String id) {
        if (JSRuntimeManager.getJSRuntimeInstall(id) != null) {
            throw new IllegalArgumentException(NLS.bind((String)RuntimeMessages.AbstractJSRuntimeType_DuplicateRuntimeInstall_Error, (Object)id));
        }
        IJSRuntimeInstall runtimeInstall = null;
        runtimeInstall = this.doCreateRuntimeInstall(id);
        return runtimeInstall;
    }

    protected abstract IJSRuntimeInstall doCreateRuntimeInstall(String var1);

    @Override
    public final IStatus validateInstallLocation(File tempFile) {
        if (tempFile == null) {
            return new Status(4, "org.eclipse.wst.jsdt.core", RuntimeMessages.AbstractJSRuntimeType_NullPath_Error);
        }
        if (!tempFile.exists()) {
            return new Status(4, "org.eclipse.wst.jsdt.core", NLS.bind((String)RuntimeMessages.AbstractJSRuntimeType_UnexistingInstallLocation_Error, (Object)tempFile.getAbsolutePath()));
        }
        return this.doValidateInstallLocation(tempFile);
    }

    protected abstract IStatus doValidateInstallLocation(File var1);
}

