/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.buildship.core.internal.preferences.PersistentModel;
import org.eclipse.buildship.core.internal.workspace.ManagedModelMergingStrategy;
import org.eclipse.buildship.core.internal.workspace.PersistentModelBuilder;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.gradle.tooling.model.eclipse.EclipseBuildCommand;

final class BuildCommandUpdater {
    BuildCommandUpdater() {
    }

    public static void update(IProject project, List<EclipseBuildCommand> buildCommands, PersistentModelBuilder persistentModel, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        ImmutableSet current = ImmutableSet.copyOf((Object[])description.getBuildSpec());
        Set<ICommand> model = BuildCommandUpdater.toCommands(buildCommands, description);
        PersistentModel previousModel = persistentModel.getPrevious();
        LinkedHashSet managed = previousModel.isPresent() ? Sets.newLinkedHashSet(previousModel.getManagedBuilders()) : Sets.newLinkedHashSet();
        ManagedModelMergingStrategy.Result<ICommand> result = ManagedModelMergingStrategy.calculate(current, model, managed);
        description.setBuildSpec(result.getNextElements().toArray(new ICommand[0]));
        project.setDescription(description, monitor);
        persistentModel.managedBuilders(result.getNextManaged());
    }

    private static Set<ICommand> toCommands(List<EclipseBuildCommand> buildCommands, IProjectDescription description) {
        LinkedHashSet commands = Sets.newLinkedHashSet();
        for (EclipseBuildCommand buildCommand : buildCommands) {
            commands.add(BuildCommandUpdater.toCommand(buildCommand.getName(), buildCommand.getArguments(), description));
        }
        commands.add(BuildCommandUpdater.toCommand("org.eclipse.buildship.core.gradleprojectbuilder", Collections.emptyMap(), description));
        return commands;
    }

    private static ICommand toCommand(String name, Map<String, String> arguments, IProjectDescription description) {
        ICommand command = description.newCommand();
        command.setBuilderName(name);
        command.setArguments(arguments);
        return command;
    }
}

