/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui.coverageview;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.eclemma.core.CoverageTools;
import org.eclipse.eclemma.internal.ui.coverageview.ViewSettings;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.jacoco.core.analysis.ICoverageNode;

class MaxTotalCache {
    private final ViewSettings settings;
    private final ITreeContentProvider contentProvider;
    private Map<IJavaElement, Integer> maxTotals;

    MaxTotalCache(ViewSettings settings) {
        this.settings = settings;
        this.contentProvider = new WorkbenchContentProvider();
        this.maxTotals = new HashMap<IJavaElement, Integer>();
    }

    int getMaxTotal(Object element) {
        IJavaElement parent = ((IJavaElement)element).getParent();
        Integer max = this.maxTotals.get(parent);
        if (max == null) {
            max = this.calculateMaxTotal(parent);
            this.maxTotals.put(parent, max);
        }
        return max;
    }

    private int calculateMaxTotal(IJavaElement parent) {
        int max = 0;
        Object[] objectArray = this.contentProvider.getChildren((Object)parent);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object sibling = objectArray[n2];
            ICoverageNode coverage = CoverageTools.getCoverageInfo((Object)sibling);
            if (coverage != null) {
                max = Math.max(max, coverage.getCounter(this.settings.getCounters()).getTotalCount());
            }
            ++n2;
        }
        return max;
    }

    void reset() {
        this.maxTotals.clear();
    }
}

