/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views;

import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.ui.views.Messages;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.FilteredCheckboxTree;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.IPreCheckStateListener;

public class ManyEntriesSelectedDialogPreCheckedListener
implements IPreCheckStateListener {
    private final FilteredCheckboxTree fFilteredCheckboxTree;

    public ManyEntriesSelectedDialogPreCheckedListener(FilteredCheckboxTree filteredCheckboxTree) {
        this.fFilteredCheckboxTree = filteredCheckboxTree;
    }

    @Override
    public boolean setSubtreeChecked(Object element, boolean state) {
        if (state) {
            ITreeContentProvider contentProvider = (ITreeContentProvider)this.fFilteredCheckboxTree.getCheckboxTreeViewer().getContentProvider();
            int nb = this.fFilteredCheckboxTree.getCheckedElements().length + this.getSubTreeSize(contentProvider, element);
            return this.showWarning(nb);
        }
        return false;
    }

    private int getSubTreeSize(ITreeContentProvider contentProvider, Object element) {
        int size = 1;
        Object[] objectArray = contentProvider.getChildren(element);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            size += this.getSubTreeSize(contentProvider, o);
            ++n2;
        }
        return size;
    }

    private boolean showWarning(int nb) {
        IPreferenceStore corePreferenceStore = Activator.getDefault().getPreferenceStore();
        boolean hide = corePreferenceStore.getBoolean("HIDE_MANY_ENTRIES_SELECTED_TOGGLE");
        if (nb > 20 && !hide) {
            MessageDialogWithToggle openOkCancelConfirm = MessageDialogWithToggle.openOkCancelConfirm((Shell)this.fFilteredCheckboxTree.getShell(), (String)Messages.ManyEntriesSelectedDialogPreCheckedListener_ManyEntriesSelectedTitle, (String)NLS.bind((String)Messages.ManyEntriesSelectedDialogPreCheckedListener_ManyEntriesSelectedMessage, (Object)nb), (String)Messages.ManyEntriesSelectedDialogPreCheckedListener_ManyEntriesSelectedDontShowAgain, (boolean)false, null, null);
            corePreferenceStore.setValue("HIDE_MANY_ENTRIES_SELECTED_TOGGLE", openOkCancelConfirm.getToggleState());
            int retCode = openOkCancelConfirm.getReturnCode();
            return retCode == 1;
        }
        return false;
    }
}

