/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.MultiSelectionAttributeEditor;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class TaskEditorPeoplePart
extends AbstractTaskEditorPart {
    private static final int COLUMN_MARGIN = 5;

    public TaskEditorPeoplePart() {
        this.setPartName(Messages.TaskEditorPeoplePart_People);
    }

    protected void addAttribute(Composite composite, FormToolkit toolkit, TaskAttribute attribute) {
        AbstractAttributeEditor editor = this.createAttributeEditor(attribute);
        if (editor != null) {
            editor.createLabelControl(composite, toolkit);
            GridDataFactory.defaultsFor((Control)editor.getLabelControl()).indent(5, 0).applyTo((Control)editor.getLabelControl());
            editor.createControl(composite, toolkit);
            this.getTaskEditorPage().getAttributeEditorToolkit().adapt(editor);
            GridDataFactory dataFactory = this.createLayoutData(editor);
            dataFactory.applyTo(editor.getControl());
        }
    }

    protected GridDataFactory createLayoutData(AbstractAttributeEditor editor) {
        GridDataFactory gridDataFactory = GridDataFactory.fillDefaults().grab(true, false).align(4, 128).indent(3, 0);
        if (editor instanceof MultiSelectionAttributeEditor) {
            gridDataFactory.hint(-1, 95);
        }
        return gridDataFactory;
    }

    @Override
    public void createControl(Composite parent, FormToolkit toolkit) {
        Section section = this.createSection(parent, toolkit, true);
        Composite peopleComposite = toolkit.createComposite((Composite)section);
        GridLayout layout = EditorUtil.createSectionClientLayout();
        layout.numColumns = 2;
        peopleComposite.setLayout((Layout)layout);
        this.createAttributeEditors(toolkit, peopleComposite);
        toolkit.paintBordersFor(peopleComposite);
        section.setClient((Control)peopleComposite);
        this.setSection(toolkit, section);
    }

    protected void createAttributeEditors(FormToolkit toolkit, Composite peopleComposite) {
        Collection<TaskAttribute> attributes = this.getAttributes();
        for (TaskAttribute attribute : attributes) {
            this.addAttribute(peopleComposite, toolkit, attribute);
        }
    }

    protected Collection<TaskAttribute> getAttributes() {
        Map allAttributes = this.getTaskData().getRoot().getAttributes();
        ArrayList<TaskAttribute> attributes = new ArrayList<TaskAttribute>(allAttributes.size());
        attributes.add(this.getTaskData().getRoot().getMappedAttribute("task.common.user.assigned"));
        attributes.add(this.getTaskData().getRoot().getMappedAttribute("task.common.user.reporter"));
        attributes.add(this.getTaskData().getRoot().getMappedAttribute("task.common.addselfcc"));
        attributes.add(this.getTaskData().getRoot().getMappedAttribute("task.common.user.cc"));
        for (TaskAttribute attribute : allAttributes.values()) {
            TaskAttributeMetaData properties = attribute.getMetaData();
            if (!"task.common.kind.people".equals(properties.getKind()) || attributes.contains(attribute)) continue;
            attributes.add(attribute);
        }
        return attributes;
    }
}

