/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.custom;

import org.eclipse.epp.internal.logging.aeri.ide.impl.ServerDescriptorImpl;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.LogMessages;
import org.eclipse.epp.logging.aeri.core.util.Logs;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CustomServerDescriptor
extends ServerDescriptorImpl {
    @Nullable
    private Image icon16;
    @Nullable
    private Image icon32;
    @Nullable
    private Image icon64;

    protected CustomServerDescriptor() {
    }

    @Override
    public synchronized Image getImage16() {
        if (this.icon16 == null) {
            this.icon16 = this.loadImage(this.getIcon16());
        }
        return this.icon16;
    }

    @Override
    public synchronized Image getImage32() {
        if (this.icon32 == null) {
            this.icon32 = this.loadImage(this.getIcon32());
        }
        return this.icon32;
    }

    private Image loadImage(String path) {
        try {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)this.getContributor(), (String)path).createImage();
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_SERVER_FAILURE, (Throwable)e, (Object[])new Object[]{this.getId(), e.getMessage()});
            return ImageDescriptor.getMissingImageDescriptor().createImage();
        }
    }

    @Override
    public boolean isActive() {
        return this.isEnabled() && this.isConfigured();
    }
}

