/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.object.struct;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.runtime.properties.ObjectPropertyDescriptor;
import org.jkiss.dbeaver.runtime.properties.PropertySourceEditable;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.internal.EditorsMessages;
import org.jkiss.dbeaver.ui.editors.object.struct.BaseObjectEditPage;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;

public class AttributeEditPage
extends BaseObjectEditPage {
    private DBSEntityAttribute attribute;
    private final DBECommandContext commandContext;
    private PropertyTreeViewer propertyViewer;

    public AttributeEditPage(@Nullable DBECommandContext commandContext, @NotNull DBSEntityAttribute attribute) {
        super(NLS.bind((String)EditorsMessages.dialog_struct_attribute_edit_page_header_edit_attribute, (Object)DBUtils.getObjectFullName((DBPNamedObject)attribute, (DBPEvaluationContext)DBPEvaluationContext.UI)));
        this.commandContext = commandContext;
        this.attribute = attribute;
    }

    @Override
    protected Control createPageContents(Composite parent) {
        Composite propsGroup = new Composite(parent, 0);
        propsGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        propsGroup.setLayoutData((Object)gd);
        Text nameText = UIUtils.createLabelText((Composite)propsGroup, (String)EditorsMessages.dialog_struct_attribute_edit_page_label_text_name, (String)this.attribute.getName());
        nameText.addModifyListener(e -> {
            if (this.attribute instanceof DBPNamedObject2) {
                ((DBPNamedObject2)this.attribute).setName(DBObjectNameCaseTransformer.transformName((DBPDataSource)this.attribute.getDataSource(), (String)nameText.getText()));
            }
        });
        UIUtils.createControlLabel((Composite)propsGroup, (String)EditorsMessages.dialog_struct_attribute_edit_page_label_text_properties).setLayoutData((Object)new GridData(2));
        this.propertyViewer = new PropertyTreeViewer(propsGroup, 2048);
        gd = new GridData(1808);
        gd.widthHint = 400;
        this.propertyViewer.getControl().setLayoutData((Object)gd);
        this.propertyViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return true;
            }
        });
        PropertySourceEditable pc = new PropertySourceEditable(this.commandContext, this.attribute, this.attribute){

            public void setPropertyValue(@Nullable DBRProgressMonitor monitor, Object editableValue, ObjectPropertyDescriptor prop, Object newValue) throws IllegalArgumentException {
                super.setPropertyValue(monitor, editableValue, prop, newValue);
            }
        };
        pc.collectProperties();
        DBPPropertyDescriptor[] dBPPropertyDescriptorArray = pc.getProperties();
        int n = dBPPropertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPPropertyDescriptor prop = dBPPropertyDescriptorArray[n2];
            if (!(prop instanceof ObjectPropertyDescriptor) || !((ObjectPropertyDescriptor)prop).isEditPossible() || ((ObjectPropertyDescriptor)prop).isNameProperty()) {
                pc.removeProperty(prop);
            }
            ++n2;
        }
        this.propertyViewer.loadProperties((DBPPropertySource)pc);
        return propsGroup;
    }

    @Override
    public void performFinish() throws DBException {
        this.propertyViewer.saveEditorValues();
    }
}

