/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.exporter;

import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.List;
import javax.imageio.ImageIO;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.exporter.StreamExporterAbstract;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;

public class DataExporterHTML
extends StreamExporterAbstract {
    private static final int IMAGE_FRAME_SIZE = 200;
    private List<DBDAttributeBinding> columns;
    private int rowCount = 0;

    @Override
    public void init(IStreamDataExporterSite site) throws DBException {
        super.init(site);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void exportHeader(DBCSession session) throws DBException, IOException {
        this.columns = this.getSite().getAttributes();
        this.printHeader();
    }

    private void printHeader() {
        PrintWriter out = this.getWriter();
        out.write("<html>");
        out.write("\t<head>\n\t<meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\">\n\t<style>table {font-family:\"Lucida Sans Unicode\", \"Lucida Grande\", Sans-Serif;font-size:12px;text-align:left;border-collapse:collapse;margin:10px;} th{font-size:14px;font-weight:normal;color:#039;padding:10px 8px;} td{color:#669;padding:8px;}.odd{background:#e8edff;}img{padding:5px; border:solid; border-color: #dddddd #aaaaaa #aaaaaa #dddddd; border-width: 1px 2px 2px 1px; background-color:white;}</style>\n</head>");
        out.write("<body><table>\n");
        out.write("<tr>");
        int i = 0;
        int columnsSize = this.columns.size();
        while (i < columnsSize) {
            String colName = this.columns.get(i).getLabel();
            if (CommonUtils.isEmpty((String)colName)) {
                colName = this.columns.get(i).getName();
            }
            this.writeTextCell(colName, true);
            ++i;
        }
        out.write("</tr>");
    }

    @Override
    public void exportRow(DBCSession session, DBCResultSet resultSet, Object[] row) throws DBException, IOException {
        PrintWriter out = this.getWriter();
        out.write("<tr" + (this.rowCount++ % 2 == 0 ? " class=\"odd\"" : "") + ">");
        int i = 0;
        while (i < row.length) {
            DBDAttributeBinding column = this.columns.get(i);
            if (DBUtils.isNullValue((Object)row[i])) {
                this.writeTextCell(null, false);
            } else if (row[i] instanceof DBDContent) {
                DBDContent content = (DBDContent)row[i];
                try {
                    DBDContentStorage cs = content.getContents(session.getProgressMonitor());
                    out.write("<td>");
                    if (cs != null) {
                        if (ContentUtils.isTextContent((DBDContent)content)) {
                            this.writeCellValue(cs.getContentReader());
                        } else {
                            this.getSite().writeBinaryData(cs);
                        }
                    }
                    out.write("</td>");
                }
                finally {
                    content.release();
                }
            } else {
                boolean isImage;
                String stringValue = super.getValueDisplayString(column, row[i]);
                boolean bl = isImage = row[i] instanceof File && stringValue != null && stringValue.endsWith(".jpg");
                if (isImage) {
                    this.writeImageCell((File)row[i]);
                } else {
                    this.writeTextCell(stringValue, false);
                }
            }
            ++i;
        }
        out.write("</tr>\n");
    }

    @Override
    public void exportFooter(DBRProgressMonitor monitor) throws IOException {
        this.getWriter().write("</table></body></html>");
    }

    private void writeTextCell(String value, boolean header) {
        PrintWriter out = this.getWriter();
        out.write(header ? "<th>" : "<td>");
        if (value == null) {
            out.write("&nbsp;");
        } else {
            value = value.replace("<", "&lt;").replace(">", "&gt;").replace("&", "&amp;");
            out.write(value);
        }
        out.write(header ? "</th>" : "</td>");
    }

    private void writeImageCell(File file) throws DBException {
        PrintWriter out = this.getWriter();
        out.write("<td>");
        if (file == null || !file.exists()) {
            out.write("&nbsp;");
        } else {
            BufferedImage image = null;
            try {
                image = ImageIO.read(file);
            }
            catch (IOException e) {
                throw new DBException("Can't read an exported image " + image, (Throwable)e);
            }
            if (image != null) {
                String imagePath = file.getAbsolutePath();
                imagePath = "files/" + imagePath.substring(imagePath.lastIndexOf(File.separator));
                int width = image.getWidth();
                int height = image.getHeight();
                int rwidth = width;
                int rheight = height;
                if (width > 200 || height > 200) {
                    float scale = 1.0f;
                    scale = width > height ? 200.0f / (float)width : 200.0f / (float)height;
                    rwidth = (int)((float)rwidth * scale);
                    rheight = (int)((float)rheight * scale);
                }
                out.write("<a href=\"" + imagePath + "\">");
                out.write("<img src=\"" + imagePath + "\" width=\"" + rwidth + "\" height=\"" + rheight + "\" />");
                out.write("</a>");
            } else {
                out.write("&nbsp;");
            }
        }
        out.write("</td>");
    }

    private void writeCellValue(Reader reader) throws IOException {
        try {
            int count;
            PrintWriter out = this.getWriter();
            char[] buffer = new char[2000];
            block3: while ((count = reader.read(buffer)) > 0) {
                int i = 0;
                while (true) {
                    if (i >= count) continue block3;
                    if (buffer[i] == '<') {
                        out.write("&lt;");
                    } else if (buffer[i] == '>') {
                        out.write("&gt;");
                    }
                    if (buffer[i] == '&') {
                        out.write("&amp;");
                    }
                    out.write(buffer[i]);
                    ++i;
                }
                break;
            }
        }
        finally {
            ContentUtils.close((Closeable)reader);
        }
    }

    public boolean saveBinariesAsImages() {
        return true;
    }
}

