/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLSourceObject;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableColumn;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableColumn;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.utils.CommonUtils;

public abstract class MySQLTableBase
extends JDBCTable<MySQLDataSource, MySQLCatalog>
implements DBPNamedObject2,
DBPRefreshableObject,
MySQLSourceObject {
    private static final Log log = Log.getLog(MySQLTableBase.class);

    protected MySQLTableBase(MySQLCatalog catalog) {
        super((DBSObjectContainer)catalog, false);
    }

    protected MySQLTableBase(DBRProgressMonitor monitor, MySQLCatalog catalog, DBSEntity source) throws DBException {
        super((DBSObjectContainer)catalog, source, false);
        DBSObjectCache colCache = ((MySQLCatalog)this.getContainer()).getTableCache().getChildrenCache(this);
        for (DBSEntityAttribute srcColumn : CommonUtils.safeCollection((Collection)source.getAttributes(monitor))) {
            if (DBUtils.isHiddenObject((Object)srcColumn)) continue;
            MySQLTableColumn column = new MySQLTableColumn(monitor, this, srcColumn);
            colCache.cacheObject((DBSObject)column);
        }
    }

    protected MySQLTableBase(MySQLCatalog catalog, ResultSet dbResult) {
        super((DBSObjectContainer)catalog, JDBCUtils.safeGetString((ResultSet)dbResult, (int)1), true);
    }

    public JDBCStructCache<MySQLCatalog, ? extends JDBCTable, ? extends JDBCTableColumn> getCache() {
        return ((MySQLCatalog)this.getContainer()).getTableCache();
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getContainer(), this});
    }

    public Collection<MySQLTableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        List childColumns = ((MySQLCatalog)this.getContainer()).tableCache.getChildren(monitor, (DBSObject)((MySQLCatalog)this.getContainer()), this);
        if (childColumns == null) {
            return Collections.emptyList();
        }
        ArrayList<MySQLTableColumn> columns = new ArrayList<MySQLTableColumn>(childColumns);
        columns.sort(DBUtils.orderComparator());
        return columns;
    }

    public MySQLTableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return (MySQLTableColumn)((MySQLCatalog)this.getContainer()).tableCache.getChild(monitor, (DBSObject)((MySQLCatalog)this.getContainer()), this, attributeName);
    }

    public List<MySQLTableColumn> getCachedAttributes() {
        DBSObjectCache childrenCache = ((MySQLCatalog)this.getContainer()).tableCache.getChildrenCache(this);
        if (childrenCache != null) {
            return childrenCache.getCachedObjects();
        }
        return Collections.emptyList();
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((MySQLCatalog)this.getContainer()).tableCache.refreshObject(monitor, (DBSObject)((MySQLCatalog)this.getContainer()), this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDDL(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (!this.isPersisted()) {
            return DBStructUtils.generateTableDDL((DBRProgressMonitor)monitor, (DBSTable)this, options, (boolean)false);
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Retrieve table DDL");
                try {
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try {
                        JDBCPreparedStatement dbStat = session.prepareStatement("SHOW CREATE " + (this.isView() ? "VIEW" : "TABLE") + " " + this.getFullyQualifiedName(DBPEvaluationContext.DDL));
                        try {
                            Throwable throwable3 = null;
                            Object var10_16 = null;
                            try {
                                String string;
                                ResultSet dbResult = dbStat.executeQuery();
                                if (dbResult.next()) {
                                    if (this.isView()) {
                                        string = dbResult.getString("Create View");
                                        break block28;
                                    } else {
                                        String string2 = dbResult.getString("Create Table");
                                        if (dbStat != null) {
                                            dbStat.close();
                                        }
                                        if (session == null) return string2;
                                        session.close();
                                        return string2;
                                    }
                                }
                                if (dbStat != null) {
                                    dbStat.close();
                                }
                                if (session == null) return "DDL is not available";
                                session.close();
                                return "DDL is not available";
                                {
                                    block28: {
                                        finally {
                                            if (dbResult == null) break block28;
                                            dbResult.close();
                                        }
                                    }
                                    if (dbStat != null) {
                                        dbStat.close();
                                    }
                                    if (session == null) return string;
                                    session.close();
                                    return string;
                                }
                            }
                            catch (Throwable throwable4) {
                                if (throwable3 == null) {
                                    throwable3 = throwable4;
                                    throw throwable3;
                                }
                                if (throwable3 == throwable4) throw throwable3;
                                throwable3.addSuppressed(throwable4);
                                throw throwable3;
                            }
                        }
                        catch (Throwable throwable5) {
                            if (dbStat == null) throw throwable5;
                            dbStat.close();
                            throw throwable5;
                        }
                    }
                    catch (Throwable throwable6) {
                        if (throwable2 == null) {
                            throwable2 = throwable6;
                            throw throwable2;
                        }
                        if (throwable2 == throwable6) throw throwable2;
                        throwable2.addSuppressed(throwable6);
                        throw throwable2;
                    }
                }
                catch (Throwable throwable7) {
                    if (session == null) throw throwable7;
                    session.close();
                    throw throwable7;
                }
            }
            catch (Throwable throwable8) {
                if (throwable == null) {
                    throwable = throwable8;
                    throw throwable;
                }
                if (throwable == throwable8) throw throwable;
                throwable.addSuppressed(throwable8);
                throw throwable;
            }
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex, this.getDataSource());
        }
    }
}

