/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.model.DB2Object;
import org.jkiss.dbeaver.ext.db2.model.DB2Package;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;

public class DB2PackageStatement
extends DB2Object<DB2Package> {
    private static final int MAX_LENGTH_TEXT = 132;
    private Integer lineNumber;
    private String text;
    private String uniqueId;
    private String version;

    public DB2PackageStatement(DB2Package db2Package, ResultSet resultSet) throws DBException {
        super(db2Package, String.valueOf(JDBCUtils.safeGetInteger((ResultSet)resultSet, (String)"SECTNO")), true);
        this.lineNumber = JDBCUtils.safeGetInteger((ResultSet)resultSet, (String)"STMTNO");
        this.text = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"TEXT");
        this.version = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"VERSION");
        try {
            this.uniqueId = new String(JDBCUtils.safeGetBytes((ResultSet)resultSet, (String)"UNIQUE_ID"), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    @Override
    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Property(viewable=true, order=2)
    public Integer getLineNumber() {
        return this.lineNumber;
    }

    @Property(viewable=true, order=3)
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Property(viewable=true, order=4)
    public String getVersion() {
        return this.version;
    }

    @Property(viewable=true, order=5)
    public String getTextPreview() {
        return this.text.substring(0, Math.min(132, this.text.length()));
    }

    @Property(viewable=false, order=6)
    public String getText() {
        return this.text;
    }
}

