/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreBackupRestoreWizard;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreBackupWizardPageObjects;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreBackupWizardPageSettings;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreDatabaseBackupInfo;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreToolScript;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.tools.AbstractToolWizard;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

class PostgreBackupWizard
extends PostgreBackupRestoreWizard<PostgreDatabaseBackupInfo>
implements IExportWizard {
    String compression;
    String encoding;
    boolean showViews;
    boolean useInserts;
    boolean noPrivileges;
    boolean noOwner;
    public List<PostgreDatabaseBackupInfo> objects = new ArrayList<PostgreDatabaseBackupInfo>();
    private PostgreBackupWizardPageObjects objectsPage;
    private PostgreBackupWizardPageSettings settingsPage;

    public PostgreBackupWizard(Collection<DBSObject> objects) {
        super(objects, PostgreMessages.wizard_backup_title);
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.outputFilePattern = store.getString("Postgre.export.outputFilePattern");
        if (CommonUtils.isEmpty((String)this.outputFilePattern)) {
            this.outputFilePattern = "dump-${database}-${timestamp}.backup";
        }
        this.showViews = CommonUtils.getBoolean((String)store.getString("Postgre.export.showViews"), (boolean)false);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.objectsPage = new PostgreBackupWizardPageObjects(this);
        this.settingsPage = new PostgreBackupWizardPageSettings(this);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.objectsPage);
        this.addPage((IWizardPage)this.settingsPage);
        super.addPages();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.settingsPage) {
            return null;
        }
        return super.getNextPage(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.logPage) {
            return this.settingsPage;
        }
        return super.getPreviousPage(page);
    }

    public void onSuccess(long workTime) {
        UIUtils.showMessageBox((Shell)this.getShell(), (String)PostgreMessages.wizard_backup_msgbox_success_title, (String)NLS.bind((String)PostgreMessages.wizard_backup_msgbox_success_description, (Object)CommonUtils.truncateString((String)this.getObjectsName(), (int)255)), (int)2);
        UIUtils.launchProgram((String)this.outputFolder.getAbsolutePath());
    }

    @Override
    public void fillProcessParameters(List<String> cmd, PostgreDatabaseBackupInfo arg) throws IOException {
        super.fillProcessParameters(cmd, arg);
        cmd.add("--format=" + this.format.getId());
        if (!CommonUtils.isEmpty((String)this.compression)) {
            cmd.add("--compress=" + this.compression);
        }
        if (!CommonUtils.isEmpty((String)this.encoding)) {
            cmd.add("--encoding=" + this.encoding);
        }
        if (this.useInserts) {
            cmd.add("--inserts");
        }
        if (this.noPrivileges) {
            cmd.add("--no-privileges");
        }
        if (this.noOwner) {
            cmd.add("--no-owner");
        }
        if (!this.objects.isEmpty() && !CommonUtils.isEmpty(arg.getTables())) {
            for (PostgreTableBase table : arg.getTables()) {
                cmd.add("-t");
                cmd.add(table.getFullyQualifiedName(DBPEvaluationContext.DDL));
            }
        }
        if (!CommonUtils.isEmpty(arg.getSchemas())) {
            for (PostgreSchema schema : arg.getSchemas()) {
                cmd.add("-n");
                cmd.add(DBUtils.getQuotedIdentifier((DBSObject)schema));
            }
        }
    }

    @Override
    protected List<String> getCommandLine(PostgreDatabaseBackupInfo arg) throws IOException {
        List<String> cmd = PostgreToolScript.getPostgreToolCommandLine(this, arg);
        cmd.add(arg.getDatabase().getName());
        return cmd;
    }

    public boolean performFinish() {
        this.objectsPage.saveState();
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.setValue("Postgre.export.outputFilePattern", this.outputFilePattern);
        store.setValue("Postgre.export.showViews", this.showViews);
        return super.performFinish();
    }

    public Collection<PostgreDatabaseBackupInfo> getRunInfo() {
        return this.objects;
    }

    protected void startProcessHandler(DBRProgressMonitor monitor, PostgreDatabaseBackupInfo arg, ProcessBuilder processBuilder, Process process) {
        super.startProcessHandler(monitor, (Object)arg, processBuilder, process);
        String outFileName = GeneralUtils.replaceVariables((String)this.outputFilePattern, name -> {
            switch (name) {
                case "database": {
                    return arg.getDatabase().getName();
                }
                case "host": {
                    return arg.getDatabase().getDataSource().getContainer().getConnectionConfiguration().getHostName();
                }
                case "table": {
                    Iterator<PostgreTableBase> iterator;
                    Iterator<PostgreTableBase> iterator2 = iterator = arg.getTables() == null ? null : arg.getTables().iterator();
                    if (iterator != null && iterator.hasNext()) {
                        return iterator.next().getName();
                    }
                    return "null";
                }
                case "timestamp": {
                    return RuntimeUtils.getCurrentTimeStamp();
                }
                case "date": {
                    return RuntimeUtils.getCurrentDate();
                }
            }
            System.getProperty(name);
            return null;
        });
        File outFile = new File(this.outputFolder, outFileName);
        AbstractToolWizard.DumpCopierJob job = new AbstractToolWizard.DumpCopierJob((AbstractToolWizard)this, monitor, "Export database", process.getInputStream(), outFile);
        job.start();
    }
}

