/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager;

import com.oracle.tools.packager.Log;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class RelativeFileSet {
    private Type type = Type.UNKNOWN;
    private String mode;
    private String os;
    private String arch;
    private File basedir;
    Set<String> files = new LinkedHashSet<String>();

    public RelativeFileSet(RelativeFileSet copy) {
        this.type = copy.type;
        this.mode = copy.mode;
        this.os = copy.os;
        this.arch = copy.arch;
        this.basedir = copy.basedir;
        this.files = new LinkedHashSet<String>(copy.files);
    }

    public RelativeFileSet(File base, Collection<File> files) {
        this.basedir = base;
        String baseAbsolute = this.basedir.getAbsolutePath();
        for (File f : files) {
            String absolute = f.getAbsolutePath();
            if (!absolute.startsWith(baseAbsolute)) {
                throw new RuntimeException("File " + f.getAbsolutePath() + " does not belong to " + baseAbsolute);
            }
            if (absolute.equals(baseAbsolute)) continue;
            this.files.add(absolute.substring(baseAbsolute.length() + 1));
        }
    }

    public void upshift() {
        String root = this.basedir.getName();
        this.basedir = this.basedir.getParentFile();
        LinkedHashSet<String> newFiles = new LinkedHashSet<String>();
        for (String s : this.files) {
            newFiles.add(root + File.separator + s);
        }
        this.files = newFiles;
    }

    public RelativeFileSet(File base, Set<File> files) {
        this(base, (Collection<File>)files);
    }

    public boolean contains(String[] requiredFiles) {
        boolean result = true;
        for (String fname : requiredFiles) {
            if (this.files.contains(fname)) continue;
            Log.debug("  Runtime does not contain [" + fname + "]");
            result = false;
        }
        return result;
    }

    public boolean contains(String requiredFile) {
        if (this.files.contains(requiredFile)) {
            return true;
        }
        Log.debug("  Runtime does not contain [" + requiredFile + "]");
        return false;
    }

    public File getBaseDirectory() {
        return this.basedir;
    }

    public Set<String> getIncludedFiles() {
        return this.files;
    }

    public void dump() {
        Log.verbose("\n=========\nBasedir: " + this.basedir + "\n");
        for (String fname : this.files) {
            Log.verbose("  " + fname);
        }
        Log.verbose("\n========");
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getOs() {
        return this.os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public String getArch() {
        return this.arch;
    }

    public void setArch(String arch) {
        this.arch = arch;
    }

    public String toString() {
        return "RelativeFileSet{basedir:" + this.basedir + ", files:" + this.files + "}";
    }

    public static enum Type {
        UNKNOWN,
        jnlp,
        jar,
        nativelib,
        icon,
        license,
        data;

    }
}

