/*
 * Decompiled with CFR 0.152.
 */
package javafx.geometry;

import javafx.beans.NamedArg;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;

public class BoundingBox
extends Bounds {
    private int hash = 0;

    public BoundingBox(@NamedArg(value="minX") double minX, @NamedArg(value="minY") double minY, @NamedArg(value="minZ") double minZ, @NamedArg(value="width") double width, @NamedArg(value="height") double height, @NamedArg(value="depth") double depth) {
        super(minX, minY, minZ, width, height, depth);
    }

    public BoundingBox(@NamedArg(value="minX") double minX, @NamedArg(value="minY") double minY, @NamedArg(value="width") double width, @NamedArg(value="height") double height) {
        super(minX, minY, 0.0, width, height, 0.0);
    }

    @Override
    public boolean isEmpty() {
        return this.getMaxX() < this.getMinX() || this.getMaxY() < this.getMinY() || this.getMaxZ() < this.getMinZ();
    }

    @Override
    public boolean contains(Point2D p) {
        if (p == null) {
            return false;
        }
        return this.contains(p.getX(), p.getY(), 0.0);
    }

    @Override
    public boolean contains(Point3D p) {
        if (p == null) {
            return false;
        }
        return this.contains(p.getX(), p.getY(), p.getZ());
    }

    @Override
    public boolean contains(double x, double y) {
        return this.contains(x, y, 0.0);
    }

    @Override
    public boolean contains(double x, double y, double z) {
        if (this.isEmpty()) {
            return false;
        }
        return x >= this.getMinX() && x <= this.getMaxX() && y >= this.getMinY() && y <= this.getMaxY() && z >= this.getMinZ() && z <= this.getMaxZ();
    }

    @Override
    public boolean contains(Bounds b) {
        if (b == null || b.isEmpty()) {
            return false;
        }
        return this.contains(b.getMinX(), b.getMinY(), b.getMinZ(), b.getWidth(), b.getHeight(), b.getDepth());
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.contains(x, y) && this.contains(x + w, y + h);
    }

    @Override
    public boolean contains(double x, double y, double z, double w, double h, double d) {
        return this.contains(x, y, z) && this.contains(x + w, y + h, z + d);
    }

    @Override
    public boolean intersects(Bounds b) {
        if (b == null || b.isEmpty()) {
            return false;
        }
        return this.intersects(b.getMinX(), b.getMinY(), b.getMinZ(), b.getWidth(), b.getHeight(), b.getDepth());
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.intersects(x, y, 0.0, w, h, 0.0);
    }

    @Override
    public boolean intersects(double x, double y, double z, double w, double h, double d) {
        if (this.isEmpty() || w < 0.0 || h < 0.0 || d < 0.0) {
            return false;
        }
        return x + w >= this.getMinX() && y + h >= this.getMinY() && z + d >= this.getMinZ() && x <= this.getMaxX() && y <= this.getMaxY() && z <= this.getMaxZ();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BoundingBox) {
            BoundingBox other = (BoundingBox)obj;
            return this.getMinX() == other.getMinX() && this.getMinY() == other.getMinY() && this.getMinZ() == other.getMinZ() && this.getWidth() == other.getWidth() && this.getHeight() == other.getHeight() && this.getDepth() == other.getDepth();
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            long bits = 7L;
            bits = 31L * bits + Double.doubleToLongBits(this.getMinX());
            bits = 31L * bits + Double.doubleToLongBits(this.getMinY());
            bits = 31L * bits + Double.doubleToLongBits(this.getMinZ());
            bits = 31L * bits + Double.doubleToLongBits(this.getWidth());
            bits = 31L * bits + Double.doubleToLongBits(this.getHeight());
            bits = 31L * bits + Double.doubleToLongBits(this.getDepth());
            this.hash = (int)(bits ^ bits >> 32);
        }
        return this.hash;
    }

    public String toString() {
        return "BoundingBox [minX:" + this.getMinX() + ", minY:" + this.getMinY() + ", minZ:" + this.getMinZ() + ", width:" + this.getWidth() + ", height:" + this.getHeight() + ", depth:" + this.getDepth() + ", maxX:" + this.getMaxX() + ", maxY:" + this.getMaxY() + ", maxZ:" + this.getMaxZ() + "]";
    }
}

