/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.sw;

import com.sun.prism.MediaFrame;
import com.sun.prism.PixelFormat;
import com.sun.prism.Texture;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.sw.SWResourceFactory;
import com.sun.prism.sw.SWTexture;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class SWMaskTexture
extends SWTexture {
    private byte[] data;

    SWMaskTexture(SWResourceFactory factory, Texture.WrapMode wrapMode, int w, int h) {
        super(factory, wrapMode, w, h);
    }

    SWMaskTexture(SWMaskTexture sharedTex, Texture.WrapMode altMode) {
        super(sharedTex, altMode);
        this.data = sharedTex.data;
    }

    byte[] getDataNoClone() {
        return this.data;
    }

    @Override
    public PixelFormat getPixelFormat() {
        return PixelFormat.BYTE_ALPHA;
    }

    @Override
    public void update(Buffer buffer, PixelFormat format, int dstx, int dsty, int srcx, int srcy, int srcw, int srch, int srcscan, boolean skipFlush) {
        if (PrismSettings.debug) {
            System.out.println("MASK TEXTURE, Pixel format: " + (Object)((Object)format) + ", buffer: " + buffer);
            System.out.println("dstx:" + dstx + " dsty:" + dsty);
            System.out.println("srcx:" + srcx + " srcy:" + srcy + " srcw:" + srcw + " srch:" + srch + " srcscan: " + srcscan);
        }
        if (format != PixelFormat.BYTE_ALPHA) {
            throw new IllegalArgumentException("SWMaskTexture supports BYTE_ALPHA format only.");
        }
        this.checkAllocation(srcw, srch);
        this.physicalWidth = srcw;
        this.physicalHeight = srch;
        this.allocate();
        ByteBuffer bb = (ByteBuffer)buffer;
        for (int i = 0; i < srch; ++i) {
            bb.position((srcy + i) * srcscan + srcx);
            bb.get(this.data, i * this.physicalWidth, srcw);
        }
    }

    @Override
    public void update(MediaFrame frame, boolean skipFlush) {
        throw new UnsupportedOperationException("update6:unimp");
    }

    void checkAllocation(int srcw, int srch) {
        int nlen;
        if (this.allocated && (nlen = srcw * srch) > this.data.length) {
            throw new IllegalArgumentException("SRCW * SRCH exceeds buffer length");
        }
    }

    @Override
    void allocateBuffer() {
        this.data = new byte[this.physicalWidth * this.physicalHeight];
    }

    @Override
    Texture createSharedLockedTexture(Texture.WrapMode altMode) {
        return new SWMaskTexture(this, altMode);
    }
}

