/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.prism;

import com.sun.prism.BasicStroke;
import com.sun.prism.Graphics;
import com.sun.prism.paint.Paint;
import com.sun.webkit.graphics.WCStroke;

final class WCStrokeImpl
extends WCStroke<Paint, BasicStroke> {
    private BasicStroke stroke;

    public WCStrokeImpl() {
    }

    public WCStrokeImpl(float width, int cap, int join, float miterLimit, float[] dash, float dashOffset) {
        this.setThickness(width);
        this.setLineCap(cap);
        this.setLineJoin(join);
        this.setMiterLimit(miterLimit);
        this.setDashSizes(dash);
        this.setDashOffset(dashOffset);
    }

    @Override
    protected void invalidate() {
        this.stroke = null;
    }

    @Override
    public BasicStroke getPlatformStroke() {
        int style;
        if (this.stroke == null && (style = this.getStyle()) != 0) {
            float width = this.getThickness();
            float[] dash = this.getDashSizes();
            if (dash == null) {
                switch (style) {
                    case 2: {
                        dash = new float[]{width, width};
                        break;
                    }
                    case 3: {
                        dash = new float[]{3.0f * width, 3.0f * width};
                    }
                }
            }
            this.stroke = new BasicStroke(width, this.getLineCap(), this.getLineJoin(), this.getMiterLimit(), dash, this.getDashOffset());
        }
        return this.stroke;
    }

    boolean isApplicable() {
        return this.getPaint() != null && this.getPlatformStroke() != null;
    }

    boolean apply(Graphics graphics) {
        if (this.isApplicable()) {
            Paint _paint = (Paint)this.getPaint();
            BasicStroke _stroke = this.getPlatformStroke();
            graphics.setPaint(_paint);
            graphics.setStroke(_stroke);
            return true;
        }
        return false;
    }
}

