/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.font.CharToGlyphMapper;
import com.sun.javafx.font.CompositeFontResource;
import java.util.HashMap;

public class CompositeGlyphMapper
extends CharToGlyphMapper {
    public static final int SLOTMASK = -16777216;
    public static final int GLYPHMASK = 0xFFFFFF;
    public static final int NBLOCKS = 216;
    public static final int BLOCKSZ = 256;
    public static final int MAXUNICODE = 55296;
    private static final int SIMPLE_ASCII_MASK_START = 32;
    private static final int SIMPLE_ASCII_MASK_END = 126;
    private static final int ASCII_COUNT = 95;
    private boolean asciiCacheOK;
    private char[] charToGlyph;
    CompositeFontResource font;
    CharToGlyphMapper[] slotMappers;
    HashMap<Integer, Integer> glyphMap;

    public CompositeGlyphMapper(CompositeFontResource compFont) {
        this.font = compFont;
        this.missingGlyph = 0;
        this.glyphMap = new HashMap();
        this.slotMappers = new CharToGlyphMapper[compFont.getNumSlots()];
        this.asciiCacheOK = true;
    }

    private final CharToGlyphMapper getSlotMapper(int slot) {
        CharToGlyphMapper mapper;
        if (slot >= this.slotMappers.length) {
            CharToGlyphMapper[] tmp = new CharToGlyphMapper[this.font.getNumSlots()];
            System.arraycopy(this.slotMappers, 0, tmp, 0, this.slotMappers.length);
            this.slotMappers = tmp;
        }
        if ((mapper = this.slotMappers[slot]) == null) {
            this.slotMappers[slot] = mapper = this.font.getSlotResource(slot).getGlyphMapper();
        }
        return mapper;
    }

    @Override
    public int getMissingGlyphCode() {
        return this.missingGlyph;
    }

    public final int compositeGlyphCode(int slot, int glyphCode) {
        return slot << 24 | glyphCode & 0xFFFFFF;
    }

    private final int convertToGlyph(int unicode) {
        for (int slot = 0; slot < this.font.getNumSlots(); ++slot) {
            CharToGlyphMapper mapper = this.getSlotMapper(slot);
            int glyphCode = mapper.charToGlyph(unicode);
            if (glyphCode == mapper.getMissingGlyphCode()) continue;
            glyphCode = this.compositeGlyphCode(slot, glyphCode);
            this.glyphMap.put(unicode, glyphCode);
            return glyphCode;
        }
        this.glyphMap.put(unicode, this.missingGlyph);
        return this.missingGlyph;
    }

    private int getAsciiGlyphCode(int charCode) {
        if (!this.asciiCacheOK || charCode > 126 || charCode < 32) {
            return -1;
        }
        if (this.charToGlyph == null) {
            char[] glyphCodes = new char[95];
            CharToGlyphMapper mapper = this.getSlotMapper(0);
            int missingGlyphCode = mapper.getMissingGlyphCode();
            for (int i = 0; i < 95; ++i) {
                int glyphCode = mapper.charToGlyph(32 + i);
                if (glyphCode == missingGlyphCode) {
                    this.charToGlyph = null;
                    this.asciiCacheOK = false;
                    return -1;
                }
                glyphCodes[i] = (char)glyphCode;
            }
            this.charToGlyph = glyphCodes;
        }
        int index = charCode - 32;
        return this.charToGlyph[index];
    }

    @Override
    public int getGlyphCode(int charCode) {
        int retVal = this.getAsciiGlyphCode(charCode);
        if (retVal >= 0) {
            return retVal;
        }
        Integer codeInt = this.glyphMap.get(charCode);
        if (codeInt != null) {
            return codeInt;
        }
        return this.convertToGlyph(charCode);
    }
}

