/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.binding;

import com.sun.javafx.binding.StringConstant;
import java.util.ArrayList;
import java.util.Locale;
import javafx.beans.binding.StringBinding;
import javafx.beans.binding.StringExpression;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public abstract class StringFormatter
extends StringBinding {
    private static Object extractValue(Object obj) {
        return obj instanceof ObservableValue ? ((ObservableValue)obj).getValue() : obj;
    }

    private static Object[] extractValues(Object[] objs) {
        int n = objs.length;
        Object[] values = new Object[n];
        for (int i = 0; i < n; ++i) {
            values[i] = StringFormatter.extractValue(objs[i]);
        }
        return values;
    }

    private static ObservableValue<?>[] extractDependencies(Object ... args) {
        ArrayList<ObservableValue> dependencies = new ArrayList<ObservableValue>();
        for (Object obj : args) {
            if (!(obj instanceof ObservableValue)) continue;
            dependencies.add((ObservableValue)obj);
        }
        return dependencies.toArray(new ObservableValue[dependencies.size()]);
    }

    public static StringExpression convert(final ObservableValue<?> observableValue) {
        if (observableValue == null) {
            throw new NullPointerException("ObservableValue must be specified");
        }
        if (observableValue instanceof StringExpression) {
            return (StringExpression)observableValue;
        }
        return new StringBinding(){
            {
                super.bind(observableValue);
            }

            @Override
            public void dispose() {
                super.unbind(observableValue);
            }

            @Override
            protected String computeValue() {
                Object value = observableValue.getValue();
                return value == null ? "null" : value.toString();
            }

            @Override
            public ObservableList<ObservableValue<?>> getDependencies() {
                return FXCollections.singletonObservableList(observableValue);
            }
        };
    }

    public static StringExpression concat(final Object ... args) {
        if (args == null || args.length == 0) {
            return StringConstant.valueOf("");
        }
        if (args.length == 1) {
            Object cur = args[0];
            return cur instanceof ObservableValue ? StringFormatter.convert((ObservableValue)cur) : StringConstant.valueOf(cur.toString());
        }
        if (StringFormatter.extractDependencies(args).length == 0) {
            StringBuilder builder = new StringBuilder();
            for (Object obj : args) {
                builder.append(obj);
            }
            return StringConstant.valueOf(builder.toString());
        }
        return new StringFormatter(){
            {
                super.bind(StringFormatter.extractDependencies(args));
            }

            @Override
            public void dispose() {
                super.unbind(StringFormatter.extractDependencies(args));
            }

            @Override
            protected String computeValue() {
                StringBuilder builder = new StringBuilder();
                for (Object obj : args) {
                    builder.append(StringFormatter.extractValue(obj));
                }
                return builder.toString();
            }

            @Override
            public ObservableList<ObservableValue<?>> getDependencies() {
                return FXCollections.unmodifiableObservableList(FXCollections.observableArrayList(StringFormatter.extractDependencies(args)));
            }
        };
    }

    public static StringExpression format(final Locale locale, final String format, final Object ... args) {
        if (format == null) {
            throw new NullPointerException("Format cannot be null.");
        }
        if (StringFormatter.extractDependencies(args).length == 0) {
            return StringConstant.valueOf(String.format(locale, format, args));
        }
        StringFormatter formatter = new StringFormatter(){
            {
                super.bind(StringFormatter.extractDependencies(args));
            }

            @Override
            public void dispose() {
                super.unbind(StringFormatter.extractDependencies(args));
            }

            @Override
            protected String computeValue() {
                Object[] values = StringFormatter.extractValues(args);
                return String.format(locale, format, values);
            }

            @Override
            public ObservableList<ObservableValue<?>> getDependencies() {
                return FXCollections.unmodifiableObservableList(FXCollections.observableArrayList(StringFormatter.extractDependencies(args)));
            }
        };
        formatter.get();
        return formatter;
    }

    public static StringExpression format(final String format, final Object ... args) {
        if (format == null) {
            throw new NullPointerException("Format cannot be null.");
        }
        if (StringFormatter.extractDependencies(args).length == 0) {
            return StringConstant.valueOf(String.format(format, args));
        }
        StringFormatter formatter = new StringFormatter(){
            {
                super.bind(StringFormatter.extractDependencies(args));
            }

            @Override
            public void dispose() {
                super.unbind(StringFormatter.extractDependencies(args));
            }

            @Override
            protected String computeValue() {
                Object[] values = StringFormatter.extractValues(args);
                return String.format(format, values);
            }

            @Override
            public ObservableList<ObservableValue<?>> getDependencies() {
                return FXCollections.unmodifiableObservableList(FXCollections.observableArrayList(StringFormatter.extractDependencies(args)));
            }
        };
        formatter.get();
        return formatter;
    }
}

