/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_dsb extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Srjej\u017aoafriski cas",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Moskowski standardny cas",
               "MSK",
               "Moskowski l\u011b\u015bojski cas",
               "MSD",
               "Moskowski cas",
               "MT",
            };
        final String[] Japan = new String[] {
               "Japa\u0144ski standardny cas",
               "JST",
               "Japa\u0144ski l\u011b\u015bojski cas",
               "JDT",
               "Japa\u0144ski cas",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Pakista\u0144ski standardny cas",
               "PKT",
               "Pakista\u0144ski l\u011b\u015bojski cas",
               "PKST",
               "Pakista\u0144ski cas",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Tchajpejski standardny cas",
               "CST",
               "Tchajpejski l\u011b\u015bojski cas",
               "CDT",
               "Tchajpejski cas",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Chowdski standardny cas",
               "HOVT",
               "Chowdski l\u011b\u015bojski cas",
               "HOVST",
               "Chowdski cas",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Magada\u0144ski standardny cas",
               "MAGT",
               "Magada\u0144ski l\u011b\u015bojski cas",
               "MAGST",
               "Magada\u0144ski cas",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Srjej\u017aop\u00f3dwjacorny awstralski standardny cas",
               "ACWST",
               "Srjej\u017aop\u00f3dwjacorny awstralski l\u011b\u015bojski cas",
               "ACWDT",
               "Srjej\u017aop\u00f3dwjacorny awstralski cas",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Srjej\u017aoeuropski standardny cas",
               "MEZ",
               "Srjej\u017aoeuropski l\u011b\u015bojski cas",
               "MESZ",
               "Srjej\u017aoeuropski cas",
               "MEZ",
            };
        final String[] Sakhalin = new String[] {
               "Sachalinski standardny cas",
               "SAKT",
               "Sachalinski l\u011b\u015bojski cas",
               "SAKST",
               "Sachalinski cas",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguayski standardny cas",
               "PYT",
               "Paraguayski l\u011b\u015bojski cas",
               "PYST",
               "Paraguayski cas",
               "PYT",
            };
        final String[] Malaysia = new String[] {
               "Malajziski cas",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "P\u00f3dpo\u0142nocnoameriski p\u00f3dzajt\u0161ny standardny cas",
               "EST",
               "P\u00f3dpo\u0142nocnoameriski p\u00f3dzajt\u0161ny l\u011b\u015bojski cas",
               "EDT",
               "P\u00f3dpo\u0142nocnoameriski p\u00f3dzajt\u0161ny cas",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Standardny cas kupy Lord-Howe",
               "LHST",
               "l\u011b\u015bojski cas kupy Lord-Howe",
               "LHDT",
               "cas kupy Lord-Howe",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Nowoseelandski standardny cas",
               "NZST",
               "Nowoseelandski l\u011b\u015bojski cas",
               "NZDT",
               "Nowoseelandski cas",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Indiskooceaniski cas",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Jakutski standardny cas",
               "YAKT",
               "Jakutski l\u011b\u015bojski cas",
               "YAKST",
               "Jakutski cas",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "Mauriciski standardny cas",
               "MUT",
               "Mauriciski l\u011b\u015bojski cas",
               "MUST",
               "Mauriciski cas",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "P\u00f3dzajt\u0161noafriski cas",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "P\u00f3dzajt\u0161notimorski cas",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "Salomo\u0144ski cas",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "Kosraeski cas",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "cas Marshallowych kupow",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "P\u00f3dzajt\u0161noeuropski standardny cas",
               "OEZ",
               "P\u00f3dzajt\u0161noeuropski l\u011b\u015bojski cas",
               "OESZ",
               "P\u00f3dzajt\u0161noeuropski cas",
               "OEZ",
            };
        final String[] Newfoundland = new String[] {
               "Nowofundlandski standardny cas",
               "NST",
               "Nowofundlandski l\u011b\u015bojski cas",
               "NDT",
               "Nowofundlandski cas",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Afghaniski cas",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Hongkongski standardny cas",
               "HKT",
               "Hongkongski l\u011b\u015bojski cas",
               "HKST",
               "Hongkongski cas",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "P\u00f3dwjacornoargentinski standardny cas",
               "ART",
               "P\u00f3dwjacornoargentinski l\u011b\u015bojski cas",
               "ARST",
               "P\u00f3dwjacornoargentinski cas",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "Atlantiski standardny cas",
               "AST",
               "Atlantiski l\u011b\u015bojski cas",
               "ADT",
               "Atlantiski cas",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Ponapski cas",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "Boliwiski cas",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "St.-Pierre-a-Miquelo\u0144ski standardny cas",
               "PMST",
               "St.-Pierre-a-Miquelo\u0144ski l\u011b\u015bojski cas",
               "PMDT",
               "St.-Pierre-a-Miquelo\u0144ski cas",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Indochinski cas",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburgski standardny cas",
               "YEKT",
               "Jekaterinburgski l\u011b\u015bojski cas",
               "YEKST",
               "Jekaterinburgski cas",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "Malediwski cas",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Tahitiski cas",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "Israelski standardny cas",
               "IST",
               "Israelski l\u011b\u015bojski cas",
               "IDT",
               "Israelski cas",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Srjej\u017aoindoneski cas",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "cas kupow Wallis a Futuna",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "P\u00f3dpo\u0142dnjowoafriski cas",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Syowa cas",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "cas Linijowych kupow",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "Uzbekiski standardny cas",
               "UZT",
               "Uzbekiski l\u011b\u015bojski cas",
               "UZST",
               "Uzbekiski cas",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Omski standardny cas",
               "OMST",
               "Omski l\u011b\u015bojski cas",
               "OMSST",
               "Omski cas",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Seychelski cas",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Uruguayski standardny cas",
               "UYT",
               "Uruguayski l\u011b\u015bojski cas",
               "UYST",
               "Uruguayski cas",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "Nepalski cas",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Ulan-Batorski standardny cas",
               "ULAT",
               "Ulan-Batorski l\u011b\u015bojski cas",
               "ULAST",
               "Ulan-Batorski cas",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "P\u00f3dpo\u0142nocnoameriski centralny standardny cas",
               "CST",
               "P\u00f3dpo\u0142nocnoameriski centralny l\u011b\u015bojski cas",
               "CDT",
               "P\u00f3dpo\u0142nocnoameriski centralny cas",
               "CT",
            };
        final String[] Truk = new String[] {
               "Chuukski cas",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "Niueski cas",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "cas kupy Wake",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Falklandski standardny cas",
               "FKT",
               "Falklandski l\u011b\u015bojski cas",
               "FKST",
               "Falklandski cas",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatski standardny cas",
               "VUT",
               "Vanuatski l\u011b\u015bojski cas",
               "VUST",
               "Vanuatski cas",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Nowosibirski standardny cas",
               "NOVT",
               "Nowosibirski l\u011b\u015bojski cas",
               "NOVST",
               "Nowosibirski cas",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Singapurski cas",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Acorski standardny cas",
               "AZOT",
               "Acorski l\u011b\u015bojski cas",
               "AZOST",
               "Acorski cas",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Apiaski standardny cas",
               "WSST",
               "Apiaski l\u011b\u015bojski cas",
               "WSDT",
               "Apiaski cas",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "Bhuta\u0144ski cas",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "Surinamski cas",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "Nauruski cas",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarski standardny cas",
               "KRAT",
               "Krasnojarski l\u011b\u015bojski cas",
               "KRAST",
               "Krasnojarski cas",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "P\u00f3dwjacornokazachski cas",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "Myanmarski cas",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "cas G\u00f3downych kupow",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Amaconaski standardny cas",
               "AMT",
               "Amaconaski l\u011b\u015bojski cas",
               "AMST",
               "Amaconaski cas",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "P\u00f3dzajt\u0161nokazachski cas",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Fid\u017aiski standardny cas",
               "FJT",
               "Fid\u017aiski l\u011b\u015bojski cas",
               "FJST",
               "Fid\u017aiski cas",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "Reunionski cas",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "cas Kokosowych kupow",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "Chathamski standardny cas",
               "CHAST",
               "Chathamski l\u011b\u015bojski cas",
               "CHADT",
               "Chathamski cas",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "cas Wostok",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Argentinski standardny cas",
               "ART",
               "Argentinski l\u011b\u015bojski cas",
               "ARST",
               "Argentinski cas",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Gambierski cas",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalski cas",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "Galapagoski cas",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "cas kupy Macquarie",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "Venezuelski cas",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaiisko-aleutski standardny cas",
               "HAST",
               "Hawaiisko-aleutski l\u011b\u015bojski cas",
               "HADT",
               "Hawaiisko-aleutski cas",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Srjej\u017aoawstralski standardny cas",
               "ACST",
               "Srjej\u017aoawstralski l\u011b\u015bojski cas",
               "ACDT",
               "Srjej\u017aoawstralski cas",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "P\u00f3dpo\u0142nocnoameriski pacifiski standardny cas",
               "PST",
               "P\u00f3dpo\u0142nocnoameriski pacifiski l\u011b\u015bojski cas",
               "PDT",
               "P\u00f3dpo\u0142nocnoameriski pacifiski cas",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "cas Phoenixowych kupow",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmeniski standardny cas",
               "TMT",
               "Turkmeniski l\u011b\u015bojski cas",
               "TMST",
               "Turkmeniski cas",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "P\u00f3dwjacornoeuropski standardny cas",
               "WEZ",
               "P\u00f3dwjacornoeuropski l\u011b\u015bojski cas",
               "WESZ",
               "P\u00f3dwjacornoeuropski cas",
               "WEZ",
            };
        final String[] Cape_Verde = new String[] {
               "Kapverdski standardny cas",
               "CVT",
               "Kapverdski l\u011b\u015bojski cas",
               "CVST",
               "Kapverdski cas",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "cas kupy Norfolk",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "Guya\u0144ski cas",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "cas Pitcairnowych kupow",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "cas Rothera",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Samoaski standardny cas",
               "SST",
               "Samoaski l\u011b\u015bojski cas",
               "SDT",
               "Samoaski cas",
               "ST",
            };
        final String[] Palau = new String[] {
               "Palauski cas",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "Kaliningradski cas",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbajd\u017eaniski standardny cas",
               "AZT",
               "Azerbajd\u017eaniski l\u011b\u015bojski cas",
               "AZST",
               "Azerbajd\u017eaniski cas",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Mawson cas",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Mexiski pacifiski standardny cas",
               "MST",
               "Mexiski pacifiski l\u011b\u015bojski cas",
               "MDT",
               "Mexiski pacifiski cas",
               "MT",
            };
        final String[] Davis = new String[] {
               "Davis cas",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "Kuba\u0144ski standardny cas",
               "CST",
               "Kuba\u0144ski l\u011b\u015bojski cas",
               "CDT",
               "Kuba\u0144ski cas",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "P\u00f3dwjacornoafriski standardny cas",
               "CAT",
               "P\u00f3dwjacornoafriski l\u011b\u015bojski cas",
               "CAST",
               "P\u00f3dwjacornoafriski cas",
               "CAT",
            };
        final String[] GMT = new String[] {
               "Greenwichski cas",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Filipinski standardny cas",
               "PHT",
               "Filipinski l\u011b\u015bojski cas",
               "PHST",
               "Filipinski cas",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "cas francojskego p\u00f3dpo\u0142dnjowego a antarktiskeho teritoriuma",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "P\u00f3dpo\u0142dnjowogeorgiski cas",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "Nowokaledoniski standardny cas",
               "NCT",
               "Nowokaledoniski l\u011b\u015bojski cas",
               "NCST",
               "Nowokaledoniski cas",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Bruneiski cas",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "Ira\u0144ski standardny cas",
               "IRST",
               "Ira\u0144ski l\u011b\u015bojski cas",
               "IRDT",
               "Ira\u0144ski cas",
               "IRT",
            };
        final String[] Easter = new String[] {
               "standardny cas Jat\u0161owneje kupy",
               "EAST",
               "l\u011b\u015bojski cas Jat\u0161owneje kupy",
               "EASST",
               "cas Jat\u0161owneje kupy",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "Mexiski d\u0142ujkowjacorny standardny cas",
               "PST",
               "Mexiski d\u0142ujkowjacorny l\u011b\u015bojski cas",
               "PDT",
               "Mexiski d\u0142ujkowjacorny cas",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "DumontDUrville cas",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "Tad\u017aikiski cas",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Tongaski standardny cas",
               "TOT",
               "Tongaski l\u011b\u015bojski cas",
               "TOST",
               "Tongaski cas",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Banglade\u0161ski standardny cas",
               "BDT",
               "Banglade\u0161ski l\u011b\u015bojski cas",
               "BDST",
               "Banglade\u0161ski cas",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Peruski standardny cas",
               "PET",
               "Peruski l\u011b\u015bojski cas",
               "PEST",
               "Peruski cas",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "P\u00f3dwjacornogr\u00f6nlandski standardny cas",
               "WGT",
               "P\u00f3dwjacornogr\u00f6nlandski l\u011b\u015bojski cas",
               "WGST",
               "P\u00f3dwjacornogr\u00f6nlandski cas",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Ekuadorski cas",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "P\u00f3dzajt\u0161nogr\u00f6nlandski standardny cas",
               "EGT",
               "P\u00f3dzajt\u0161nogr\u00f6nlandski l\u011b\u015bojski cas",
               "EGST",
               "P\u00f3dzajt\u0161nogr\u00f6nlandski cas",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "cas Persiskego golfa",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "P\u00f3dzajt\u0161noindoneski",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Korejski standardny cas",
               "KST",
               "Korejski l\u011b\u015bojski cas",
               "KDT",
               "Korejski cas",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "P\u00f3dwjacornoawstralski standardny cas",
               "AWST",
               "P\u00f3dwjacornoawstralski l\u011b\u015bojski cas",
               "AWDT",
               "P\u00f3dwjacornoawstralski cas",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgiski cas",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "P\u00f3dwjacornoindoneski cas",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "P\u00f3dzajt\u0161noawstralski standardny cas",
               "AEST",
               "P\u00f3dzajt\u0161noawstralski l\u011b\u015bojski cas",
               "AEDT",
               "P\u00f3dzajt\u0161noawstralski cas",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "Francojskoguya\u0144ski cas",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Kolumbiski standardny cas",
               "COT",
               "Kolumbiski l\u011b\u015bojski cas",
               "COST",
               "Kolumbiski cas",
               "COT",
            };
        final String[] Chile = new String[] {
               "Chilski standardny cas",
               "CLT",
               "Chilski l\u011b\u015bojski cas",
               "CLST",
               "Chilski cas",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "cas Gilbertowych kupow",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "P\u00f3dpo\u0142nocnoameriski g\u00f3rski standardny cas",
               "MST",
               "P\u00f3dpo\u0142nocnoameriski g\u00f3rski l\u011b\u015bojski cas",
               "MDT",
               "P\u00f3dpo\u0142nocnoameriski g\u00f3rski cas",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Marqueski cas",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Arabiski standardny cas",
               "AST",
               "Arabiski l\u011b\u015bojski cas",
               "ADT",
               "Arabiski cas",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Alaskojski standardny cas",
               "AKST",
               "Alaskojski l\u011b\u015bojski cas",
               "AKDT",
               "Alaskojski cas",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Wladiwostokski standardny cas",
               "VLAT",
               "Wladiwostokski l\u011b\u015bojski cas",
               "VLAST",
               "Wladiwostokski cas",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "Chamorrski cas",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "Irkutski standardny cas",
               "IRKT",
               "Irkutski l\u011b\u015bojski cas",
               "IRKST",
               "Irkutski cas",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Georgiski standardny cas",
               "GET",
               "Georgiski l\u011b\u015bojski cas",
               "GEST",
               "Georgiski cas",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "Tokelauski cas",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua-Nowoginejski cas",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "standardny cas Fernando de Noronha",
               "FNT",
               "l\u011b\u015bojski cas Fernando de Noronha",
               "FNST",
               "cas Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Choibalsa\u0144ski standardny cas",
               "CHOT",
               "Choibalsa\u0144ski l\u011b\u015bojski cas",
               "CHOST",
               "Choibalsa\u0144ski cas",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Bras\u00edlia standardny cas",
               "BRT",
               "Bras\u00edlia l\u011b\u015bojski cas",
               "BRST",
               "Bras\u00edlia cas",
               "BRT",
            };
        final String[] China = new String[] {
               "Chinski standardny cas",
               "CST",
               "Chinski l\u011b\u015bojski cas",
               "CDT",
               "Chinski cas",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Arme\u0144ski standardny cas",
               "AMT",
               "Arme\u0144ski l\u011b\u015bojski cas",
               "AMST",
               "Arme\u0144ski cas",
               "AMT",
            };
        final String[] India = new String[] {
               "Indiski cas",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Standardny cas Cookowych kupow",
               "CKT",
               "l\u011b\u015bojski cas Cookowych kupow",
               "CKHST",
               "cas Cookowych kupow",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Greenwichski cas",
                    "GMT",
                    "Britiski l\u011b\u015bojski cas",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Greenwichski cas",
                    "GMT",
                    "Iriski l\u011b\u015bojski cas",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
