/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.swt;

import com.sun.glass.ui.Menu;
import com.sun.glass.ui.MenuItem;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.delegate.MenuDelegate;
import com.sun.glass.ui.delegate.MenuItemDelegate;
import com.sun.glass.ui.swt.SWTApplication;
import com.sun.glass.ui.swt.SWTView;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MenuItem;

final class SWTMenuDelegate
implements MenuDelegate,
MenuItemDelegate {
    String title = "";
    MenuItem.Callback callback;
    int shortcutKey;
    int shortcutModifiers;
    Pixels pixels;
    boolean enabled;
    boolean checked;
    org.eclipse.swt.widgets.Menu menu;
    MenuItem item;
    Menu menu2;

    public SWTMenuDelegate(Menu menu2) {
        this.menu2 = menu2;
    }

    public SWTMenuDelegate() {
    }

    @Override
    public boolean createMenu(String title, boolean enabled) {
        this.title = title;
        this.enabled = enabled;
        this.menu = new org.eclipse.swt.widgets.Menu((Decorations)SWTView.hiddenShell, 4);
        this.menu.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                Menu menu2 = SWTMenuDelegate.this.menu2;
                if (menu2.getEventHandler() != null) {
                    menu2.getEventHandler().handleMenuOpening(menu2, System.nanoTime());
                }
            }
        });
        this.menu.addListener(23, new Listener(){

            public void handleEvent(Event event) {
                Menu menu2 = SWTMenuDelegate.this.menu2;
                if (menu2.getEventHandler() != null) {
                    menu2.getEventHandler().handleMenuClosed(menu2, System.nanoTime());
                }
            }
        });
        return true;
    }

    @Override
    public boolean createMenuItem(String title, MenuItem.Callback callback, int shortcutKey, int shortcutModifiers, Pixels pixels, boolean enabled, boolean checked) {
        this.title = title;
        this.callback = callback;
        this.shortcutKey = shortcutKey;
        this.shortcutModifiers = shortcutModifiers;
        this.pixels = pixels;
        this.enabled = enabled;
        this.checked = checked;
        return true;
    }

    @Override
    public boolean setTitle(String title) {
        this.title = title;
        if (this.item != null) {
            this.item.setText(title);
        }
        return true;
    }

    @Override
    public boolean setCallback(MenuItem.Callback callback) {
        this.callback = callback;
        if (this.item != null) {
            this.item.addListener(13, event -> {
                this.item.setSelection(false);
                callback.action();
            });
        }
        return true;
    }

    @Override
    public boolean setShortcut(int shortcutKey, int shortcutModifiers) {
        this.shortcutKey = shortcutKey;
        this.shortcutModifiers = shortcutModifiers;
        if (this.item != null) {
            int modifier = 0;
            if ((shortcutModifiers & 1) != 0) {
                modifier |= 0x20000;
            }
            if ((shortcutModifiers & 4) != 0) {
                modifier |= 0x40000;
            }
            if ((shortcutModifiers & 8) != 0) {
                modifier |= 0x10000;
            }
            if ((shortcutModifiers & 0x10) != 0) {
                modifier |= 0x400000;
            }
            int key = SWTApplication.getSWTKeyCode(shortcutKey);
            this.item.setAccelerator(modifier | key);
        }
        return true;
    }

    @Override
    public boolean setPixels(Pixels pixels) {
        this.pixels = pixels;
        if (this.item != null) {
            Image oldImage = this.item.getImage();
            if (oldImage != null) {
                this.item.setImage(null);
                oldImage.dispose();
            }
            Image newImage = SWTApplication.createImage(pixels);
            this.item.setImage(newImage);
        }
        return true;
    }

    @Override
    public boolean setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.item != null) {
            this.item.setEnabled(enabled);
        }
        return true;
    }

    @Override
    public boolean setChecked(boolean checked) {
        this.checked = checked;
        if (this.item != null) {
            this.item.setSelection(checked);
        }
        return true;
    }

    @Override
    public boolean insert(MenuDelegate menu, int pos) {
        ((SWTMenuDelegate)menu).item = new MenuItem(this.menu, 64, pos);
        ((SWTMenuDelegate)menu).item.setMenu(((SWTMenuDelegate)menu).menu);
        ((SWTMenuDelegate)menu).setTitle(((SWTMenuDelegate)menu).title);
        ((SWTMenuDelegate)menu).setPixels(((SWTMenuDelegate)menu).pixels);
        ((SWTMenuDelegate)menu).setEnabled(((SWTMenuDelegate)menu).enabled);
        ((SWTMenuDelegate)menu).item.addListener(12, event -> {
            Image oldImage = ((SWTMenuDelegate)menu).item.getImage();
            if (oldImage != null) {
                ((SWTMenuDelegate)menu).item.setImage(null);
                oldImage.dispose();
            }
            ((SWTMenuDelegate)menu).item = null;
        });
        return true;
    }

    @Override
    public boolean insert(MenuItemDelegate item, int pos) {
        if (item == null) {
            new MenuItem(this.menu, 2, pos);
        } else {
            ((SWTMenuDelegate)item).item = new MenuItem(this.menu, 32, pos);
            ((SWTMenuDelegate)item).item.addListener(12, event -> {
                Image oldImage = ((SWTMenuDelegate)item).item.getImage();
                if (oldImage != null) {
                    ((SWTMenuDelegate)item).item.setImage(null);
                    oldImage.dispose();
                }
                ((SWTMenuDelegate)item).item = null;
            });
            ((SWTMenuDelegate)item).setTitle(((SWTMenuDelegate)item).title);
            ((SWTMenuDelegate)item).setPixels(((SWTMenuDelegate)item).pixels);
            ((SWTMenuDelegate)item).setEnabled(((SWTMenuDelegate)item).enabled);
            ((SWTMenuDelegate)item).setChecked(((SWTMenuDelegate)item).checked);
            ((SWTMenuDelegate)item).setShortcut(((SWTMenuDelegate)item).shortcutKey, ((SWTMenuDelegate)item).shortcutModifiers);
            ((SWTMenuDelegate)item).setCallback(((SWTMenuDelegate)item).callback);
        }
        return true;
    }

    @Override
    public boolean remove(MenuDelegate menu, int pos) {
        if (0 <= pos && pos < ((SWTMenuDelegate)menu).menu.getItemCount()) {
            ((SWTMenuDelegate)menu).menu.getItem(pos).dispose();
            ((SWTMenuDelegate)menu).menu = null;
            ((SWTMenuDelegate)menu).item = null;
        }
        return true;
    }

    @Override
    public boolean remove(MenuItemDelegate item, int pos) {
        if (0 <= pos && pos < this.menu.getItemCount()) {
            this.menu.getItem(pos).dispose();
            ((SWTMenuDelegate)item).item = null;
        }
        return true;
    }
}

