/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Base64OutputStream
extends FilterOutputStream {
    private byte[] buffer = new byte[3];
    private int buflen;
    private int count;
    private int lineLength;
    private static final char[] src = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final int LF = 10;
    private static final int CR = 13;
    private static final int EQ = 61;

    public Base64OutputStream(OutputStream out) {
        this(out, 76);
    }

    public Base64OutputStream(OutputStream out, int lineLength) {
        super(out);
        this.lineLength = lineLength;
    }

    @Override
    public void write(int c) throws IOException {
        this.buffer[this.buflen++] = (byte)c;
        if (this.buflen == 3) {
            this.encode();
            this.buflen = 0;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.write(b[off + i]);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.buflen > 0) {
            this.encode();
            this.buflen = 0;
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    private void encode() throws IOException {
        if (this.count + 4 > this.lineLength) {
            this.out.write(13);
            this.out.write(10);
            this.count = 0;
        }
        if (this.buflen == 1) {
            byte b = this.buffer[0];
            int i = 0;
            boolean flag = false;
            this.out.write(src[b >>> 2 & 0x3F]);
            this.out.write(src[(b << 4 & 0x30) + (i >>> 4 & 0xF)]);
            this.out.write(61);
            this.out.write(61);
        } else if (this.buflen == 2) {
            byte b1 = this.buffer[0];
            byte b2 = this.buffer[1];
            int i = 0;
            this.out.write(src[b1 >>> 2 & 0x3F]);
            this.out.write(src[(b1 << 4 & 0x30) + (b2 >>> 4 & 0xF)]);
            this.out.write(src[(b2 << 2 & 0x3C) + (i >>> 6 & 3)]);
            this.out.write(61);
        } else {
            byte b1 = this.buffer[0];
            byte b2 = this.buffer[1];
            byte b3 = this.buffer[2];
            this.out.write(src[b1 >>> 2 & 0x3F]);
            this.out.write(src[(b1 << 4 & 0x30) + (b2 >>> 4 & 0xF)]);
            this.out.write(src[(b2 << 2 & 0x3C) + (b3 >>> 6 & 3)]);
            this.out.write(src[b3 & 0x3F]);
        }
        this.count += 4;
    }
}

