/*
 * Decompiled with CFR 0.152.
 */
package org.ictclas4j.bean;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.ictclas4j.bean.ModifyTable;
import org.ictclas4j.bean.Preword;
import org.ictclas4j.bean.WordItem;
import org.ictclas4j.bean.WordTable;
import org.ictclas4j.utility.GFCommon;
import org.ictclas4j.utility.GFString;
import org.ictclas4j.utility.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dictionary {
    public ArrayList<WordTable> wts;
    public ArrayList<ModifyTable> mts;

    public Dictionary() {
        this.init();
    }

    public Dictionary(String filename) {
        this.init();
        this.load(filename);
    }

    public void init() {
        this.wts = new ArrayList();
        this.mts = new ArrayList();
        for (int i = 0; i < 6768; ++i) {
            this.wts.add(new WordTable());
            this.mts.add(new ModifyTable());
        }
    }

    public boolean load(InputStream input, boolean isReset) {
        int[] nBuffer = new int[3];
        try {
            DataInputStream in = new DataInputStream(input);
            this.delModified();
            for (int i = 0; i < 6768; ++i) {
                int count = GFCommon.bytes2int(Utility.readBytes(in, 4), false);
                this.wts.get(i).setCount(count);
                if (count <= 0) continue;
                WordItem[] wis = new WordItem[count];
                for (int j = 0; j < count; ++j) {
                    nBuffer[0] = GFCommon.bytes2int(Utility.readBytes(in, 4), false);
                    nBuffer[1] = GFCommon.bytes2int(Utility.readBytes(in, 4), false);
                    nBuffer[2] = GFCommon.bytes2int(Utility.readBytes(in, 4), false);
                    WordItem ti = new WordItem();
                    if (nBuffer[1] > 0) {
                        byte[] word = Utility.readBytes(in, nBuffer[1]);
                        String GBK = new String(word, "GBK");
                        ti.setWord(GBK);
                    } else {
                        ti.setWord("");
                    }
                    if (isReset) {
                        ti.setFreq(0);
                    } else {
                        ti.setFreq(nBuffer[0]);
                    }
                    ti.setLen(nBuffer[1] / 2);
                    ti.setHandle(nBuffer[2]);
                    wis[j] = ti;
                }
                this.wts.get(i).setWords(wis);
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean load(String filename) {
        return this.load(filename, false);
    }

    public boolean load(String filename, boolean isReset) {
        int[] nBuffer = new int[3];
        File file = new File(filename);
        if (!file.canRead()) {
            return false;
        }
        try {
            this.delModified();
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            for (int i = 0; i < 6768; ++i) {
                int count = GFCommon.bytes2int(Utility.readBytes(in, 4), false);
                this.wts.get(i).setCount(count);
                if (count <= 0) continue;
                WordItem[] wis = new WordItem[count];
                for (int j = 0; j < count; ++j) {
                    nBuffer[0] = GFCommon.bytes2int(Utility.readBytes(in, 4), false);
                    nBuffer[1] = GFCommon.bytes2int(Utility.readBytes(in, 4), false);
                    nBuffer[2] = GFCommon.bytes2int(Utility.readBytes(in, 4), false);
                    WordItem ti = new WordItem();
                    if (nBuffer[1] > 0) {
                        byte[] word = Utility.readBytes(in, nBuffer[1]);
                        ti.setWord(new String(word, "GBK"));
                    } else {
                        ti.setWord("");
                    }
                    if (isReset) {
                        ti.setFreq(0);
                    } else {
                        ti.setFreq(nBuffer[0]);
                    }
                    ti.setLen(nBuffer[1] / 2);
                    ti.setHandle(nBuffer[2]);
                    wis[j] = ti;
                }
                this.wts.get(i).setWords(wis);
            }
            in.close();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return true;
    }

    public boolean save(String filename) {
        int[] nBuffer = new int[3];
        File file = new File(filename);
        try {
            DataOutputStream out = new DataOutputStream(new FileOutputStream(file));
            for (int i = 0; i < 6768; ++i) {
                int j;
                if (this.mts != null) {
                    WordItem wi;
                    int nCount = this.wts.get(i).getCount() + this.mts.get(i).getCount() - this.mts.get(i).getDelete();
                    out.write(GFCommon.int2bytes(nCount, false));
                    j = 0;
                    int k = 0;
                    while (j < this.mts.get(i).getCount() && k < this.wts.get(i).getCount()) {
                        WordItem mwi = this.mts.get(i).getWords().get(j);
                        WordItem wi2 = this.wts.get(i).getWords().get(k);
                        if (mwi.getLen() < wi2.getLen() || this.strEqual(mwi.getWord(), wi2.getWord()) && mwi.getHandle() < wi2.getHandle()) {
                            nBuffer[0] = mwi.getFreq();
                            nBuffer[1] = mwi.getLen();
                            nBuffer[2] = mwi.getHandle();
                            for (int n : nBuffer) {
                                out.write(GFCommon.int2bytes(n, false));
                            }
                            if (nBuffer[1] > 0) {
                                out.write(mwi.getWord().getBytes());
                            }
                            ++j;
                            continue;
                        }
                        if (mwi.getFreq() == -1) {
                            ++k;
                            continue;
                        }
                        if (mwi.getLen() <= wi2.getLen() && (!this.strEqual(mwi.getWord(), wi2.getWord()) || mwi.getHandle() <= wi2.getHandle())) continue;
                        nBuffer[0] = wi2.getFreq();
                        nBuffer[1] = wi2.getLen();
                        nBuffer[2] = wi2.getHandle();
                        for (int n : nBuffer) {
                            out.write(GFCommon.int2bytes(n, false));
                        }
                        if (nBuffer[1] > 0) {
                            out.write(wi2.getWord().getBytes());
                        }
                        ++k;
                    }
                    if (k < this.wts.get(i).getCount()) {
                        while (k < this.wts.get(i).getCount()) {
                            wi = this.wts.get(i).getWords().get(k);
                            if (wi.getFreq() != -1) {
                                nBuffer[0] = wi.getFreq();
                                nBuffer[1] = wi.getLen();
                                nBuffer[2] = wi.getHandle();
                                for (int n : nBuffer) {
                                    out.write(GFCommon.int2bytes(n, false));
                                }
                                if (nBuffer[1] > 0) {
                                    out.write(wi.getWord().getBytes());
                                }
                            }
                            ++k;
                        }
                        continue;
                    }
                    while (j < this.mts.get(i).getCount()) {
                        wi = this.mts.get(i).getWords().get(j);
                        nBuffer[0] = wi.getFreq();
                        nBuffer[1] = wi.getLen();
                        nBuffer[2] = wi.getHandle();
                        for (int n : nBuffer) {
                            out.write(GFCommon.int2bytes(n, false));
                        }
                        if (nBuffer[1] <= 0) continue;
                        out.write(wi.getWord().getBytes());
                    }
                    continue;
                }
                out.writeInt(this.wts.get(i).getCount());
                for (j = 0; j < this.wts.get(i).getCount(); ++j) {
                    WordItem wi = this.wts.get(i).getWords().get(j);
                    nBuffer[0] = wi.getFreq();
                    nBuffer[1] = wi.getLen();
                    nBuffer[2] = wi.getHandle();
                    for (int n : nBuffer) {
                        out.write(GFCommon.int2bytes(n, false));
                    }
                    if (nBuffer[1] <= 0) continue;
                    out.write(wi.getWord().getBytes());
                }
            }
            out.close();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return true;
    }

    public boolean addItem(String word, int handle, int frequency) {
        Preword pw = this.preProcessing(word);
        if (pw != null & pw.getWord() != null) {
            int found2;
            int found = this.findInOriginalTable(pw.getIndex(), pw.getRes(), handle);
            if (found >= 0) {
                WordItem wi = this.wts.get(pw.getIndex()).getWords().get(found);
                if (wi.getFreq() != -1) {
                    wi.setFreq(frequency);
                    if (this.mts == null) {
                        this.mts = new ArrayList(6768);
                    }
                    this.mts.get(pw.getIndex()).setDelete(this.mts.get(pw.getIndex()).getDelete() - 1);
                } else {
                    wi.setFreq(wi.getFreq() + frequency);
                }
                return true;
            }
            if (this.mts == null) {
                this.mts = new ArrayList(6768);
            }
            if ((found2 = this.findInModifyTable(pw.getIndex(), pw.getRes(), handle)) >= 0) {
                WordItem wi = this.mts.get(pw.getIndex()).getWords().get(found2);
                wi.setFreq(wi.getFreq() + frequency);
                return true;
            }
            WordItem wi = new WordItem();
            wi.setFreq(frequency);
            wi.setHandle(handle);
            wi.setLen(pw.getRes().length());
            wi.setWord(pw.getRes());
            ModifyTable mt = this.mts.get(pw.getIndex());
            mt.getWords().add(found2, wi);
            mt.setCount(mt.getCount() + 1);
            return true;
        }
        return false;
    }

    public boolean delItem(String word, int handle) {
        Preword pw = this.preProcessing(word);
        if (pw != null & pw.getWord() != null) {
            int found = this.findInOriginalTable(pw.getIndex(), pw.getRes(), handle);
            if (found >= 0) {
                if (this.mts == null) {
                    this.mts = new ArrayList(6768);
                }
                ModifyTable mt = this.mts.get(pw.getIndex());
                WordItem wi = mt.getWords().get(found);
                wi.setFreq(-1);
                mt.setCount(mt.getDelete() + 1);
                if (handle == -1) {
                    for (int i = found; i < mt.getCount() && this.strEqual(mt.getWords().get(i).getWord(), pw.getRes()); ++i) {
                        WordItem wi2 = mt.getWords().get(i);
                        wi2.setFreq(-1);
                        mt.setDelete(mt.getDelete() + 1);
                    }
                }
                return true;
            }
            int found2 = this.findInModifyTable(pw.getIndex(), pw.getRes(), handle);
            if (found2 >= 0) {
                ModifyTable mt = this.mts.get(pw.getIndex());
                ArrayList<WordItem> wis = mt.getWords();
                for (int i = found2; i < wis.size(); ++i) {
                    WordItem wi = wis.get(i);
                    if (!this.strEqual(wi.getWord(), pw.getRes()) || wi.getHandle() != handle && handle >= 0) continue;
                    wis.remove(wi);
                    mt.setCount(mt.getCount() - 1);
                    --i;
                }
                return true;
            }
        }
        return false;
    }

    protected boolean delModified() {
        this.mts = null;
        return true;
    }

    public boolean isExist(String word, int handle) {
        Preword pw;
        return word != null && (pw = this.preProcessing(word)) != null && (this.findInOriginalTable(pw.getIndex(), pw.getRes(), handle) >= 0 || this.findInModifyTable(pw.getIndex(), pw.getRes(), handle) >= 0);
    }

    public ArrayList<WordItem> getHandle(String word) {
        ArrayList<WordItem> result = null;
        if (word != null) {
            result = new ArrayList<WordItem>();
            Preword pw = this.preProcessing(word);
            if (pw != null && pw.getWord() != null) {
                int found = this.findInOriginalTable(pw.getIndex(), pw.getRes(), -1);
                if (found >= 0) {
                    WordItem wi = new WordItem();
                    WordItem wi2 = this.wts.get(pw.getIndex()).getWords().get(found);
                    wi.setHandle(wi2.getHandle());
                    wi.setFreq(wi2.getFreq());
                    result.add(wi);
                    WordTable wt = this.wts.get(pw.getIndex());
                    for (int temp = found + 1; temp < wt.getCount() && this.strEqual(wt.getWords().get(temp).getWord(), pw.getRes()); ++temp) {
                        wi = new WordItem();
                        wi.setHandle(wt.getWords().get(temp).getHandle());
                        wi.setFreq(wt.getWords().get(temp).getFreq());
                        wi.setWord(word);
                        result.add(wi);
                    }
                    return result;
                }
                int found2 = this.findInModifyTable(pw.getIndex(), pw.getRes(), -1);
                if (found2 >= 0) {
                    ModifyTable mt = this.mts.get(pw.getIndex());
                    ArrayList<WordItem> wis = mt.getWords();
                    for (int i = found2; i < wis.size(); ++i) {
                        WordItem wi0 = wis.get(i);
                        if (!this.strEqual(wi0.getWord(), pw.getRes())) continue;
                        WordItem wi = new WordItem();
                        wi.setHandle(wi0.getHandle());
                        wi.setFreq(wi0.getFreq());
                        wi.setWord(word);
                        result.add(wi);
                    }
                }
            }
        }
        return result;
    }

    public int findInOriginalTable(int index, String res, int handle) {
        WordTable wt;
        int result = -1;
        if (res != null && this.wts != null && (wt = this.wts.get(index)) != null && wt.getCount() > 0) {
            int start = 0;
            int end = wt.getCount() - 1;
            int mid = (end + start) / 2;
            ArrayList<WordItem> wis = wt.getWords();
            while (start <= end) {
                WordItem wi = wis.get(mid);
                int cmpValue = GFString.compareTo(wi.getWord(), res);
                if (cmpValue == 0 && (wi.getHandle() == handle || handle == -1)) {
                    if (handle == -1) {
                        while (mid >= 0 && res.compareTo(wis.get(mid).getWord()) == 0) {
                            --mid;
                        }
                        if (mid < 0 || res.compareTo(wis.get(mid).getWord()) != 0) {
                            ++mid;
                        }
                    }
                    result = mid;
                    return result;
                }
                if (cmpValue < 0 || cmpValue == 0 && wi.getHandle() < handle && handle != -1) {
                    start = mid + 1;
                } else if (cmpValue > 0 || cmpValue == 0 && wi.getHandle() > handle && handle != -1) {
                    end = mid - 1;
                }
                mid = (start + end) / 2;
            }
        }
        return result;
    }

    protected int findInModifyTable(int index, String res, int handle) {
        int result = -1;
        if (this.mts != null && this.mts.size() > index) {
            ArrayList<WordItem> wis = this.mts.get(index).getWords();
            if (res != null && wis != null) {
                int i;
                for (i = 0; i < wis.size(); ++i) {
                    WordItem wi = wis.get(i);
                    if (wi.getWord().length() >= res.length() && wi.getWord().length() == res.length() && wi.getHandle() >= handle) continue;
                }
                if (i < wis.size() && this.strEqual(wis.get(i).getWord(), res) && (wis.get(i).getHandle() == handle || handle < 0)) {
                    result = i;
                }
            }
        }
        return result;
    }

    public boolean strEqual(String b1, String b2) {
        if (b1 == null && b2 == null) {
            return true;
        }
        if (b1 != null && b2 != null) {
            return b1.equals(b2);
        }
        return false;
    }

    public int getWordType(String word) {
        if (word != null) {
            int type = Utility.charType(word);
            int len = word.length();
            if (len > 0 && type == 7 && GFString.isAllChinese(word)) {
                return 1;
            }
            if (len > 0 && type == 6) {
                return 0;
            }
        }
        return 2;
    }

    public Preword preProcessing(String word) {
        Preword result = null;
        if (word != null && word.length() > 0) {
            int type = Utility.charType(word);
            int begin = 0;
            int len = (word = GFString.removeSpace(word)).length();
            int end = len - 1;
            if (begin > end) {
                return null;
            }
            result = new Preword();
            result.setWord(word);
            if (type == 7) {
                result.setIndex(Utility.CC_ID(word));
                if (word != null) {
                    result.setRes(word.length() > 1 ? word.substring(1) : "");
                }
            } else if (type == 6) {
                result.setIndex(3755);
                result.setRes(word);
            } else {
                result.setIndex(-1);
            }
        }
        return result;
    }

    public boolean mergePOS(int handle) {
        this.mts = new ArrayList();
        for (int i = 0; i < 6768; ++i) {
        }
        return false;
    }

    public WordItem getMaxMatch(String word) {
        Preword pw;
        if (word != null && (pw = this.preProcessing(word)) != null & pw.getWord() != null && pw.getIndex() >= 0) {
            ArrayList<WordItem> wis;
            String firstChar = pw.getWord().substring(0, 1);
            int found = this.findInOriginalTable(pw.getIndex(), pw.getRes(), -1);
            if (found == -1) {
                wis = this.wts.get(pw.getIndex()).getWords();
                for (int j = 0; j < wis.size(); ++j) {
                    int compValue = GFString.compareTo(wis.get(j).getWord(), pw.getRes());
                    if (compValue != 1) continue;
                    found = j;
                    break;
                }
            }
            if (found >= 0 && this.wts != null && this.wts.get(pw.getIndex()) != null) {
                wis = this.wts.get(pw.getIndex()).getWords();
                if (wis == null) {
                    return null;
                }
                WordItem wi = wis.get(found);
                String wordRet = firstChar + wi.getWord();
                return new WordItem(wordRet, wi.getLen(), wi.getHandle(), wi.getFreq());
            }
            wis = null;
            if (this.mts != null && this.mts.get(pw.getIndex()) != null && (wis = this.mts.get(pw.getIndex()).getWords()) != null) {
                for (WordItem wi : wis) {
                    if (pw.getRes() == null || !pw.getRes().equals(wi.getWord())) continue;
                    String wordRet = firstChar + wi.getWord();
                    return new WordItem(wordRet, wi.getLen(), wi.getHandle(), wi.getFreq());
                }
            }
        }
        return null;
    }

    public int getFreq(String word, int handle) {
        Preword pw;
        if (word != null && word.length() > 0 && (pw = this.preProcessing(word)) != null) {
            int found = this.findInOriginalTable(pw.getIndex(), pw.getRes(), handle);
            if (found >= 0 && this.wts != null) {
                WordTable wt = this.wts.get(pw.getIndex());
                WordItem wi = wt.getWords().get(found);
                return wi.getFreq();
            }
            int found2 = this.findInModifyTable(pw.getIndex(), pw.getRes(), handle);
            if (found2 >= 0 && this.mts != null) {
                ModifyTable mt = this.mts.get(pw.getIndex());
                WordItem wi = mt.getWords().get(found);
                return wi.getFreq();
            }
        }
        return 0;
    }

    public boolean optimum() {
        return false;
    }

    public boolean merge(Dictionary dict2, int nRatio) {
        return false;
    }

    public boolean outputChars(String sFilename) {
        return false;
    }

    public boolean output(String sFilename) {
        return false;
    }

    public boolean getPOSString(int nPOS, String sPOSRet) {
        return false;
    }

    public int getPOSValue(byte[] sPOS) {
        return 0;
    }
}

