/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import processing.app.Language;
import processing.app.Platform;
import processing.app.Sketch;
import processing.app.ui.Editor;
import processing.app.ui.Toolkit;

public class FindReplace
extends JFrame {
    Editor editor;
    static final int BORDER = Platform.isMacOS() ? 20 : 13;
    JTextField findField;
    JTextField replaceField;
    static String findString;
    static String replaceString;
    JButton replaceButton;
    JButton replaceAllButton;
    JButton replaceAndFindButton;
    JButton previousButton;
    JButton findButton;
    JCheckBox ignoreCaseBox;
    static boolean ignoreCase;
    JCheckBox allTabsBox;
    static boolean allTabs;
    JCheckBox wrapAroundBox;
    static boolean wrapAround;

    static {
        ignoreCase = true;
        allTabs = false;
        wrapAround = true;
    }

    public FindReplace(Editor editor) {
        super(Language.text("find"));
        this.editor = editor;
        Container pain = this.getContentPane();
        JLabel findLabel = new JLabel(Language.text("find.find"));
        JLabel replaceLabel = new JLabel(Language.text("find.replace_with"));
        this.findField = new JTextField();
        this.replaceField = new JTextField();
        if (findString != null) {
            this.findField.setText(findString);
        }
        if (replaceString != null) {
            this.replaceField.setText(replaceString);
        }
        this.ignoreCaseBox = new JCheckBox(Language.text("find.ignore_case"));
        this.ignoreCaseBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ignoreCase = FindReplace.this.ignoreCaseBox.isSelected();
            }
        });
        this.ignoreCaseBox.setSelected(ignoreCase);
        this.allTabsBox = new JCheckBox(Language.text("find.all_tabs"));
        this.allTabsBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                allTabs = FindReplace.this.allTabsBox.isSelected();
            }
        });
        this.allTabsBox.setSelected(allTabs);
        this.allTabsBox.setEnabled(true);
        this.wrapAroundBox = new JCheckBox(Language.text("find.wrap_around"));
        this.wrapAroundBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                wrapAround = FindReplace.this.wrapAroundBox.isSelected();
            }
        });
        this.wrapAroundBox.setSelected(wrapAround);
        GroupLayout layout = new GroupLayout(pain);
        pain.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        GroupLayout.SequentialGroup buttonsHorizontalGroup = layout.createSequentialGroup();
        this.replaceAllButton = new JButton(Language.text("find.btn.replace_all"));
        this.replaceButton = new JButton(Language.text("find.btn.replace"));
        this.replaceAndFindButton = new JButton(Language.text("find.btn.replace_and_find"));
        this.previousButton = new JButton(Language.text("find.btn.previous"));
        this.findButton = new JButton(Language.text("find.btn.find"));
        if (Platform.isMacOS()) {
            ((GroupLayout.Group)buttonsHorizontalGroup).addComponent(this.replaceAllButton).addComponent(this.replaceButton).addComponent(this.replaceAndFindButton).addComponent(this.previousButton).addComponent(this.findButton);
        } else {
            ((GroupLayout.Group)buttonsHorizontalGroup).addComponent(this.findButton).addComponent(this.previousButton).addComponent(this.replaceAndFindButton).addComponent(this.replaceButton).addComponent(this.replaceAllButton);
        }
        this.setFound(false);
        GroupLayout.ParallelGroup buttonsVerticalGroup = layout.createParallelGroup();
        ((GroupLayout.Group)buttonsVerticalGroup).addComponent(this.findButton).addComponent(this.previousButton).addComponent(this.replaceAndFindButton).addComponent(this.replaceButton).addComponent(this.replaceAllButton);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGap(BORDER).addGroup(layout.createParallelGroup().addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(replaceLabel.getPreferredSize().width - findLabel.getPreferredSize().width).addComponent(findLabel).addComponent(this.findField)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(replaceLabel).addGroup(layout.createParallelGroup().addComponent(this.replaceField).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.ignoreCaseBox).addComponent(this.allTabsBox).addComponent(this.wrapAroundBox).addGap(0)))).addGroup(GroupLayout.Alignment.CENTER, buttonsHorizontalGroup)).addGap(BORDER));
        layout.setVerticalGroup(layout.createSequentialGroup().addGap(BORDER).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(findLabel).addComponent(this.findField)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(replaceLabel).addComponent(this.replaceField)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.ignoreCaseBox).addComponent(this.allTabsBox).addComponent(this.wrapAroundBox)).addGroup(buttonsVerticalGroup).addGap(BORDER));
        this.setLocationRelativeTo(null);
        Dimension size = layout.preferredLayoutSize(pain);
        this.setSize(size.width, size.height);
        Dimension screen = Toolkit.getScreenSize();
        this.setLocation((screen.width - size.width) / 2, (screen.height - size.height) / 2);
        this.replaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindReplace.this.replace();
            }
        });
        this.replaceAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindReplace.this.replaceAll();
            }
        });
        this.replaceAndFindButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindReplace.this.replaceAndFindNext();
            }
        });
        this.findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindReplace.this.findNext();
            }
        });
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindReplace.this.findPrevious();
            }
        });
        this.getRootPane().setDefaultButton(this.findButton);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FindReplace.this.handleClose();
            }
        });
        Toolkit.registerWindowCloseKeys(this.getRootPane(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindReplace.this.handleClose();
            }
        });
        Toolkit.setIcon(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                FindReplace.this.findField.requestFocusInWindow();
                FindReplace.this.findField.selectAll();
            }
        });
        this.pack();
        this.setResizable(true);
        this.setLocationRelativeTo(null);
    }

    public void handleClose() {
        findString = this.findField.getText();
        replaceString = this.replaceField.getText();
        this.setVisible(false);
    }

    private boolean find(boolean wrap, boolean backwards) {
        String searchTerm = this.findField.getText();
        if (searchTerm.length() != 0) {
            int nextIndex;
            String text = this.editor.getText();
            Sketch sketch = this.editor.getSketch();
            int tabIndex = sketch.getCurrentCodeIndex();
            if (ignoreCase) {
                searchTerm = searchTerm.toLowerCase();
                text = text.toLowerCase();
            }
            if (!backwards) {
                int selectionEnd = this.editor.getSelectionStop();
                nextIndex = text.indexOf(searchTerm, selectionEnd);
                if (nextIndex == -1 && wrap && !allTabs) {
                    nextIndex = text.indexOf(searchTerm, 0);
                } else if (nextIndex == -1 && allTabs) {
                    int tempIndex = tabIndex;
                    while (tabIndex <= sketch.getCodeCount() - 1) {
                        if (tabIndex == sketch.getCodeCount() - 1) {
                            tabIndex = -1;
                        } else if (tabIndex == sketch.getCodeCount() - 1) break;
                        try {
                            Document doc = sketch.getCode(tabIndex + 1).getDocument();
                            text = doc != null ? doc.getText(0, doc.getLength()) : sketch.getCode(tabIndex + 1).getProgram();
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                        }
                        ++tabIndex;
                        if (ignoreCase) {
                            text = text.toLowerCase();
                        }
                        if ((nextIndex = text.indexOf(searchTerm, 0)) != -1 || tabIndex == tempIndex) break;
                    }
                    if (nextIndex == -1) {
                        tabIndex = tempIndex;
                    }
                }
            } else {
                int selectionStart = this.editor.getSelectionStart() - 1;
                nextIndex = selectionStart >= 0 ? text.lastIndexOf(searchTerm, selectionStart) : -1;
                if (wrap && !allTabs && nextIndex == -1) {
                    nextIndex = text.lastIndexOf(searchTerm);
                } else if (nextIndex == -1 && allTabs) {
                    int tempIndex = tabIndex;
                    while (tabIndex >= 0) {
                        if (tabIndex == 0) {
                            tabIndex = sketch.getCodeCount();
                        } else if (tabIndex == 0) break;
                        try {
                            Document doc = sketch.getCode(tabIndex - 1).getDocument();
                            text = doc != null ? doc.getText(0, doc.getLength()) : sketch.getCode(tabIndex - 1).getProgram();
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                        }
                        --tabIndex;
                        if (ignoreCase) {
                            text = text.toLowerCase();
                        }
                        if ((nextIndex = text.lastIndexOf(searchTerm)) != -1 || tabIndex == tempIndex) break;
                    }
                    if (nextIndex == -1) {
                        tabIndex = tempIndex;
                    }
                }
            }
            if (nextIndex != -1) {
                if (allTabs) {
                    sketch.setCurrentCode(tabIndex);
                }
                this.editor.setSelection(nextIndex, nextIndex + searchTerm.length());
            }
            if (nextIndex != -1) {
                this.setFound(true);
                return true;
            }
        }
        this.setFound(false);
        return false;
    }

    protected void setFound(boolean found) {
        this.replaceButton.setEnabled(found);
        this.replaceAndFindButton.setEnabled(found);
    }

    public void replace(boolean isCompoundEdit) {
        this.editor.setSelectedText(this.replaceField.getText(), isCompoundEdit);
        this.editor.getSketch().setModified(true);
        this.setFound(false);
    }

    public void replace() {
        this.replace(true);
    }

    public void replaceAndFindNext() {
        this.replace();
        this.findNext();
    }

    public void replaceAll() {
        this.editor.setSelection(0, 0);
        boolean foundAtLeastOne = false;
        int startTab = -1;
        int startIndex = -1;
        int counter = 10000;
        this.editor.startCompoundEdit();
        while (--counter > 0) {
            if (!this.find(false, false)) break;
            int caret = this.editor.getSelectionStart();
            int stopIndex = startIndex + this.replaceField.getText().length();
            if (this.editor.getSketch().getCurrentCodeIndex() == startTab && caret >= startIndex && caret <= stopIndex) {
                Toolkit.beep();
                this.editor.statusNotice("Reached beginning of search!");
                break;
            }
            if (!foundAtLeastOne) {
                foundAtLeastOne = true;
                startTab = this.editor.getSketch().getCurrentCodeIndex();
                startIndex = this.editor.getSelectionStart();
            }
            this.replace(false);
        }
        this.editor.stopCompoundEdit();
        if (!foundAtLeastOne) {
            Toolkit.beep();
        }
        this.setFound(false);
    }

    public void setFindText(String t) {
        this.findField.setText(t);
        findString = t;
    }

    public void findNext() {
        if (!this.find(wrapAround, false)) {
            Toolkit.beep();
        }
    }

    public void findPrevious() {
        if (!this.find(wrapAround, true)) {
            Toolkit.beep();
        }
    }

    public boolean canFindNext() {
        return this.findField.getText().length() != 0;
    }
}

