/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.pdex;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.SimpleName;
import processing.app.Language;
import processing.app.ui.Toolkit;
import processing.app.ui.ZoomTreeCellRenderer;
import processing.mode.java.JavaEditor;
import processing.mode.java.pdex.ASTUtils;
import processing.mode.java.pdex.PreprocessedSketch;
import processing.mode.java.pdex.PreprocessingService;
import processing.mode.java.pdex.ShowUsageTreeNode;

class ShowUsage {
    final JDialog window;
    final JTree tree;
    final JavaEditor editor;
    final PreprocessingService pps;
    final Consumer<PreprocessedSketch> reloadListener;
    IBinding binding;

    ShowUsage(JavaEditor editor, final PreprocessingService pps) {
        this.editor = editor;
        this.pps = pps;
        JMenuItem showUsageItem = new JMenuItem(Language.text((String)"editor.popup.show_usage"));
        showUsageItem.addActionListener(e -> this.handleShowUsage());
        editor.getTextArea().getRightClickPopup().add(showUsageItem);
        this.reloadListener = this::reloadShowUsage;
        this.window = new JDialog((Frame)((Object)editor));
        this.window.setDefaultCloseOperation(1);
        this.window.setAutoRequestFocus(false);
        this.window.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                ShowUsage.this.binding = null;
                ShowUsage.this.tree.setModel(null);
                pps.unregisterListener(ShowUsage.this.reloadListener);
            }

            @Override
            public void componentShown(ComponentEvent e) {
                pps.registerListener(ShowUsage.this.reloadListener);
            }
        });
        this.window.setSize(Toolkit.zoom((int)300, (int)400));
        this.window.setFocusableWindowState(false);
        Toolkit.setIcon((Window)this.window);
        JScrollPane sp2 = new JScrollPane();
        this.tree = new JTree();
        ZoomTreeCellRenderer renderer = new ZoomTreeCellRenderer(editor.getMode());
        this.tree.setCellRenderer((TreeCellRenderer)renderer);
        renderer.setLeafIcon(null);
        renderer.setClosedIcon(null);
        renderer.setOpenIcon(null);
        renderer.setBackgroundSelectionColor(new Color(228, 248, 246));
        renderer.setBorderSelectionColor(new Color(0, 0, 0, 0));
        renderer.setTextSelectionColor(Color.BLACK);
        sp2.setViewportView(this.tree);
        this.window.add(sp2);
        this.tree.addTreeSelectionListener(e -> {
            DefaultMutableTreeNode tnode;
            if (this.tree.getLastSelectedPathComponent() != null && (tnode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent()).getUserObject() instanceof ShowUsageTreeNode) {
                ShowUsageTreeNode node = (ShowUsageTreeNode)tnode.getUserObject();
                editor.highlight(node.tabIndex, node.startTabOffset, node.stopTabOffset);
            }
        });
    }

    void handleShowUsage() {
        int startOffset = this.editor.getSelectionStart();
        int stopOffset = this.editor.getSelectionStop();
        int tabIndex = this.editor.getSketch().getCurrentCodeIndex();
        this.pps.whenDoneBlocking(ps -> this.handleShowUsage((PreprocessedSketch)ps, tabIndex, startOffset, stopOffset));
    }

    void handleShowUsage(PreprocessedSketch ps, int tabIndex, int startTabOffset, int stopTabOffset) {
        int stopJavaOffset;
        int startJavaOffset = ps.tabOffsetToJavaOffset(tabIndex, startTabOffset);
        SimpleName name = ASTUtils.getSimpleNameAt((ASTNode)ps.compilationUnit, startJavaOffset, stopJavaOffset = ps.tabOffsetToJavaOffset(tabIndex, stopTabOffset));
        if (name == null) {
            this.editor.statusMessage("Cannot find any name under cursor", 0);
            return;
        }
        IBinding binding = ASTUtils.resolveBinding(name);
        if (binding == null) {
            this.editor.statusMessage("Cannot find usages, try to fix errors in your code first", 0);
            return;
        }
        this.findUsageAndUpdateTree(ps, binding);
    }

    void findUsageAndUpdateTree(PreprocessedSketch ps, IBinding binding) {
        this.binding = binding;
        String bindingType = "";
        switch (binding.getKind()) {
            case 4: {
                IMethodBinding method = (IMethodBinding)binding;
                if (method.isConstructor()) {
                    bindingType = "Constructor";
                    break;
                }
                bindingType = "Method";
                break;
            }
            case 2: {
                bindingType = "Type";
                break;
            }
            case 3: {
                IVariableBinding variable = (IVariableBinding)binding;
                bindingType = variable.isField() ? "Field" : (variable.isParameter() ? "Parameter" : (variable.isEnumConstant() ? "Enum constant" : "Local variable"));
            }
        }
        String bindingKey = binding.getKey();
        List intervals = ASTUtils.findAllOccurrences((ASTNode)ps.compilationUnit, bindingKey).stream().map(ps::mapJavaToSketch).filter(ps::inRange).filter(in -> in.startPdeOffset < in.stopPdeOffset).collect(Collectors.toList());
        int usageCount = intervals.size();
        String elementName = intervals.stream().findAny().map(si -> preprocessedSketch.pdeCode.substring(si.startPdeOffset, si.stopPdeOffset)).orElseGet(() -> ((IBinding)binding).getName());
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(String.valueOf(bindingType) + ": " + elementName);
        intervals.stream().map(in -> ShowUsageTreeNode.fromSketchInterval(ps, in)).collect(Collectors.groupingBy(node -> node.tabIndex)).entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(entry -> {
            Integer tabIndex = (Integer)entry.getKey();
            List nodes = (List)entry.getValue();
            int count = nodes.size();
            String usageLabel = count == 1 ? "usage" : "usages";
            String tabLabel = "<html><font color=#222222>" + preprocessedSketch.sketch.getCode(tabIndex.intValue()).getPrettyName() + "</font> <font color=#999999>" + count + " " + usageLabel + "</font></html>";
            DefaultMutableTreeNode tabNode = new DefaultMutableTreeNode(tabLabel);
            nodes.stream().map(DefaultMutableTreeNode::new).forEach(tabNode::add);
            return tabNode;
        }).forEach(rootNode::add);
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        EventQueue.invokeLater(() -> {
            this.tree.setModel(treeModel);
            int i = 0;
            while (i < this.tree.getRowCount()) {
                this.tree.expandRow(i);
                ++i;
            }
            this.tree.setRootVisible(true);
            if (!this.window.isVisible()) {
                this.window.setVisible(true);
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice defaultScreen = ge.getDefaultScreenDevice();
                Rectangle rect = defaultScreen.getDefaultConfiguration().getBounds();
                int maxX = (int)rect.getMaxX() - this.window.getWidth();
                int x = Math.min(this.editor.getX() + this.editor.getWidth(), maxX);
                int y = x == maxX ? 10 : this.editor.getY();
                this.window.setLocation(x, y);
            }
            this.window.toFront();
            this.window.setTitle("Usage of \"" + elementName + "\" : " + usageCount + " time(s)");
        });
    }

    void reloadShowUsage(PreprocessedSketch ps) {
        if (this.binding != null) {
            this.findUsageAndUpdateTree(ps, this.binding);
        }
    }

    void hide() {
        this.window.setVisible(false);
    }

    void dispose() {
        if (this.window != null) {
            this.window.dispose();
        }
    }
}

