/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.netbeans.lib.profiler.heap.CacheDirectory;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.ClassDumpInstance;
import org.netbeans.lib.profiler.heap.ClassDumpSegment;
import org.netbeans.lib.profiler.heap.ComputedSummary;
import org.netbeans.lib.profiler.heap.DominatorTree;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.HeapProgress;
import org.netbeans.lib.profiler.heap.HeapSummary;
import org.netbeans.lib.profiler.heap.HprofArrayValue;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofField;
import org.netbeans.lib.profiler.heap.HprofFieldObjectValue;
import org.netbeans.lib.profiler.heap.HprofGCRoots;
import org.netbeans.lib.profiler.heap.HprofInstanceObjectValue;
import org.netbeans.lib.profiler.heap.HprofObject;
import org.netbeans.lib.profiler.heap.HprofProxy;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.InstanceDump;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.LoadClassSegment;
import org.netbeans.lib.profiler.heap.LongIterator;
import org.netbeans.lib.profiler.heap.LongMap;
import org.netbeans.lib.profiler.heap.NearestGCRoot;
import org.netbeans.lib.profiler.heap.ObjectArrayDump;
import org.netbeans.lib.profiler.heap.PrimitiveArrayDump;
import org.netbeans.lib.profiler.heap.StackFrameSegment;
import org.netbeans.lib.profiler.heap.StackTraceSegment;
import org.netbeans.lib.profiler.heap.StringSegment;
import org.netbeans.lib.profiler.heap.Summary;
import org.netbeans.lib.profiler.heap.SyntheticClassField;
import org.netbeans.lib.profiler.heap.SyntheticClassObjectValue;
import org.netbeans.lib.profiler.heap.TagBounds;
import org.netbeans.lib.profiler.heap.TreeObject;

class HprofHeap
implements Heap {
    static final int STRING = 1;
    static final int LOAD_CLASS = 2;
    private static final int UNLOAD_CLASS = 3;
    static final int STACK_FRAME = 4;
    static final int STACK_TRACE = 5;
    private static final int ALLOC_SITES = 6;
    static final int HEAP_SUMMARY = 7;
    private static final int START_THREAD = 10;
    private static final int END_THREAD = 11;
    private static final int HEAP_DUMP = 12;
    private static final int HEAP_DUMP_SEGMENT = 28;
    private static final int HEAP_DUMP_END = 44;
    private static final int CPU_SAMPLES = 13;
    private static final int CONTROL_SETTINGS = 14;
    static final int ROOT_UNKNOWN = 255;
    static final int ROOT_JNI_GLOBAL = 1;
    static final int ROOT_JNI_LOCAL = 2;
    static final int ROOT_JAVA_FRAME = 3;
    static final int ROOT_NATIVE_STACK = 4;
    static final int ROOT_STICKY_CLASS = 5;
    static final int ROOT_THREAD_BLOCK = 6;
    static final int ROOT_MONITOR_USED = 7;
    static final int ROOT_THREAD_OBJECT = 8;
    static final int CLASS_DUMP = 32;
    static final int INSTANCE_DUMP = 33;
    static final int OBJECT_ARRAY_DUMP = 34;
    static final int PRIMITIVE_ARRAY_DUMP = 35;
    static final int HEAP_DUMP_INFO = 254;
    static final int ROOT_INTERNED_STRING = 137;
    static final int ROOT_FINALIZING = 138;
    static final int ROOT_DEBUGGER = 139;
    static final int ROOT_REFERENCE_CLEANUP = 140;
    static final int ROOT_VM_INTERNAL = 141;
    static final int ROOT_JNI_MONITOR = 142;
    static final int UNREACHABLE = 144;
    static final int PRIMITIVE_ARRAY_NODATA_DUMP = 195;
    static final int OBJECT = 2;
    static final int BOOLEAN = 4;
    static final int CHAR = 5;
    static final int FLOAT = 6;
    static final int DOUBLE = 7;
    static final int BYTE = 8;
    static final int SHORT = 9;
    static final int INT = 10;
    static final int LONG = 11;
    private static final boolean DEBUG = false;
    private static final String SNAPSHOT_ID = "NBPHD";
    private static final int SNAPSHOT_VERSION = 2;
    HprofByteBuffer dumpBuffer;
    LongMap idToOffsetMap;
    private NearestGCRoot nearestGCRoot;
    final HprofGCRoots gcRoots;
    private ComputedSummary computedSummary;
    private final Object computedSummaryLock = new Object();
    private DominatorTree domTree;
    private TagBounds allInstanceDumpBounds;
    private TagBounds heapDumpSegment;
    private TagBounds[] heapTagBounds;
    private TagBounds[] tagBounds = new TagBounds[255];
    private boolean instancesCountComputed;
    private final Object instancesCountLock = new Object();
    private boolean referencesComputed;
    private final Object referencesLock = new Object();
    private boolean retainedSizeComputed;
    private final Object retainedSizeLock = new Object();
    private boolean retainedSizeByClassComputed;
    private final Object retainedSizeByClassLock = new Object();
    private int idMapSize;
    private int segment;
    File heapDumpFile;
    CacheDirectory cacheDirectory;

    HprofHeap(File file, int n, CacheDirectory cacheDirectory) throws FileNotFoundException, IOException {
        this.cacheDirectory = cacheDirectory;
        this.dumpBuffer = HprofByteBuffer.createHprofByteBuffer(file);
        this.segment = n;
        this.fillTagBounds(this.dumpBuffer.getHeaderSize());
        this.heapDumpSegment = this.computeHeapDumpStart();
        if (this.heapDumpSegment != null) {
            this.fillHeapTagBounds();
        }
        this.idToOffsetMap = new LongMap(this.idMapSize, this.dumpBuffer.getIDSize(), this.dumpBuffer.getFoffsetSize(), this.cacheDirectory);
        this.nearestGCRoot = new NearestGCRoot(this);
        this.gcRoots = new HprofGCRoots(this);
        this.heapDumpFile = file;
    }

    @Override
    public List getAllClasses() {
        if (this.heapDumpSegment == null) {
            return Collections.EMPTY_LIST;
        }
        ClassDumpSegment classDumpSegment = this.getClassDumpSegment();
        if (classDumpSegment == null) {
            return Collections.EMPTY_LIST;
        }
        return classDumpSegment.createClassCollection();
    }

    @Override
    public List getBiggestObjectsByRetainedSize(int n) {
        ArrayList<Instance> arrayList = new ArrayList<Instance>(n);
        this.computeRetainedSize();
        long[] lArray = this.idToOffsetMap.getBiggestObjectsByRetainedSize(n);
        for (int i = 0; i < lArray.length; ++i) {
            arrayList.add(this.getInstanceByID(lArray[i]));
        }
        return arrayList;
    }

    @Override
    public GCRoot getGCRoot(Instance instance) {
        Long l = instance.getInstanceId();
        return this.gcRoots.getGCRoot(l);
    }

    @Override
    public Collection getGCRoots() {
        if (this.heapDumpSegment == null) {
            return Collections.EMPTY_LIST;
        }
        return this.gcRoots.getGCRoots();
    }

    @Override
    public Instance getInstanceByID(long l) {
        if (l == 0L) {
            return null;
        }
        this.computeInstances();
        LongMap.Entry entry = this.idToOffsetMap.get(l);
        if (entry == null) {
            return null;
        }
        return this.getInstanceByOffset(new long[]{entry.getOffset()});
    }

    @Override
    public JavaClass getJavaClassByID(long l) {
        return this.getClassDumpSegment().getClassDumpByID(l);
    }

    @Override
    public JavaClass getJavaClassByName(String string) {
        if (this.heapDumpSegment == null) {
            return null;
        }
        return this.getClassDumpSegment().getJavaClassByName(string);
    }

    @Override
    public Collection getJavaClassesByRegExp(String string) {
        if (this.heapDumpSegment == null) {
            return Collections.EMPTY_LIST;
        }
        return this.getClassDumpSegment().getJavaClassesByRegExp(string);
    }

    @Override
    public Iterator getAllInstancesIterator() {
        List list = this.getAllClasses();
        if (list.isEmpty()) {
            return Collections.EMPTY_LIST.iterator();
        }
        return new InstancesIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized HeapSummary getSummary() {
        TagBounds tagBounds = this.tagBounds[7];
        if (tagBounds != null) {
            return new Summary(this.dumpBuffer, tagBounds.startOffset);
        }
        Object object = this.computedSummaryLock;
        synchronized (object) {
            if (this.computedSummary == null) {
                this.computedSummary = new ComputedSummary(this);
            }
        }
        return this.computedSummary;
    }

    @Override
    public Properties getSystemProperties() {
        JavaClass javaClass = this.getJavaClassByName("java.lang.System");
        if (javaClass != null) {
            Instance instance = (Instance)javaClass.getValueOfStaticField("props");
            if (instance == null) {
                instance = (Instance)javaClass.getValueOfStaticField("systemProperties");
            }
            if (instance != null) {
                return HprofProxy.getProperties(instance);
            }
        }
        return null;
    }

    @Override
    public boolean isRetainedSizeComputed() {
        return this.retainedSizeComputed;
    }

    @Override
    public boolean isRetainedSizeByClassComputed() {
        return this.retainedSizeByClassComputed;
    }

    void writeToFile() {
        if (!this.cacheDirectory.isTemporary()) {
            try {
                File file = this.cacheDirectory.getHeapDumpAuxFile();
                DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file), 32768));
                this.writeToStream(dataOutputStream);
                dataOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        }
    }

    void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(SNAPSHOT_ID);
        dataOutputStream.writeInt(2);
        dataOutputStream.writeUTF(this.heapDumpFile.getAbsolutePath());
        this.nearestGCRoot.writeToStream(dataOutputStream);
        this.allInstanceDumpBounds.writeToStream(dataOutputStream);
        this.heapDumpSegment.writeToStream(dataOutputStream);
        TagBounds.writeToStream(this.heapTagBounds, dataOutputStream);
        TagBounds.writeToStream(this.tagBounds, dataOutputStream);
        dataOutputStream.writeBoolean(this.instancesCountComputed);
        dataOutputStream.writeBoolean(this.referencesComputed);
        dataOutputStream.writeBoolean(this.retainedSizeComputed);
        dataOutputStream.writeBoolean(this.retainedSizeByClassComputed);
        dataOutputStream.writeInt(this.idMapSize);
        dataOutputStream.writeInt(this.segment);
        this.idToOffsetMap.writeToStream(dataOutputStream);
        dataOutputStream.writeBoolean(this.domTree != null);
        if (this.domTree != null) {
            this.domTree.writeToStream(dataOutputStream);
        }
    }

    HprofHeap(DataInputStream dataInputStream, CacheDirectory cacheDirectory) throws IOException {
        String string = dataInputStream.readUTF();
        if (!SNAPSHOT_ID.equals(string)) {
            throw new IOException("Invalid HPROF dump id " + string);
        }
        int n = dataInputStream.readInt();
        if (n != 2) {
            throw new IOException("Invalid HPROF version 2 loaded " + n);
        }
        this.heapDumpFile = cacheDirectory.getHeapFile(dataInputStream.readUTF());
        this.cacheDirectory = cacheDirectory;
        this.dumpBuffer = HprofByteBuffer.createHprofByteBuffer(this.heapDumpFile);
        this.nearestGCRoot = new NearestGCRoot(this, dataInputStream);
        this.allInstanceDumpBounds = new TagBounds(dataInputStream);
        this.heapDumpSegment = new TagBounds(dataInputStream);
        this.heapTagBounds = new TagBounds[256];
        TagBounds.readFromStream(dataInputStream, this, this.heapTagBounds);
        TagBounds.readFromStream(dataInputStream, this, this.tagBounds);
        this.instancesCountComputed = dataInputStream.readBoolean();
        this.referencesComputed = dataInputStream.readBoolean();
        this.retainedSizeComputed = dataInputStream.readBoolean();
        this.retainedSizeByClassComputed = dataInputStream.readBoolean();
        this.idMapSize = dataInputStream.readInt();
        this.segment = dataInputStream.readInt();
        this.idToOffsetMap = new LongMap(dataInputStream, this.cacheDirectory);
        if (dataInputStream.readBoolean()) {
            this.domTree = new DominatorTree(this, dataInputStream);
        }
        this.gcRoots = new HprofGCRoots(this);
        this.getClassDumpSegment().extractSpecialClasses();
    }

    ClassDumpSegment getClassDumpSegment() {
        return (ClassDumpSegment)this.heapTagBounds[32];
    }

    LoadClassSegment getLoadClassSegment() {
        return (LoadClassSegment)this.tagBounds[2];
    }

    StringSegment getStringSegment() {
        return (StringSegment)this.tagBounds[1];
    }

    StackTraceSegment getStackTraceSegment() {
        return (StackTraceSegment)this.tagBounds[5];
    }

    StackFrameSegment getStackFrameSegment() {
        return (StackFrameSegment)this.tagBounds[4];
    }

    TagBounds getAllInstanceDumpBounds() {
        return this.allInstanceDumpBounds;
    }

    long getRetainedSize(Instance instance) {
        this.computeRetainedSize();
        return this.idToOffsetMap.get(instance.getInstanceId()).getRetainedSize();
    }

    int getValueSize(byte by) {
        switch (by) {
            case 2: {
                return this.dumpBuffer.getIDSize();
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 1;
            }
            case 9: {
                return 2;
            }
            case 10: {
                return 4;
            }
            case 11: {
                return 8;
            }
        }
        throw new IllegalArgumentException("Invalid type " + by);
    }

    Instance getInstanceByOffset(long[] lArray) {
        return this.getInstanceByOffset(lArray, null, -1L);
    }

    Instance getInstanceByOffset(long[] lArray, ClassDump classDump, long l) {
        long l2 = lArray[0];
        assert (l2 != 0L);
        ClassDumpSegment classDumpSegment = this.getClassDumpSegment();
        int n = this.dumpBuffer.getIDSize();
        int n2 = 0;
        int n3 = this.readDumpTag(lArray);
        if (n3 == 33) {
            n2 = n + 4;
        } else if (n3 == 34) {
            n2 = n + 4 + 4;
        } else if (n3 == 35) {
            n2 = n + 4 + 4;
        }
        if (n3 == 35) {
            ClassDump classDump2 = classDumpSegment.getPrimitiveArrayClass(this.dumpBuffer.get(l2 + 1L + (long)n2));
            if (l != -1L && classDump2.getJavaClassId() != l) {
                return null;
            }
            return new PrimitiveArrayDump(classDump2, l2);
        }
        long l3 = this.dumpBuffer.getID(l2 + 1L + (long)n2);
        if (l != -1L && l3 != l) {
            return null;
        }
        ClassDump classDump3 = classDump == null ? classDumpSegment.getClassDumpByID(l3) : classDump;
        if (classDump3 == null) {
            return null;
        }
        if (n3 == 33) {
            return new InstanceDump(classDump3, l2);
        }
        if (n3 == 34) {
            return new ObjectArrayDump(classDump3, l2);
        }
        if (n3 == 32) {
            return new ClassDumpInstance(classDump3);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeInstances() {
        Object object = this.instancesCountLock;
        synchronized (object) {
            if (this.instancesCountComputed) {
                return;
            }
            HeapProgress.progressStart();
            ClassDumpSegment classDumpSegment = this.getClassDumpSegment();
            int n = this.dumpBuffer.getIDSize();
            long[] lArray = new long[]{this.allInstanceDumpBounds.startOffset};
            Map map = classDumpSegment.getClassIdToClassMap();
            long l = 0L;
            while (lArray[0] < this.allInstanceDumpBounds.endOffset) {
                int n2 = 0;
                int n3 = 0;
                ClassDump classDump = null;
                long l2 = lArray[0];
                int n4 = this.readDumpTag(lArray);
                LongMap.Entry entry = null;
                if (n4 == 33) {
                    n3 = 1;
                    n2 = n + 4;
                } else if (n4 == 34) {
                    n3 = 1;
                    n2 = n + 4 + 4;
                } else if (n4 == 35) {
                    byte by = this.dumpBuffer.get(l2 + 1L + (long)n + 4L + 4L);
                    n3 = 1;
                    classDump = classDumpSegment.getPrimitiveArrayClass(by);
                }
                if (n3 != 0) {
                    long l3 = this.dumpBuffer.getID(l2 + (long)n3);
                    entry = this.idToOffsetMap.put(l3, l2);
                }
                if (n2 != 0) {
                    long l4 = this.dumpBuffer.getID(l2 + 1L + (long)n2);
                    classDump = (ClassDump)map.get(new Long(l4));
                }
                if (classDump != null) {
                    classDump.registerInstance(l2);
                    entry.setIndex(classDump.getInstancesCount());
                    classDumpSegment.addInstanceSize(classDump, n4, l2);
                }
                HeapProgress.progress(l, this.allInstanceDumpBounds.startOffset, l2, this.allInstanceDumpBounds.endOffset);
                ++l;
            }
            this.instancesCountComputed = true;
            this.writeToFile();
        }
        HeapProgress.progressFinish();
    }

    List findReferencesFor(long l) {
        assert (l != 0L) : "InstanceID is null";
        this.computeReferences();
        ArrayList<HprofObject> arrayList = new ArrayList<HprofObject>();
        LongIterator longIterator = this.idToOffsetMap.get(l).getReferences();
        int n = this.dumpBuffer.getIDSize();
        ClassDumpSegment classDumpSegment = this.getClassDumpSegment();
        long[] lArray = new long[1];
        while (longIterator.hasNext()) {
            long l2 = longIterator.next();
            lArray[0] = this.idToOffsetMap.get(l2).getOffset();
            long l3 = lArray[0];
            int n2 = this.readDumpTag(lArray);
            if (n2 == 33) {
                Object object2;
                int n3 = this.dumpBuffer.getInt(l3 + 1L + (long)n + 4L + (long)n);
                byte[] byArray = new byte[n3];
                this.dumpBuffer.get(l3 + 1L + (long)n + 4L + (long)n + 4L, byArray);
                long l4 = this.dumpBuffer.getID(l3 + 1L + (long)n + 4L);
                ClassDump classDump = classDumpSegment.getClassDumpByID(l4);
                InstanceDump instanceDump = new InstanceDump(classDump, l3);
                for (Object object2 : instanceDump.getFieldValues()) {
                    HprofInstanceObjectValue hprofInstanceObjectValue;
                    if (!(object2 instanceof HprofInstanceObjectValue) || (hprofInstanceObjectValue = (HprofInstanceObjectValue)object2).getInstanceId() != l) continue;
                    arrayList.add(hprofInstanceObjectValue);
                }
                if (!arrayList.isEmpty() || l4 != l) continue;
                object2 = new SyntheticClassField(classDump);
                long l5 = l3 + 1L + (long)this.dumpBuffer.getIDSize() + 4L;
                arrayList.add(new SyntheticClassObjectValue(instanceDump, (HprofField)object2, l5));
                continue;
            }
            if (n2 == 34) {
                int n4 = this.dumpBuffer.getInt(l3 + 1L + (long)n + 4L);
                long l6 = this.dumpBuffer.getID(l3 + 1L + (long)n + 4L + 4L);
                ClassDump classDump = classDumpSegment.getClassDumpByID(l6);
                long l7 = l3 + 1L + (long)n + 4L + 4L + (long)n;
                int n5 = 0;
                while (n5 < n4) {
                    if (this.dumpBuffer.getID(l7) == l) {
                        arrayList.add(new HprofArrayValue(classDump, l3, n5));
                    }
                    ++n5;
                    l7 += (long)n;
                }
                continue;
            }
            if (n2 != 32) continue;
            ClassDump classDump = classDumpSegment.getClassDumpByID(l2);
            classDump.findStaticReferencesFor(l, arrayList);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeReferences() {
        Object object = this.referencesLock;
        synchronized (object) {
            Object object2;
            long l;
            if (this.referencesComputed) {
                return;
            }
            HeapProgress.progressStart();
            ClassDumpSegment classDumpSegment = this.getClassDumpSegment();
            int n = this.dumpBuffer.getIDSize();
            long[] lArray = new long[]{this.allInstanceDumpBounds.startOffset};
            Map map = classDumpSegment.getClassIdToClassMap();
            this.computeInstances();
            long l2 = 0L;
            while (lArray[0] < this.allInstanceDumpBounds.endOffset) {
                Object object3;
                long l3;
                long l4 = lArray[0];
                int n2 = this.readDumpTag(lArray);
                if (n2 == 33) {
                    l = this.dumpBuffer.getID(l4 + 1L + (long)n + 4L);
                    object2 = (ClassDump)map.get(new Long(l));
                    l3 = this.dumpBuffer.getID(l4 + 1L);
                    long l5 = l4 + 1L + (long)n + 4L + (long)n + 4L;
                    List list = ((ClassDump)object2).getAllInstanceFields();
                    object3 = list.iterator();
                    while (object3.hasNext()) {
                        LongMap.Entry entry;
                        long l6;
                        HprofField hprofField = (HprofField)object3.next();
                        if (hprofField.getValueType() == 2 && (l6 = this.dumpBuffer.getID(l5)) != 0L && (entry = this.idToOffsetMap.get(l6)) != null) {
                            entry.addReference(l3);
                        }
                        l5 += (long)hprofField.getValueSize();
                    }
                } else if (n2 == 34) {
                    l = this.dumpBuffer.getID(l4 + 1L);
                    int n3 = this.dumpBuffer.getInt(l4 + 1L + (long)n + 4L);
                    l3 = l4 + 1L + (long)n + 4L + 4L + (long)n;
                    int n4 = 0;
                    while (n4 < n3) {
                        long l7 = this.dumpBuffer.getID(l3);
                        if (l7 != 0L && (object3 = this.idToOffsetMap.get(l7)) != null) {
                            ((LongMap.Entry)object3).addReference(l);
                        }
                        ++n4;
                        l3 += (long)n;
                    }
                }
                HeapProgress.progress(l2, this.allInstanceDumpBounds.startOffset, l4, this.allInstanceDumpBounds.endOffset);
                ++l2;
            }
            for (ClassDump classDump : this.getClassDumpSegment().createClassCollection()) {
                List list = classDump.getStaticFieldValues();
                for (Object e : list) {
                    if (!(e instanceof HprofFieldObjectValue) || (l = ((HprofFieldObjectValue)e).getInstanceID()) == 0L || (object2 = this.idToOffsetMap.get(l)) == null) continue;
                    ((LongMap.Entry)object2).addReference(classDump.getJavaClassId());
                }
            }
            this.idToOffsetMap.flush();
            this.referencesComputed = true;
            this.writeToFile();
        }
        HeapProgress.progressFinish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeRetainedSize() {
        Object object = this.retainedSizeLock;
        synchronized (object) {
            if (this.retainedSizeComputed) {
                return;
            }
            new TreeObject(this, this.nearestGCRoot.getLeaves()).computeTrees();
            this.domTree = new DominatorTree(this, this.nearestGCRoot.getMultipleParents());
            this.domTree.computeDominators();
            long[] lArray = new long[]{this.allInstanceDumpBounds.startOffset};
            while (lArray[0] < this.allInstanceDumpBounds.endOffset) {
                Object object2;
                long l;
                int n = 0;
                long l2 = lArray[0];
                int n2 = this.readDumpTag(lArray);
                if (n2 == 33) {
                    n = 1;
                } else if (n2 == 34) {
                    n = 1;
                } else {
                    if (n2 != 35) continue;
                    n = 1;
                }
                long l3 = this.dumpBuffer.getID(l2 + (long)n);
                LongMap.Entry entry = this.idToOffsetMap.get(l3);
                long l4 = this.domTree.getIdomId(l3, entry);
                boolean bl = entry.isTreeObj();
                long l5 = 0L;
                if (!(bl || entry.getNearestGCRootPointer() == 0L && this.gcRoots.getGCRoot(new Long(l3)) == null)) {
                    l = entry.getRetainedSize();
                    if (l < 0L) {
                        l = 0L;
                    }
                    l5 = (object2 = this.getInstanceByID(l3)) != null ? object2.getSize() : (long)this.getClassDumpSegment().getMinimumInstanceSize();
                    entry.setRetainedSize(l + l5);
                }
                if (l4 == 0L) continue;
                if (bl) {
                    l = entry.getRetainedSize();
                } else {
                    assert (l5 != 0L);
                    l = l5;
                }
                while (l4 != 0L && !((LongMap.Entry)(object2 = this.idToOffsetMap.get(l4))).isTreeObj()) {
                    long l6 = ((LongMap.Entry)object2).getRetainedSize();
                    if (l6 < 0L) {
                        l6 = 0L;
                    }
                    ((LongMap.Entry)object2).setRetainedSize(l6 + l);
                    l4 = this.domTree.getIdomId(l4, (LongMap.Entry)object2);
                }
            }
            this.retainedSizeComputed = true;
            this.writeToFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeRetainedSizeByClass() {
        Object object = this.retainedSizeByClassLock;
        synchronized (object) {
            if (this.retainedSizeByClassComputed) {
                return;
            }
            this.computeRetainedSize();
            long[] lArray = new long[]{this.allInstanceDumpBounds.startOffset};
            while (lArray[0] < this.allInstanceDumpBounds.endOffset) {
                ClassDump classDump;
                long l;
                Instance instance;
                int n = 0;
                long l2 = lArray[0];
                int n2 = this.readDumpTag(lArray);
                if (n2 == 33) {
                    n = 1;
                } else if (n2 == 34) {
                    n = 1;
                } else {
                    if (n2 != 35) continue;
                    n = 1;
                }
                if ((instance = this.getInstanceByID(l = this.dumpBuffer.getID(l2 + (long)n))) == null || (classDump = (ClassDump)instance.getJavaClass()) == null || this.domTree.hasInstanceInChain(n2, instance)) continue;
                classDump.addSizeForInstance(instance);
            }
            this.domTree = null;
            this.retainedSizeByClassComputed = true;
            this.writeToFile();
        }
    }

    Instance getNearestGCRootPointer(Instance instance) {
        return this.nearestGCRoot.getNearestGCRootPointer(instance);
    }

    int readDumpTag(long[] lArray) {
        long l = lArray[0];
        int n = this.dumpBuffer.get(l++) & 0xFF;
        long l2 = 0L;
        long l3 = l;
        int n2 = this.dumpBuffer.getIDSize();
        switch (n) {
            case -1: 
            case 255: {
                l2 = n2;
                n = 255;
                break;
            }
            case 1: {
                l2 = 2 * n2;
                break;
            }
            case 2: {
                l2 = n2 + 8;
                break;
            }
            case 3: {
                l2 = n2 + 8;
                break;
            }
            case 4: {
                l2 = n2 + 4;
                break;
            }
            case 5: {
                l2 = n2;
                break;
            }
            case 6: {
                l2 = n2 + 4;
                break;
            }
            case 7: {
                l2 = n2;
                break;
            }
            case 8: {
                l2 = n2 + 8;
                break;
            }
            case 32: {
                int n3 = n2 + 4 + 6 * n2 + 4;
                lArray[0] = l + (long)n3;
                int n4 = this.readConstantPool(lArray);
                int n5 = this.readStaticFields(lArray);
                int n6 = this.readInstanceFields(lArray);
                l2 = n3 + n4 + n5 + n6;
                break;
            }
            case 33: {
                int n7 = this.dumpBuffer.getInt(l + (long)n2 + 4L + (long)n2);
                l2 = n2 + 4 + n2 + 4 + n7;
                break;
            }
            case 34: {
                long l4 = this.dumpBuffer.getInt(l + (long)n2 + 4L);
                l2 = (long)(n2 + 4 + 4 + n2) + l4 * (long)n2;
                break;
            }
            case 35: {
                long l5 = this.dumpBuffer.getInt(l + (long)n2 + 4L);
                byte by = this.dumpBuffer.get(l + (long)n2 + 4L + 4L);
                l2 = (long)(n2 + 4 + 4 + 1) + l5 * (long)this.getValueSize(by);
                break;
            }
            case 28: {
                l2 = 8L;
                break;
            }
            case 254: {
                l2 = 4 + n2;
                break;
            }
            case 137: {
                l2 = n2;
                break;
            }
            case 138: {
                l2 = n2;
                break;
            }
            case 139: {
                l2 = n2;
                break;
            }
            case 140: {
                l2 = n2;
                break;
            }
            case 141: {
                l2 = n2;
                break;
            }
            case 142: {
                l2 = n2;
                break;
            }
            case 144: {
                l2 = n2;
                break;
            }
            case 195: {
                throw new IllegalArgumentException("Don't know how to load a nodata array");
            }
            default: {
                throw new IllegalArgumentException("Invalid dump tag " + n + " at position " + (l - 1L));
            }
        }
        lArray[0] = l3 + l2;
        return n;
    }

    int readTag(long[] lArray) {
        long l = lArray[0];
        byte by = this.dumpBuffer.get(l);
        long l2 = (long)this.dumpBuffer.getInt(l + 1L + 4L) & 0xFFFFFFFFL;
        lArray[0] = l2 == 0L && by != 44 && this.dumpBuffer.version != 3 ? -1L : l + 1L + 4L + 4L + l2;
        return by;
    }

    TagBounds getHeapTagBound(int n) {
        return this.heapTagBounds[n];
    }

    private TagBounds computeHeapDumpStart() throws IOException {
        TagBounds tagBounds = this.tagBounds[12];
        if (tagBounds != null) {
            long l = tagBounds.startOffset;
            long[] lArray = new long[]{l};
            int n = 0;
            while (n <= this.segment && l < tagBounds.endOffset) {
                int n2 = this.readTag(lArray);
                if (n2 == 12) {
                    if (n == this.segment) {
                        return new TagBounds(12, l, lArray[0]);
                    }
                    ++n;
                }
                l = lArray[0];
            }
            throw new IOException("Invalid segment " + this.segment);
        }
        TagBounds tagBounds2 = this.tagBounds[28];
        if (tagBounds2 != null) {
            long l = tagBounds2.startOffset;
            long l2 = tagBounds2.endOffset;
            return new TagBounds(12, l, l2);
        }
        return null;
    }

    private void fillHeapTagBounds() {
        if (this.heapTagBounds != null) {
            return;
        }
        HeapProgress.progressStart();
        this.heapTagBounds = new TagBounds[256];
        long[] lArray = new long[]{this.heapDumpSegment.startOffset + 1L + 4L + 4L};
        long l = 0L;
        while (lArray[0] < this.heapDumpSegment.endOffset) {
            long l2 = lArray[0];
            int n = this.readDumpTag(lArray);
            TagBounds tagBounds = this.heapTagBounds[n];
            long l3 = lArray[0];
            if (tagBounds == null) {
                TagBounds tagBounds2 = n == 32 ? new ClassDumpSegment(this, l2, l3) : new TagBounds(n, l2, l3);
                this.heapTagBounds[n] = tagBounds2;
            } else {
                tagBounds.endOffset = l3;
            }
            if (n == 32 || n == 33 || n == 34 || n == 35) {
                ++this.idMapSize;
            }
            HeapProgress.progress(l, this.heapDumpSegment.startOffset, l2, this.heapDumpSegment.endOffset);
            ++l;
        }
        TagBounds tagBounds = this.heapTagBounds[33];
        TagBounds tagBounds3 = this.heapTagBounds[34];
        TagBounds tagBounds4 = this.heapTagBounds[35];
        this.allInstanceDumpBounds = tagBounds.union(tagBounds3);
        this.allInstanceDumpBounds = this.allInstanceDumpBounds.union(tagBounds4);
        HeapProgress.progressFinish();
    }

    private void fillTagBounds(long l) throws IOException {
        long[] lArray = new long[]{l};
        while (lArray[0] < this.dumpBuffer.capacity()) {
            long l2 = lArray[0];
            int n = this.readTag(lArray);
            TagBounds tagBounds = this.tagBounds[n];
            long l3 = lArray[0];
            if (l3 == -1L) {
                throw new IOException("Heap dump is broken.\nTag 0x" + Integer.toHexString(n) + " at offset " + l2 + " has zero length.");
            }
            if (tagBounds == null) {
                TagBounds tagBounds2 = n == 2 ? new LoadClassSegment(this, l2, l3) : (n == 1 ? new StringSegment(this, l2, l3) : (n == 5 ? new StackTraceSegment(this, l2, l3) : (n == 4 ? new StackFrameSegment(this, l2, l3) : new TagBounds(n, l2, l3))));
                this.tagBounds[n] = tagBounds2;
                continue;
            }
            tagBounds.endOffset = l3;
        }
    }

    private int readConstantPool(long[] lArray) {
        long l = lArray[0];
        int n = this.dumpBuffer.getShort(l);
        lArray[0] = lArray[0] + 2L;
        for (int i = 0; i < n; ++i) {
            lArray[0] = lArray[0] + 2L;
            this.readValue(lArray);
        }
        return (int)(lArray[0] - l);
    }

    private int readInstanceFields(long[] lArray) {
        long l = lArray[0];
        short s = this.dumpBuffer.getShort(lArray[0]);
        lArray[0] = lArray[0] + 2L;
        lArray[0] = lArray[0] + (long)(s * (this.dumpBuffer.getIDSize() + 1));
        return (int)(lArray[0] - l);
    }

    private int readStaticFields(long[] lArray) {
        long l = lArray[0];
        int n = this.dumpBuffer.getShort(l);
        lArray[0] = lArray[0] + 2L;
        int n2 = this.dumpBuffer.getIDSize();
        for (int i = 0; i < n; ++i) {
            lArray[0] = lArray[0] + (long)n2;
            byte by = this.readValue(lArray);
        }
        return (int)(lArray[0] - l);
    }

    private byte readValue(long[] lArray) {
        long l = lArray[0];
        lArray[0] = l + 1L;
        byte by = this.dumpBuffer.get(l);
        lArray[0] = lArray[0] + (long)this.getValueSize(by);
        return by;
    }

    private class InstancesIterator
    implements Iterator {
        private long[] offset;
        private Instance nextInstance;

        private InstancesIterator() {
            this.offset = new long[]{((HprofHeap)HprofHeap.this).allInstanceDumpBounds.startOffset};
        }

        @Override
        public boolean hasNext() {
            while (this.offset[0] < ((HprofHeap)HprofHeap.this).allInstanceDumpBounds.endOffset && this.nextInstance == null) {
                this.nextInstance = HprofHeap.this.getInstanceByOffset(this.offset);
            }
            return this.nextInstance != null;
        }

        public Object next() {
            if (this.hasNext()) {
                Instance instance = this.nextInstance;
                this.nextInstance = null;
                return instance;
            }
            throw new NoSuchElementException();
        }
    }
}

