/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.sw.sse;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.HeapImage;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.state.BoxRenderState;
import com.sun.scenario.effect.impl.sw.sse.SSEEffectPeer;

public class SSEBoxShadowPeer
extends SSEEffectPeer<BoxRenderState> {
    public SSEBoxShadowPeer(FilterContext fctx, Renderer r, String uniqueName) {
        super(fctx, r, uniqueName);
    }

    @Override
    public ImageData filter(Effect effect, BoxRenderState brstate, BaseTransform transform, Rectangle outputClip, ImageData ... inputs) {
        boolean force;
        int vinc;
        this.setRenderState(brstate);
        boolean horizontal = this.getPass() == 0;
        int hinc = horizontal ? brstate.getBoxPixelSize(0) - 1 : 0;
        int n = vinc = horizontal ? 0 : brstate.getBoxPixelSize(1) - 1;
        if (hinc < 0) {
            hinc = 0;
        }
        if (vinc < 0) {
            vinc = 0;
        }
        int iterations = brstate.getBlurPasses();
        float spread = brstate.getSpread();
        if (horizontal && (iterations < 1 || hinc < 1 && vinc < 1)) {
            inputs[0].addref();
            return inputs[0];
        }
        int growx = hinc * iterations + 1 & 0xFFFFFFFE;
        int growy = vinc * iterations + 1 & 0xFFFFFFFE;
        HeapImage src = (HeapImage)inputs[0].getUntransformedImage();
        Rectangle srcr = inputs[0].getUntransformedBounds();
        HeapImage cur = src;
        int curw = srcr.width;
        int curh = srcr.height;
        int curscan = cur.getScanlineStride();
        int[] curPixels = cur.getPixelArray();
        int finalw = curw + growx;
        int finalh = curh + growy;
        boolean bl = force = !horizontal;
        while (force || curw < finalw || curh < finalh) {
            int neww = curw + hinc;
            int newh = curh + vinc;
            if (neww > finalw) {
                neww = finalw;
            }
            if (newh > finalh) {
                newh = finalh;
            }
            HeapImage dst = (HeapImage)((Object)this.getRenderer().getCompatibleImage(neww, newh));
            int newscan = dst.getScanlineStride();
            int[] newPixels = dst.getPixelArray();
            if (iterations == 0) {
                spread = 0.0f;
            }
            if (horizontal) {
                SSEBoxShadowPeer.filterHorizontalBlack(newPixels, neww, newh, newscan, curPixels, curw, curh, curscan, spread);
            } else if (neww < finalw || newh < finalh) {
                SSEBoxShadowPeer.filterVerticalBlack(newPixels, neww, newh, newscan, curPixels, curw, curh, curscan, spread);
            } else {
                float[] shadowColor = brstate.getShadowColor().getPremultipliedRGBComponents();
                if (shadowColor[3] == 1.0f && shadowColor[0] == 0.0f && shadowColor[1] == 0.0f && shadowColor[2] == 0.0f) {
                    SSEBoxShadowPeer.filterVerticalBlack(newPixels, neww, newh, newscan, curPixels, curw, curh, curscan, spread);
                } else {
                    SSEBoxShadowPeer.filterVertical(newPixels, neww, newh, newscan, curPixels, curw, curh, curscan, spread, shadowColor);
                }
            }
            if (cur != src) {
                this.getRenderer().releaseCompatibleImage(cur);
            }
            --iterations;
            force = false;
            cur = dst;
            curw = neww;
            curh = newh;
            curPixels = newPixels;
            curscan = newscan;
        }
        Rectangle dstBounds = new Rectangle(srcr.x - growx / 2, srcr.y - growy / 2, curw, curh);
        return new ImageData(this.getFilterContext(), cur, dstBounds, inputs[0].getTransform());
    }

    private static native void filterHorizontalBlack(int[] var0, int var1, int var2, int var3, int[] var4, int var5, int var6, int var7, float var8);

    private static native void filterVerticalBlack(int[] var0, int var1, int var2, int var3, int[] var4, int var5, int var6, int var7, float var8);

    private static native void filterVertical(int[] var0, int var1, int var2, int var3, int[] var4, int var5, int var6, int var7, float var8, float[] var9);
}

