/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.sw;

import com.sun.glass.ui.Screen;
import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.Glyph;
import com.sun.javafx.font.Metrics;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.geom.Ellipse2D;
import com.sun.javafx.geom.Line2D;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.RoundRectangle2D;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.javafx.scene.text.GlyphList;
import com.sun.javafx.sg.prism.NGCamera;
import com.sun.javafx.sg.prism.NGLightBase;
import com.sun.javafx.sg.prism.NodePath;
import com.sun.pisces.PiscesRenderer;
import com.sun.pisces.Transform6;
import com.sun.prism.BasicStroke;
import com.sun.prism.CompositeMode;
import com.sun.prism.Graphics;
import com.sun.prism.PixelFormat;
import com.sun.prism.RTTexture;
import com.sun.prism.ReadbackGraphics;
import com.sun.prism.RenderTarget;
import com.sun.prism.Texture;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.ImagePattern;
import com.sun.prism.paint.Paint;
import com.sun.prism.sw.SWArgbPreTexture;
import com.sun.prism.sw.SWContext;
import com.sun.prism.sw.SWPaint;
import com.sun.prism.sw.SWRTTexture;
import com.sun.prism.sw.SWResourceFactory;
import com.sun.prism.sw.SWUtils;

final class SWGraphics
implements ReadbackGraphics {
    private static final BasicStroke DEFAULT_STROKE = new BasicStroke(1.0f, 2, 0, 10.0f);
    private static final Paint DEFAULT_PAINT = Color.WHITE;
    private final PiscesRenderer pr;
    private final SWContext context;
    private final SWRTTexture target;
    private final SWPaint swPaint;
    private final BaseTransform tx = new Affine2D();
    private CompositeMode compositeMode = CompositeMode.SRC_OVER;
    private Rectangle clip;
    private final Rectangle finalClip = new Rectangle();
    private RectBounds nodeBounds;
    private int clipRectIndex;
    private Paint paint = DEFAULT_PAINT;
    private BasicStroke stroke = DEFAULT_STROKE;
    private Ellipse2D ellipse2d;
    private Line2D line2d;
    private RoundRectangle2D rect2d;
    private boolean antialiasedShape = true;
    private boolean hasPreCullingBits = false;
    private float pixelScale = 1.0f;
    private NodePath renderRoot;

    @Override
    public void setRenderRoot(NodePath root) {
        this.renderRoot = root;
    }

    @Override
    public NodePath getRenderRoot() {
        return this.renderRoot;
    }

    public SWGraphics(SWRTTexture target, SWContext context, PiscesRenderer pr) {
        this.target = target;
        this.context = context;
        this.pr = pr;
        this.swPaint = new SWPaint(context, pr);
        this.setClipRect(null);
    }

    @Override
    public RenderTarget getRenderTarget() {
        return this.target;
    }

    @Override
    public SWResourceFactory getResourceFactory() {
        return this.target.getResourceFactory();
    }

    @Override
    public Screen getAssociatedScreen() {
        return this.target.getAssociatedScreen();
    }

    @Override
    public void sync() {
    }

    @Override
    public BaseTransform getTransformNoClone() {
        if (PrismSettings.debug) {
            System.out.println("+ getTransformNoClone " + this + "; tr: " + this.tx);
        }
        return this.tx;
    }

    @Override
    public void setTransform(BaseTransform xform) {
        if (xform == null) {
            xform = BaseTransform.IDENTITY_TRANSFORM;
        }
        if (PrismSettings.debug) {
            System.out.println("+ setTransform " + this + "; tr: " + xform);
        }
        this.tx.setTransform(xform);
    }

    @Override
    public void setTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.tx.restoreTransform(m00, m10, m01, m11, m02, m12);
        if (PrismSettings.debug) {
            System.out.println("+ restoreTransform " + this + "; tr: " + this.tx);
        }
    }

    @Override
    public void setTransform3D(double mxx, double mxy, double mxz, double mxt, double myx, double myy, double myz, double myt, double mzx, double mzy, double mzz, double mzt) {
        if (mxz != 0.0 || myz != 0.0 || mzx != 0.0 || mzy != 0.0 || mzz != 1.0 || mzt != 0.0) {
            throw new UnsupportedOperationException("3D transforms not supported.");
        }
        this.setTransform(mxx, myx, mxy, myy, mxt, myt);
    }

    @Override
    public void transform(BaseTransform xform) {
        if (PrismSettings.debug) {
            System.out.println("+ concatTransform " + this + "; tr: " + xform);
        }
        this.tx.deriveWithConcatenation(xform);
    }

    @Override
    public void translate(float tx, float ty) {
        if (PrismSettings.debug) {
            System.out.println("+ concat translate " + this + "; tx: " + tx + "; ty: " + ty);
        }
        this.tx.deriveWithTranslation(tx, ty);
    }

    @Override
    public void translate(float tx, float ty, float tz) {
        throw new UnsupportedOperationException("translate3D: unimp");
    }

    @Override
    public void scale(float sx, float sy) {
        if (PrismSettings.debug) {
            System.out.println("+ concat scale " + this + "; sx: " + sx + "; sy: " + sy);
        }
        this.tx.deriveWithConcatenation(sx, 0.0, 0.0, sy, 0.0, 0.0);
    }

    @Override
    public void scale(float sx, float sy, float sz) {
        throw new UnsupportedOperationException("scale3D: unimp");
    }

    @Override
    public void setCamera(NGCamera camera) {
    }

    @Override
    public NGCamera getCameraNoClone() {
        throw new UnsupportedOperationException("getCameraNoClone: unimp");
    }

    @Override
    public void setDepthTest(boolean depthTest) {
    }

    @Override
    public boolean isDepthTest() {
        return false;
    }

    @Override
    public void setDepthBuffer(boolean depthBuffer) {
    }

    @Override
    public boolean isDepthBuffer() {
        return false;
    }

    @Override
    public boolean isAlphaTestShader() {
        if (PrismSettings.verbose && PrismSettings.forceAlphaTestShader) {
            System.out.println("SW pipe doesn't support shader with alpha testing");
        }
        return false;
    }

    @Override
    public void setAntialiasedShape(boolean aa) {
        this.antialiasedShape = aa;
    }

    @Override
    public boolean isAntialiasedShape() {
        return this.antialiasedShape;
    }

    @Override
    public Rectangle getClipRect() {
        return this.clip == null ? null : new Rectangle(this.clip);
    }

    @Override
    public Rectangle getClipRectNoClone() {
        return this.clip;
    }

    @Override
    public RectBounds getFinalClipNoClone() {
        return this.finalClip.toRectBounds();
    }

    @Override
    public void setClipRect(Rectangle clipRect) {
        this.finalClip.setBounds(this.target.getDimensions());
        if (clipRect == null) {
            if (PrismSettings.debug) {
                System.out.println("+ PR.resetClip");
            }
            this.clip = null;
        } else {
            if (PrismSettings.debug) {
                System.out.println("+ PR.setClip: " + clipRect);
            }
            this.finalClip.intersectWith(clipRect);
            this.clip = new Rectangle(clipRect);
        }
        this.pr.setClip(this.finalClip.x, this.finalClip.y, this.finalClip.width, this.finalClip.height);
    }

    @Override
    public void setHasPreCullingBits(boolean hasBits) {
        this.hasPreCullingBits = hasBits;
    }

    @Override
    public boolean hasPreCullingBits() {
        return this.hasPreCullingBits;
    }

    @Override
    public int getClipRectIndex() {
        return this.clipRectIndex;
    }

    @Override
    public void setClipRectIndex(int index) {
        if (PrismSettings.debug) {
            System.out.println("+ PR.setClipRectIndex: " + index);
        }
        this.clipRectIndex = index;
    }

    @Override
    public float getExtraAlpha() {
        return this.swPaint.getCompositeAlpha();
    }

    @Override
    public void setExtraAlpha(float extraAlpha) {
        if (PrismSettings.debug) {
            System.out.println("PR.setCompositeAlpha, value: " + extraAlpha);
        }
        this.swPaint.setCompositeAlpha(extraAlpha);
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    @Override
    public BasicStroke getStroke() {
        return this.stroke;
    }

    @Override
    public void setStroke(BasicStroke stroke) {
        this.stroke = stroke;
    }

    @Override
    public CompositeMode getCompositeMode() {
        return this.compositeMode;
    }

    @Override
    public void setCompositeMode(CompositeMode mode) {
        int piscesComp;
        this.compositeMode = mode;
        switch (mode) {
            case CLEAR: {
                piscesComp = 0;
                if (!PrismSettings.debug) break;
                System.out.println("PR.setCompositeRule - CLEAR");
                break;
            }
            case SRC: {
                piscesComp = 1;
                if (!PrismSettings.debug) break;
                System.out.println("PR.setCompositeRule - SRC");
                break;
            }
            case SRC_OVER: {
                piscesComp = 2;
                if (!PrismSettings.debug) break;
                System.out.println("PR.setCompositeRule - SRC_OVER");
                break;
            }
            default: {
                throw new InternalError("Unrecognized composite mode: " + (Object)((Object)mode));
            }
        }
        this.pr.setCompositeRule(piscesComp);
    }

    @Override
    public void setNodeBounds(RectBounds bounds) {
        if (PrismSettings.debug) {
            System.out.println("+ SWG.setNodeBounds: " + bounds);
        }
        this.nodeBounds = bounds;
    }

    @Override
    public void clear() {
        this.clear(Color.TRANSPARENT);
    }

    @Override
    public void clear(Color color) {
        if (PrismSettings.debug) {
            System.out.println("+ PR.clear: " + color);
        }
        this.swPaint.setColor(color, 1.0f);
        this.pr.clearRect(0, 0, this.target.getPhysicalWidth(), this.target.getPhysicalHeight());
        this.getRenderTarget().setOpaque(color.isOpaque());
    }

    @Override
    public void clearQuad(float x1, float y1, float x2, float y2) {
        CompositeMode cm = this.compositeMode;
        Paint p = this.paint;
        this.setCompositeMode(CompositeMode.SRC);
        this.setPaint(Color.TRANSPARENT);
        this.fillQuad(x1, y1, x2, y2);
        this.setCompositeMode(cm);
        this.setPaint(p);
    }

    @Override
    public void fill(Shape shape) {
        if (PrismSettings.debug) {
            System.out.println("+ fill(Shape)");
        }
        this.paintShape(shape, null, this.tx);
    }

    @Override
    public void fillQuad(float x1, float y1, float x2, float y2) {
        if (PrismSettings.debug) {
            System.out.println("+ SWG.fillQuad");
        }
        this.fillRect(Math.min(x1, x2), Math.min(y1, y2), Math.abs(x2 - x1), Math.abs(y2 - y1));
    }

    @Override
    public void fillRect(float x, float y, float width, float height) {
        if (PrismSettings.debug) {
            System.out.printf("+ SWG.fillRect, x: %f, y: %f, w: %f, h: %f\n", Float.valueOf(x), Float.valueOf(y), Float.valueOf(width), Float.valueOf(height));
        }
        if (this.tx.getMxy() == 0.0 && this.tx.getMyx() == 0.0) {
            if (PrismSettings.debug) {
                System.out.println("GR: " + this);
                System.out.println("target: " + this.target + " t.w: " + this.target.getPhysicalWidth() + ", t.h: " + this.target.getPhysicalHeight() + ", t.dims: " + this.target.getDimensions());
                System.out.println("Tx: " + this.tx);
                System.out.println("Clip: " + this.finalClip);
                System.out.println("Composite rule: " + (Object)((Object)this.compositeMode));
            }
            Point2D p1 = new Point2D(x, y);
            Point2D p2 = new Point2D(x + width, y + height);
            this.tx.transform(p1, p1);
            this.tx.transform(p2, p2);
            if (this.paint.getType() == Paint.Type.IMAGE_PATTERN) {
                int imageMode;
                ImagePattern ip = (ImagePattern)this.paint;
                if (ip.getImage().getPixelFormat() == PixelFormat.BYTE_ALPHA) {
                    throw new UnsupportedOperationException("Alpha image is not supported as an image pattern.");
                }
                Transform6 piscesTx = this.swPaint.computeSetTexturePaintTransform(this.paint, this.tx, this.nodeBounds, x, y, width, height);
                SWArgbPreTexture tex = this.context.validateImagePaintTexture(ip.getImage().getWidth(), ip.getImage().getHeight());
                tex.update(ip.getImage());
                float compositeAlpha = this.swPaint.getCompositeAlpha();
                if (compositeAlpha == 1.0f) {
                    imageMode = 1;
                } else {
                    imageMode = 2;
                    this.pr.setColor(255, 255, 255, (int)(255.0f * compositeAlpha));
                }
                this.pr.drawImage(1, imageMode, tex.getDataNoClone(), tex.getContentWidth(), tex.getContentHeight(), tex.getOffset(), tex.getPhysicalWidth(), piscesTx, tex.getWrapMode() == Texture.WrapMode.REPEAT, (int)(Math.min(p1.x, p2.x) * 65536.0f), (int)(Math.min(p1.y, p2.y) * 65536.0f), (int)(Math.abs(p2.x - p1.x) * 65536.0f), (int)(Math.abs(p2.y - p1.y) * 65536.0f), 0, 0, 0, 0, 0, 0, tex.getContentWidth() - 1, tex.getContentHeight() - 1, tex.hasAlpha());
            } else {
                this.swPaint.setPaintFromShape(this.paint, this.tx, null, this.nodeBounds, x, y, width, height);
                this.pr.fillRect((int)(Math.min(p1.x, p2.x) * 65536.0f), (int)(Math.min(p1.y, p2.y) * 65536.0f), (int)(Math.abs(p2.x - p1.x) * 65536.0f), (int)(Math.abs(p2.y - p1.y) * 65536.0f));
            }
        } else {
            this.fillRoundRect(x, y, width, height, 0.0f, 0.0f);
        }
    }

    @Override
    public void fillRoundRect(float x, float y, float width, float height, float arcw, float arch) {
        if (PrismSettings.debug) {
            System.out.println("+ SWG.fillRoundRect");
        }
        this.paintRoundRect(x, y, width, height, arcw, arch, null);
    }

    @Override
    public void fillEllipse(float x, float y, float width, float height) {
        if (PrismSettings.debug) {
            System.out.println("+ SWG.fillEllipse");
        }
        this.paintEllipse(x, y, width, height, null);
    }

    @Override
    public void draw(Shape shape) {
        if (PrismSettings.debug) {
            System.out.println("+ draw(Shape)");
        }
        this.paintShape(shape, this.stroke, this.tx);
    }

    private void paintShape(Shape shape, BasicStroke st, BaseTransform tr) {
        if (this.finalClip.isEmpty()) {
            if (PrismSettings.debug) {
                System.out.println("Final clip is empty: not rendering the shape: " + shape);
            }
            return;
        }
        this.swPaint.setPaintFromShape(this.paint, this.tx, shape, this.nodeBounds, 0.0f, 0.0f, 0.0f, 0.0f);
        this.paintShapePaintAlreadySet(shape, st, tr);
    }

    private void paintShapePaintAlreadySet(Shape shape, BasicStroke st, BaseTransform tr) {
        if (this.finalClip.isEmpty()) {
            if (PrismSettings.debug) {
                System.out.println("Final clip is empty: not rendering the shape: " + shape);
            }
            return;
        }
        if (PrismSettings.debug) {
            System.out.println("GR: " + this);
            System.out.println("target: " + this.target + " t.w: " + this.target.getPhysicalWidth() + ", t.h: " + this.target.getPhysicalHeight() + ", t.dims: " + this.target.getDimensions());
            System.out.println("Shape: " + shape);
            System.out.println("Stroke: " + st);
            System.out.println("Tx: " + tr);
            System.out.println("Clip: " + this.finalClip);
            System.out.println("Composite rule: " + (Object)((Object)this.compositeMode));
        }
        this.context.renderShape(this.pr, shape, st, tr, this.finalClip, this.isAntialiasedShape());
    }

    private void paintRoundRect(float x, float y, float width, float height, float arcw, float arch, BasicStroke st) {
        if (this.rect2d == null) {
            this.rect2d = new RoundRectangle2D(x, y, width, height, arcw, arch);
        } else {
            this.rect2d.setRoundRect(x, y, width, height, arcw, arch);
        }
        this.paintShape(this.rect2d, st, this.tx);
    }

    private void paintEllipse(float x, float y, float width, float height, BasicStroke st) {
        if (this.ellipse2d == null) {
            this.ellipse2d = new Ellipse2D(x, y, width, height);
        } else {
            this.ellipse2d.setFrame(x, y, width, height);
        }
        this.paintShape(this.ellipse2d, st, this.tx);
    }

    @Override
    public void drawLine(float x1, float y1, float x2, float y2) {
        if (PrismSettings.debug) {
            System.out.println("+ drawLine");
        }
        if (this.line2d == null) {
            this.line2d = new Line2D(x1, y1, x2, y2);
        } else {
            this.line2d.setLine(x1, y1, x2, y2);
        }
        this.paintShape(this.line2d, this.stroke, this.tx);
    }

    @Override
    public void drawRect(float x, float y, float width, float height) {
        if (PrismSettings.debug) {
            System.out.println("+ SWG.drawRect");
        }
        this.drawRoundRect(x, y, width, height, 0.0f, 0.0f);
    }

    @Override
    public void drawRoundRect(float x, float y, float width, float height, float arcw, float arch) {
        if (PrismSettings.debug) {
            System.out.println("+ SWG.drawRoundRect");
        }
        this.paintRoundRect(x, y, width, height, arcw, arch, this.stroke);
    }

    @Override
    public void drawEllipse(float x, float y, float width, float height) {
        if (PrismSettings.debug) {
            System.out.println("+ SWG.drawEllipse");
        }
        this.paintEllipse(x, y, width, height, this.stroke);
    }

    @Override
    public void drawString(GlyphList gl, FontStrike strike, float x, float y, Color selectColor, int selectStart, int selectEnd) {
        float bh;
        float bw;
        float by;
        float bx;
        if (PrismSettings.debug) {
            System.out.println("+ SWG.drawGlyphList, gl.Count: " + gl.getGlyphCount() + ", x: " + x + ", y: " + y + ", selectStart: " + selectStart + ", selectEnd: " + selectEnd);
        }
        if (this.paint.isProportional()) {
            if (this.nodeBounds != null) {
                bx = this.nodeBounds.getMinX();
                by = this.nodeBounds.getMinY();
                bw = this.nodeBounds.getWidth();
                bh = this.nodeBounds.getHeight();
            } else {
                Metrics m = strike.getMetrics();
                bx = 0.0f;
                by = m.getAscent();
                bw = gl.getWidth();
                bh = m.getLineHeight();
            }
        } else {
            bh = 0.0f;
            bw = 0.0f;
            by = 0.0f;
            bx = 0.0f;
        }
        boolean drawAsMasks = this.tx.isTranslateOrIdentity() && !strike.drawAsShapes();
        boolean doLCDText = drawAsMasks && strike.getAAMode() == 1 && this.getRenderTarget().isOpaque() && this.paint.getType() == Paint.Type.COLOR && this.tx.is2D();
        Affine2D glyphTx = null;
        if (doLCDText) {
            this.pr.setLCDGammaCorrection(1.0f / PrismFontFactory.getLCDContrast());
        } else if (drawAsMasks) {
            FontResource fr = strike.getFontResource();
            float origSize = strike.getSize();
            BaseTransform origTx = strike.getTransform();
            strike = fr.getStrike(origSize, origTx, 0);
        } else {
            glyphTx = new Affine2D();
        }
        if (selectColor == null) {
            this.swPaint.setPaintBeforeDraw(this.paint, this.tx, bx, by, bw, bh);
            for (int i = 0; i < gl.getGlyphCount(); ++i) {
                this.drawGlyph(strike, gl, i, glyphTx, drawAsMasks, x, y);
            }
        } else {
            for (int i = 0; i < gl.getGlyphCount(); ++i) {
                int offset = gl.getCharOffset(i);
                boolean selected = selectStart <= offset && offset < selectEnd;
                this.swPaint.setPaintBeforeDraw(selected ? selectColor : this.paint, this.tx, bx, by, bw, bh);
                this.drawGlyph(strike, gl, i, glyphTx, drawAsMasks, x, y);
            }
        }
    }

    private void drawGlyph(FontStrike strike, GlyphList gl, int idx, BaseTransform glyphTx, boolean drawAsMasks, float x, float y) {
        Glyph g = strike.getGlyph(gl.getGlyphCode(idx));
        if (drawAsMasks) {
            Point2D pt = new Point2D((float)((double)x + this.tx.getMxt() + (double)gl.getPosX(idx)), (float)((double)y + this.tx.getMyt() + (double)gl.getPosY(idx)));
            int subPixel = strike.getQuantizedPosition(pt);
            byte[] pixelData = g.getPixelData(subPixel);
            if (pixelData != null) {
                int intPosX = g.getOriginX() + (int)pt.x;
                int intPosY = g.getOriginY() + (int)pt.y;
                if (g.isLCDGlyph()) {
                    this.pr.fillLCDAlphaMask(pixelData, intPosX, intPosY, g.getWidth(), g.getHeight(), 0, g.getWidth());
                } else {
                    this.pr.fillAlphaMask(pixelData, intPosX, intPosY, g.getWidth(), g.getHeight(), 0, g.getWidth());
                }
            }
        } else {
            Shape shape = g.getShape();
            if (shape != null) {
                glyphTx.setTransform(this.tx);
                glyphTx.deriveWithTranslation(x + gl.getPosX(idx), y + gl.getPosY(idx));
                this.paintShapePaintAlreadySet(shape, null, glyphTx);
            }
        }
    }

    @Override
    public void drawTexture(Texture tex, float x, float y, float w, float h) {
        if (PrismSettings.debug) {
            System.out.printf("+ drawTexture1, x: %f, y: %f, w: %f, h: %f\n", Float.valueOf(x), Float.valueOf(y), Float.valueOf(w), Float.valueOf(h));
        }
        this.drawTexture(tex, x, y, x + w, y + h, 0.0f, 0.0f, w, h);
    }

    @Override
    public void drawTexture(Texture tex, float dx1, float dy1, float dx2, float dy2, float sx1, float sy1, float sx2, float sy2) {
        this.drawTexture(tex, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, 0, 0, 0, 0);
    }

    private void drawTexture(Texture tex, float dx1, float dy1, float dx2, float dy2, float sx1, float sy1, float sx2, float sy2, int lEdge, int rEdge, int tEdge, int bEdge) {
        int imageMode;
        float compositeAlpha = this.swPaint.getCompositeAlpha();
        if (compositeAlpha == 1.0f) {
            imageMode = 1;
        } else {
            imageMode = 2;
            this.pr.setColor(255, 255, 255, (int)(255.0f * compositeAlpha));
        }
        this.drawTexture(tex, imageMode, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, lEdge, rEdge, tEdge, bEdge);
    }

    private void drawTexture(Texture tex, int imageMode, float dx1, float dy1, float dx2, float dy2, float sx1, float sy1, float sx2, float sy2, int lEdge, int rEdge, int tEdge, int bEdge) {
        if (PrismSettings.debug) {
            System.out.println("+ drawTexture: " + tex + ", imageMode: " + imageMode + ", tex.w: " + tex.getPhysicalWidth() + ", tex.h: " + tex.getPhysicalHeight() + ", tex.cw: " + tex.getContentWidth() + ", tex.ch: " + tex.getContentHeight());
            System.out.println("target: " + this.target + " t.w: " + this.target.getPhysicalWidth() + ", t.h: " + this.target.getPhysicalHeight() + ", t.dims: " + this.target.getDimensions());
            System.out.println("GR: " + this);
            System.out.println("dx1:" + dx1 + " dy1:" + dy1 + " dx2:" + dx2 + " dy2:" + dy2);
            System.out.println("sx1:" + sx1 + " sy1:" + sy1 + " sx2:" + sx2 + " sy2:" + sy2);
            System.out.println("Clip: " + this.finalClip);
            System.out.println("Composite rule: " + (Object)((Object)this.compositeMode));
        }
        SWArgbPreTexture swTex = (SWArgbPreTexture)tex;
        int[] data = swTex.getDataNoClone();
        RectBounds srcBBox = new RectBounds(Math.min(dx1, dx2), Math.min(dy1, dy2), Math.max(dx1, dx2), Math.max(dy1, dy2));
        RectBounds dstBBox = new RectBounds();
        this.tx.transform(srcBBox, dstBBox);
        Transform6 piscesTx = this.swPaint.computeDrawTexturePaintTransform(this.tx, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2);
        if (PrismSettings.debug) {
            System.out.println("tx: " + this.tx);
            System.out.println("piscesTx: " + piscesTx);
            System.out.println("srcBBox: " + srcBBox);
            System.out.println("dstBBox: " + dstBBox);
        }
        int txMin = Math.max(0, SWUtils.fastFloor(Math.min(sx1, sx2)));
        int tyMin = Math.max(0, SWUtils.fastFloor(Math.min(sy1, sy2)));
        int txMax = Math.min(tex.getContentWidth() - 1, SWUtils.fastCeil(Math.max(sx1, sx2)) - 1);
        int tyMax = Math.min(tex.getContentHeight() - 1, SWUtils.fastCeil(Math.max(sy1, sy2)) - 1);
        this.pr.drawImage(1, imageMode, data, tex.getContentWidth(), tex.getContentHeight(), swTex.getOffset(), tex.getPhysicalWidth(), piscesTx, tex.getWrapMode() == Texture.WrapMode.REPEAT, (int)(65536.0f * dstBBox.getMinX()), (int)(65536.0f * dstBBox.getMinY()), (int)(65536.0f * dstBBox.getWidth()), (int)(65536.0f * dstBBox.getHeight()), lEdge, rEdge, tEdge, bEdge, txMin, tyMin, txMax, tyMax, swTex.hasAlpha());
        if (PrismSettings.debug) {
            System.out.println("* drawTexture, DONE");
        }
    }

    @Override
    public void drawTexture3SliceH(Texture tex, float dx1, float dy1, float dx2, float dy2, float sx1, float sy1, float sx2, float sy2, float dh1, float dh2, float sh1, float sh2) {
        this.drawTexture(tex, dx1, dy1, dh1, dy2, sx1, sy1, sh1, sy2, 0, 1, 0, 0);
        this.drawTexture(tex, dh1, dy1, dh2, dy2, sh1, sy1, sh2, sy2, 2, 1, 0, 0);
        this.drawTexture(tex, dh2, dy1, dx2, dy2, sh2, sy1, sx2, sy2, 2, 0, 0, 0);
    }

    @Override
    public void drawTexture3SliceV(Texture tex, float dx1, float dy1, float dx2, float dy2, float sx1, float sy1, float sx2, float sy2, float dv1, float dv2, float sv1, float sv2) {
        this.drawTexture(tex, dx1, dy1, dx2, dv1, sx1, sy1, sx2, sv1, 0, 0, 0, 1);
        this.drawTexture(tex, dx1, dv1, dx2, dv2, sx1, sv1, sx2, sv2, 0, 0, 2, 1);
        this.drawTexture(tex, dx1, dv2, dx2, dy2, sx1, sv2, sx2, sy2, 0, 0, 2, 0);
    }

    @Override
    public void drawTexture9Slice(Texture tex, float dx1, float dy1, float dx2, float dy2, float sx1, float sy1, float sx2, float sy2, float dh1, float dv1, float dh2, float dv2, float sh1, float sv1, float sh2, float sv2) {
        this.drawTexture(tex, dx1, dy1, dh1, dv1, sx1, sy1, sh1, sv1, 0, 1, 0, 1);
        this.drawTexture(tex, dh1, dy1, dh2, dv1, sh1, sy1, sh2, sv1, 2, 1, 0, 1);
        this.drawTexture(tex, dh2, dy1, dx2, dv1, sh2, sy1, sx2, sv1, 2, 0, 0, 1);
        this.drawTexture(tex, dx1, dv1, dh1, dv2, sx1, sv1, sh1, sv2, 0, 1, 2, 1);
        this.drawTexture(tex, dh1, dv1, dh2, dv2, sh1, sv1, sh2, sv2, 2, 1, 2, 1);
        this.drawTexture(tex, dh2, dv1, dx2, dv2, sh2, sv1, sx2, sv2, 2, 0, 2, 1);
        this.drawTexture(tex, dx1, dv2, dh1, dy2, sx1, sv2, sh1, sy2, 0, 1, 2, 0);
        this.drawTexture(tex, dh1, dv2, dh2, dy2, sh1, sv2, sh2, sy2, 2, 1, 2, 0);
        this.drawTexture(tex, dh2, dv2, dx2, dy2, sh2, sv2, sx2, sy2, 2, 0, 2, 0);
    }

    @Override
    public void drawTextureVO(Texture tex, float topopacity, float botopacity, float dx1, float dy1, float dx2, float dy2, float sx1, float sy1, float sx2, float sy2) {
        if (PrismSettings.debug) {
            System.out.println("* drawTextureVO");
        }
        int[] fractions = new int[]{0, 65536};
        int[] argb = new int[]{0xFFFFFF | (int)(topopacity * 255.0f) << 24, 0xFFFFFF | (int)(botopacity * 255.0f) << 24};
        Transform6 t6 = new Transform6();
        SWUtils.convertToPiscesTransform(this.tx, t6);
        this.pr.setLinearGradient(0, (int)(65536.0f * dy1), 0, (int)(65536.0f * dy2), fractions, argb, 0, t6);
        this.drawTexture(tex, 2, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, 0, 0, 0, 0);
    }

    @Override
    public void drawTextureRaw(Texture tex, float dx1, float dy1, float dx2, float dy2, float tx1, float ty1, float tx2, float ty2) {
        if (PrismSettings.debug) {
            System.out.println("+ drawTextureRaw");
        }
        int w = tex.getContentWidth();
        int h = tex.getContentHeight();
        this.drawTexture(tex, dx1, dy1, dx2, dy2, tx1 *= (float)w, ty1 *= (float)h, tx2 *= (float)w, ty2 *= (float)h);
    }

    @Override
    public void drawMappedTextureRaw(Texture tex, float dx1, float dy1, float dx2, float dy2, float tx11, float ty11, float tx21, float ty21, float tx12, float ty12, float tx22, float ty22) {
        if (PrismSettings.debug) {
            System.out.println("+ drawMappedTextureRaw");
        }
        double _mxx = this.tx.getMxx();
        double _myx = this.tx.getMyx();
        double _mxy = this.tx.getMxy();
        double _myy = this.tx.getMyy();
        double _mxt = this.tx.getMxt();
        double _myt = this.tx.getMyt();
        try {
            float mxx = tx21 - tx11;
            float myx = ty21 - ty11;
            float mxy = tx12 - tx11;
            float myy = ty12 - ty11;
            Affine2D tmpTx = new Affine2D(mxx, myx, mxy, myy, tx11, ty11);
            ((BaseTransform)tmpTx).invert();
            this.tx.setToIdentity();
            this.tx.deriveWithTranslation(dx1, dy1);
            this.tx.deriveWithConcatenation(dx2 - dx1, 0.0, 0.0, dy2 - dy2, 0.0, 0.0);
            this.tx.deriveWithConcatenation(tmpTx);
            this.drawTexture(tex, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, tex.getContentWidth(), tex.getContentHeight());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        this.tx.restoreTransform(_mxx, _myx, _mxy, _myy, _mxt, _myt);
    }

    @Override
    public boolean canReadBack() {
        return true;
    }

    @Override
    public RTTexture readBack(Rectangle view) {
        if (PrismSettings.debug) {
            System.out.println("+ readBack, rect: " + view + ", target.dims: " + this.target.getDimensions());
        }
        int w = Math.max(1, view.width);
        int h = Math.max(1, view.height);
        SWRTTexture rbb = this.context.validateRBBuffer(w, h);
        if (view.isEmpty()) {
            return rbb;
        }
        int[] pixels = rbb.getDataNoClone();
        this.target.getSurface().getRGB(pixels, 0, rbb.getPhysicalWidth(), view.x, view.y, w, h);
        return rbb;
    }

    @Override
    public void releaseReadBackBuffer(RTTexture view) {
    }

    @Override
    public void setState3D(boolean flag) {
    }

    @Override
    public boolean isState3D() {
        return false;
    }

    @Override
    public void setup3DRendering() {
    }

    @Override
    public void setPixelScaleFactor(float pixelScale) {
        this.pixelScale = pixelScale;
    }

    @Override
    public float getPixelScaleFactor() {
        return this.pixelScale;
    }

    @Override
    public void setLights(NGLightBase[] lights) {
    }

    @Override
    public NGLightBase[] getLights() {
        return null;
    }

    @Override
    public void blit(RTTexture srcTex, RTTexture dstTex, int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1) {
        Graphics g = dstTex.createGraphics();
        g.drawTexture(srcTex, dstX0, dstY0, dstX1, dstY1, srcX0, srcY0, srcX1, srcY1);
    }
}

